/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.eclipse.jdt.internal.compiler.apt.model;

import com.android.jack.eclipse.jdt.core.compiler.CharOperation;
import com.android.jack.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import com.android.jack.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import com.android.jack.eclipse.jdt.internal.compiler.apt.model.NameImpl;
import com.android.jack.eclipse.jdt.internal.compiler.batch.FileSystem;
import com.android.jack.eclipse.jdt.internal.compiler.env.INameEnvironment;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;

public class PackageElementImpl
extends ElementImpl
implements PackageElement {
    PackageElementImpl(BaseProcessingEnvImpl env, PackageBinding binding) {
        super(env, binding);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return v.visitPackage(this, p);
    }

    @Override
    protected AnnotationBinding[] getAnnotationBindings() {
        PackageBinding packageBinding = (PackageBinding)this._binding;
        char[][] compoundName = CharOperation.arrayConcat(packageBinding.compoundName, TypeConstants.PACKAGE_INFO_NAME);
        ReferenceBinding type = this._env.getLookupEnvironment().getType(compoundName);
        AnnotationBinding[] annotations = null;
        if (type != null && type.isValidBinding()) {
            annotations = type.getAnnotations();
        }
        return annotations;
    }

    @Override
    public List<? extends Element> getEnclosedElements() {
        PackageBinding binding = (PackageBinding)this._binding;
        LookupEnvironment environment = binding.environment;
        char[][][] typeNames = null;
        INameEnvironment nameEnvironment = binding.environment.nameEnvironment;
        if (nameEnvironment instanceof FileSystem) {
            typeNames = ((FileSystem)nameEnvironment).findTypeNames(binding.compoundName);
        }
        HashSet<Element> set = new HashSet<Element>();
        if (typeNames != null) {
            char[][][] cArray = typeNames;
            int n = typeNames.length;
            int n2 = 0;
            while (n2 < n) {
                char[][] typeName = cArray[n2];
                ReferenceBinding type = environment.getType(typeName);
                if (type != null && type.isValidBinding()) {
                    set.add(this._env.getFactory().newElement(type));
                }
                ++n2;
            }
        }
        ArrayList<Element> list = new ArrayList<Element>(set.size());
        list.addAll(set);
        return Collections.unmodifiableList(list);
    }

    @Override
    public Element getEnclosingElement() {
        return null;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.PACKAGE;
    }

    @Override
    PackageElement getPackage() {
        return this;
    }

    @Override
    public Name getSimpleName() {
        char[][] compoundName = ((PackageBinding)this._binding).compoundName;
        int length = compoundName.length;
        if (length == 0) {
            return new NameImpl(CharOperation.NO_CHAR);
        }
        return new NameImpl(compoundName[length - 1]);
    }

    @Override
    public Name getQualifiedName() {
        return new NameImpl(CharOperation.concatWith(((PackageBinding)this._binding).compoundName, '.'));
    }

    @Override
    public boolean isUnnamed() {
        PackageBinding binding = (PackageBinding)this._binding;
        return binding.compoundName == CharOperation.NO_CHAR_CHAR;
    }
}

