/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.rop.cst;

import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.IndexedItem;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.rop.cst.CstFieldRef;
import com.android.jack.dx.rop.cst.CstMethodRef;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.CstType;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class CstIndexMap {
    private final CstString[] strings;
    private final CstType[] types;
    private final CstMethodRef[] methods;
    private final CstFieldRef[] fields;
    private final CstPrototypeRef[] prototypes;

    public CstIndexMap(DexBuffer dexBuffer) {
        this.strings = new CstString[dexBuffer.strings().size()];
        this.types = new CstType[dexBuffer.typeNames().size()];
        this.methods = new CstMethodRef[dexBuffer.methodIds().size()];
        this.fields = new CstFieldRef[dexBuffer.fieldIds().size()];
        this.prototypes = new CstPrototypeRef[dexBuffer.protoIds().size()];
    }

    public void addStringMapping(@Nonnegative int index, CstString cstString) {
        assert (this.strings[index] == null || this.strings[index].compareTo(cstString) == 0);
        if (this.strings[index] == null) {
            this.strings[index] = cstString;
        }
    }

    public void addTypeMapping(@Nonnegative int index, CstType cstType) {
        assert (this.types[index] == null || this.types[index].compareTo(cstType) == 0);
        if (this.types[index] == null) {
            this.types[index] = cstType;
        }
    }

    public void addMethodMapping(@Nonnegative int index, CstMethodRef methodRef) {
        assert (this.methods[index] == null || this.methods[index].compareTo(methodRef) == 0);
        if (this.methods[index] == null) {
            this.methods[index] = methodRef;
        }
    }

    public void addPrototypeMapping(@Nonnegative int index, CstPrototypeRef prototypeRef) {
        assert (this.prototypes[index] == null || this.prototypes[index].compareTo(prototypeRef) == 0);
        if (this.prototypes[index] == null) {
            this.prototypes[index] = prototypeRef;
        }
    }

    public void addFieldMapping(@Nonnegative int index, CstFieldRef fieldRef) {
        assert (this.fields[index] == null || this.fields[index].compareTo(fieldRef) == 0);
        if (this.fields[index] == null) {
            this.fields[index] = fieldRef;
        }
    }

    public int getRemappedCstStringIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.strings[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    public int getRemappedCstTypeIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.types[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    public int getRemappedCstBaseMethodRefIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.methods[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    public int getRemappedCstFieldRefIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.fields[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    public int getRemappedCstPrototypeRefIndex(DexFile file, @Nonnegative int index) {
        IndexedItem indexedItem = file.findItemOrNull(this.prototypes[index]);
        assert (indexedItem != null);
        return indexedItem.getIndex();
    }

    @Nonnull
    public CstMethodRef getCstMethodRef(@Nonnegative int index) {
        CstMethodRef cstMethodRef = this.methods[index];
        assert (cstMethodRef != null);
        return cstMethodRef;
    }

    @Nonnull
    public CstFieldRef getCstFieldRef(@Nonnegative int index) {
        CstFieldRef cstFieldRef = this.fields[index];
        assert (cstFieldRef != null);
        return cstFieldRef;
    }

    @Nonnull
    public CstString getCstString(@Nonnegative int index) {
        CstString cstString = this.strings[index];
        assert (cstString != null);
        return cstString;
    }

    @Nonnull
    public CstType getCstType(@Nonnegative int index) {
        CstType cstType = this.types[index];
        assert (cstType != null);
        return cstType;
    }
}

