/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.code;

import com.android.jack.dx.dex.code.DalvInsn;
import com.android.jack.dx.dex.code.Dop;
import com.android.jack.dx.dex.code.FixedSizeInsn;
import com.android.jack.dx.rop.code.RegisterSpecList;
import com.android.jack.dx.rop.code.SourcePosition;
import com.android.jack.dx.rop.cst.Constant;

public final class CstInsn
extends FixedSizeInsn {
    private final Constant constant;
    private int index;

    public CstInsn(Dop opcode, SourcePosition position, RegisterSpecList registers, Constant constant) {
        super(opcode, position, registers);
        if (constant == null) {
            throw new NullPointerException("constant == null");
        }
        this.constant = constant;
        this.index = -1;
    }

    @Override
    public DalvInsn withOpcode(Dop opcode) {
        CstInsn result = new CstInsn(opcode, this.getPosition(), this.getRegisters(), this.constant);
        if (this.index >= 0) {
            result.setIndex(this.index);
        }
        return result;
    }

    @Override
    public DalvInsn withRegisters(RegisterSpecList registers) {
        CstInsn result = new CstInsn(this.getOpcode(), this.getPosition(), registers, this.constant);
        if (this.index >= 0) {
            result.setIndex(this.index);
        }
        return result;
    }

    public Constant getConstant() {
        return this.constant;
    }

    public int getIndex() {
        if (this.index < 0) {
            throw new RuntimeException("index not yet set for " + this.constant);
        }
        return this.index;
    }

    public boolean hasIndex() {
        return this.index >= 0;
    }

    public void setIndex(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index < 0");
        }
        if (this.index >= 0) {
            throw new RuntimeException("index already set");
        }
        this.index = index;
    }

    @Override
    protected String argString() {
        return this.constant.toHuman();
    }
}

