/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.config.id;

import com.android.sched.util.codec.KeyValueCodec;
import com.android.sched.util.config.ConfigChecker;
import com.android.sched.util.config.MissingPropertyException;
import com.android.sched.util.config.PropertyIdException;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.expression.LongExpression;
import com.android.sched.util.config.id.PropertyId;
import javax.annotation.Nonnull;

public class JavaVersionPropertyId
extends PropertyId<JavaVersion> {
    @Nonnull
    private static KeyValueCodec<JavaVersion> parser;

    @Nonnull
    public JavaVersionPropertyId addCategory(@Nonnull Class<? extends Category> category) {
        super.addCategory((Class)category);
        return this;
    }

    @Override
    @Nonnull
    public JavaVersionPropertyId addCategory(@Nonnull Category category) {
        super.addCategory(category);
        return this;
    }

    @Nonnull
    public static JavaVersionPropertyId create(@Nonnull String name, @Nonnull String description) {
        return new JavaVersionPropertyId(name, description);
    }

    protected JavaVersionPropertyId(@Nonnull String name, @Nonnull String description) {
        super(name, description, parser);
    }

    @Nonnull
    public JavaVersionPropertyId addDefaultValue(@Nonnull String defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Nonnull
    public JavaVersionPropertyId addDefaultValue(@Nonnull JavaVersion defaultValue) {
        super.addDefaultValue(defaultValue);
        return this;
    }

    @Override
    @Nonnull
    public JavaVersionPropertyId requiredIf(@Nonnull BooleanExpression expression) {
        super.requiredIf(expression);
        return this;
    }

    @Nonnull
    public BooleanExpression is(final @Nonnull JavaVersion enumValue) {
        return new BooleanExpression(){

            @Override
            public boolean eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!JavaVersionPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(JavaVersionPropertyId.this);
                }
                return checker.parse(JavaVersionPropertyId.this) == enumValue;
            }

            @Override
            @Nonnull
            public String getDescription() {
                return JavaVersionPropertyId.this.format(this.formatPropertyName(JavaVersionPropertyId.this), true, JavaVersionPropertyId.this.getCodec().formatValue(enumValue));
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) throws PropertyIdException {
                try {
                    return JavaVersionPropertyId.this.format(this.formatPropertyName(checker, JavaVersionPropertyId.this), this.eval(checker), JavaVersionPropertyId.this.getCodec().formatValue(checker.parse(JavaVersionPropertyId.this)));
                }
                catch (MissingPropertyException e) {
                    return e.getMessage();
                }
            }
        };
    }

    @Nonnull
    public LongExpression getValue() {
        return new LongExpression(){

            @Override
            public long eval(@Nonnull ConfigChecker checker) throws PropertyIdException, MissingPropertyException {
                if (!JavaVersionPropertyId.this.isRequired(checker)) {
                    throw new MissingPropertyException(JavaVersionPropertyId.this);
                }
                return checker.parse(JavaVersionPropertyId.this).ordinal();
            }

            @Override
            @Nonnull
            public String getDescription() {
                return this.formatPropertyName(JavaVersionPropertyId.this);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return this.formatPropertyName(checker, JavaVersionPropertyId.this);
            }
        };
    }

    @Nonnull
    public static LongExpression getConstant(final @Nonnull JavaVersion version) {
        return new LongExpression(){

            @Override
            public long eval(@Nonnull ConfigChecker checker) {
                return version.ordinal();
            }

            @Override
            @Nonnull
            public String getDescription() {
                return parser.formatValue(version);
            }

            @Override
            @Nonnull
            public String getCause(@Nonnull ConfigChecker checker) {
                return parser.formatValue(version);
            }
        };
    }

    @Nonnull
    private String format(@Nonnull String left, boolean set, @Nonnull String right) {
        StringBuilder sb = new StringBuilder();
        sb.append(left);
        sb.append(" is ");
        if (!set) {
            sb.append("not ");
        }
        sb.append("set to '");
        sb.append(right);
        sb.append('\'');
        return sb.toString();
    }

    static {
        KeyValueCodec.Entry[] elements = new KeyValueCodec.Entry[]{new KeyValueCodec.Entry<JavaVersion>("1.3", JavaVersion.JAVA_3), new KeyValueCodec.Entry<JavaVersion>("1.4", JavaVersion.JAVA_4), new KeyValueCodec.Entry<JavaVersion>("1.5", JavaVersion.JAVA_5), new KeyValueCodec.Entry<JavaVersion>("5.0", JavaVersion.JAVA_5), new KeyValueCodec.Entry<JavaVersion>("5", JavaVersion.JAVA_5), new KeyValueCodec.Entry<JavaVersion>("1.6", JavaVersion.JAVA_6), new KeyValueCodec.Entry<JavaVersion>("6.0", JavaVersion.JAVA_6), new KeyValueCodec.Entry<JavaVersion>("6", JavaVersion.JAVA_6), new KeyValueCodec.Entry<JavaVersion>("1.7", JavaVersion.JAVA_7), new KeyValueCodec.Entry<JavaVersion>("7.0", JavaVersion.JAVA_7), new KeyValueCodec.Entry<JavaVersion>("7", JavaVersion.JAVA_7), new KeyValueCodec.Entry<JavaVersion>("1.8", JavaVersion.JAVA_8), new KeyValueCodec.Entry<JavaVersion>("8.0", JavaVersion.JAVA_8), new KeyValueCodec.Entry<JavaVersion>("8", JavaVersion.JAVA_8)};
        parser = new KeyValueCodec("version", elements).ignoreCase();
    }

    public static enum JavaVersion {
        JAVA_3("1.3"),
        JAVA_4("1.4"),
        JAVA_5("1.5"),
        JAVA_6("1.6"),
        JAVA_7("1.7"),
        JAVA_8("1.8");

        @Nonnull
        private final String value;

        private JavaVersion(String value) {
            this.value = value;
        }

        @Nonnull
        public String toString() {
            return this.value;
        }
    }
}

