/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.rop;

import com.android.jack.dx.rop.code.BasicBlock;
import com.android.jack.dx.rop.code.BasicBlockList;
import com.android.jack.dx.rop.code.InsnList;
import com.android.jack.dx.util.IntList;
import java.util.ArrayList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

class RopBasicBlockManager {
    static final int PARAM_ASSIGNMENT = -1;
    static final int RETURN = -2;
    static final int SPECIAL_LABEL_COUNT = 7;
    @Nonnegative
    private final int maxLabel;
    @Nonnull
    private final ArrayList<BasicBlock> basicBlocks;

    RopBasicBlockManager(@Nonnegative int maxLabel) {
        this.maxLabel = maxLabel;
        this.basicBlocks = new ArrayList(maxLabel * 2 + 10);
    }

    @Nonnull
    BasicBlock createBasicBlock(@Nonnegative int label, @Nonnull InsnList insns, @Nonnull IntList successors, int primarySuccessor) {
        BasicBlock bb = new BasicBlock(label, insns, successors, primarySuccessor);
        this.basicBlocks.add(bb);
        return bb;
    }

    @Nonnull
    BasicBlockList getBasicBlockList() {
        int sz = this.basicBlocks.size();
        BasicBlockList bbl = new BasicBlockList(sz);
        for (int i = 0; i < sz; ++i) {
            bbl.set(i, this.basicBlocks.get(i));
        }
        bbl.setImmutable();
        return bbl;
    }

    @Nonnegative
    int getMinimumUnreservedLabel() {
        return this.maxLabel * 2 + 7;
    }

    @Nonnegative
    int getAvailableLabel() {
        int candidate = this.getMinimumUnreservedLabel();
        for (BasicBlock bb : this.basicBlocks) {
            int label = bb.getLabel();
            if (label < candidate) continue;
            candidate = label + 1;
        }
        return candidate;
    }

    @Nonnegative
    int getSpecialLabel(int label) {
        assert (label < 0) : "label is supposed to be negative";
        return this.maxLabel * 2 + ~label;
    }
}

