/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.compatibility;

import com.android.jack.Jack;
import com.android.jack.ir.HasSourceInfo;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.reporting.Reportable;
import javax.annotation.Nonnull;

public class StaticMethodReportable
implements Reportable,
HasSourceInfo {
    @Nonnull
    private final JMethod method;

    public StaticMethodReportable(@Nonnull JMethod method) {
        this.method = method;
    }

    @Override
    @Nonnull
    public String getMessage() {
        TypePackageAndMethodFormatter formatter = Jack.getUserFriendlyFormatter();
        return "Static method " + formatter.getName(this.method) + " not supported in Android API level less than " + 24L;
    }

    @Override
    @Nonnull
    public Reportable.ProblemLevel getDefaultProblemLevel() {
        return Reportable.ProblemLevel.ERROR;
    }

    @Override
    public SourceInfo getSourceInfo() {
        return this.method.getSourceInfo();
    }
}

