/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.annotations;

import com.android.jack.Jack;
import com.android.jack.backend.dex.annotations.tag.ReflectAnnotations;
import com.android.jack.google.common.collect.ImmutableList;
import com.android.jack.google.common.collect.Ordering;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JArrayLiteral;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JIntLiteral;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JMethodLiteral;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JNameValuePair;
import com.android.jack.ir.ast.JNullLiteral;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JStringLiteral;
import com.android.jack.ir.ast.JValueLiteral;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.ast.marker.GenericSignature;
import com.android.jack.ir.ast.marker.SimpleName;
import com.android.jack.ir.ast.marker.ThrownExceptionMarker;
import com.android.jack.ir.formatter.InternalFormatter;
import com.android.jack.ir.formatter.TypeFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.lookup.CommonTypes;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.scheduling.feature.SourceVersion8;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.shrob.obfuscation.FinalNames;
import com.android.jack.transformations.request.AddAnnotation;
import com.android.jack.transformations.request.PutNameValuePair;
import com.android.jack.transformations.request.TransformationRequest;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.Optional;
import com.android.sched.schedulable.Protect;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.ToSupport;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.With;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Add annotations used by reflection")
@Synchronized
@Transform(add={ReflectAnnotations.class, JAnnotation.class, JNameValuePair.class, JClassLiteral.class, JStringLiteral.class, JMethodLiteral.class, JArrayLiteral.class, JNullLiteral.class, JIntLiteral.class})
@Constraint(need={GenericSignature.class, SimpleName.class, FinalNames.class})
@Protect(add={GenericSignature.class, SimpleName.class}, unprotect={@With(remove={ReflectAnnotations.class})})
@Optional(value={@ToSupport(feature={SourceVersion8.class}, add={@Constraint(no={JAnnotation.RepeatedAnnotation.class})})})
@Filter(value={TypeWithoutPrebuiltFilter.class})
@Access(value=JSession.class)
public class ReflectAnnotationsAdder
implements RunnableSchedulable<JDefinedClassOrInterface> {
    @Override
    public synchronized void run(@Nonnull JDefinedClassOrInterface declaredType) {
        TransformationRequest tr = new TransformationRequest(declaredType);
        Visitor visitor = new Visitor(tr, Jack.getSession().getPhantomLookup());
        visitor.accept(declaredType);
        tr.commit();
    }

    private static class Visitor
    extends JVisitor {
        @Nonnull
        private final TransformationRequest request;
        @Nonnull
        private final JClass javaLangClass;
        @Nonnull
        private static final String ELT_VALUE = "value";
        @Nonnull
        private static final String ELT_NAME = "name";
        @Nonnull
        private static final String ELT_ACCESS_FLAGS = "accessFlags";
        @Nonnull
        private final JAnnotationType defaultAnnotationType;
        @Nonnull
        private final JAnnotationType signatureAnnotationType;
        @Nonnull
        private final JAnnotationType enclosingMethodAnnotationType;
        @Nonnull
        private final JAnnotationType enclosingClassAnnotationType;
        @Nonnull
        private final JAnnotationType throwsAnnotationType;
        @Nonnull
        private final JAnnotationType innerAnnotationType;
        @Nonnull
        private final JAnnotationType memberClassAnnotationType;
        @Nonnull
        TypeFormatter orderingFormatter = InternalFormatter.getFormatter();
        @Nonnull
        private final Ordering<JClassOrInterface> typeOrdering = Ordering.from(new Comparator<JClassOrInterface>(){

            @Override
            public int compare(@Nonnull JClassOrInterface t1, @Nonnull JClassOrInterface t2) {
                return Visitor.this.orderingFormatter.getName(t1).compareTo(Visitor.this.orderingFormatter.getName(t2));
            }
        });

        public Visitor(@Nonnull TransformationRequest request, @Nonnull JPhantomLookup lookup) {
            this.request = request;
            this.javaLangClass = lookup.getClass(CommonTypes.JAVA_LANG_CLASS);
            this.defaultAnnotationType = lookup.getAnnotationType("Ldalvik/annotation/AnnotationDefault;");
            this.signatureAnnotationType = lookup.getAnnotationType("Ldalvik/annotation/Signature;");
            this.enclosingMethodAnnotationType = lookup.getAnnotationType("Ldalvik/annotation/EnclosingMethod;");
            this.enclosingClassAnnotationType = lookup.getAnnotationType("Ldalvik/annotation/EnclosingClass;");
            this.throwsAnnotationType = lookup.getAnnotationType("Ldalvik/annotation/Throws;");
            this.innerAnnotationType = lookup.getAnnotationType("Ldalvik/annotation/InnerClass;");
            this.memberClassAnnotationType = lookup.getAnnotationType("Ldalvik/annotation/MemberClasses;");
        }

        @Nonnull
        private JMethodIdWide getOrCreateMethodId(@Nonnull JAnnotationType type, @Nonnull String name) {
            return type.getOrCreateMethodIdWide(name, Collections.emptyList(), MethodKind.INSTANCE_VIRTUAL);
        }

        @Override
        public boolean visit(@Nonnull JMethod x) {
            return false;
        }

        @Override
        public void endVisit(@Nonnull JDefinedClassOrInterface x) {
            GenericSignature marker;
            this.addMemberClasses(x);
            JClassOrInterface enclosingType = x.getEnclosingType();
            if (enclosingType != null) {
                this.addInnerClass(x);
                if (x instanceof JDefinedClass && ((JDefinedClass)x).getEnclosingMethod() != null) {
                    this.addEnclosingMethod(x);
                } else {
                    this.addEnclosingClass(x);
                }
            }
            if ((marker = x.getMarker(GenericSignature.class)) != null) {
                this.addSignature(x, marker.getGenericSignature(), x.getSourceInfo());
            }
        }

        @Override
        public void endVisit(@Nonnull JField x) {
            GenericSignature marker = x.getMarker(GenericSignature.class);
            if (marker != null) {
                this.addSignature(x, marker.getGenericSignature(), x.getSourceInfo());
            }
        }

        @Override
        public void endVisit(@Nonnull JMethod x) {
            String genericSignature;
            this.addThrows(x);
            GenericSignature marker = x.getMarker(GenericSignature.class);
            if (marker != null && (genericSignature = marker.getGenericSignature()) != null) {
                this.addSignature(x, genericSignature, x.getSourceInfo());
            }
        }

        private void addSignature(@Nonnull Annotable annotable, @Nonnull String signature, @Nonnull SourceInfo info) {
            JAnnotation annotation = this.createAnnotation(annotable, this.signatureAnnotationType, info);
            JArrayLiteral literal = this.buildSignatureAnnotationValue(signature, info);
            JMethodIdWide methodId = this.getOrCreateMethodId(this.signatureAnnotationType, ELT_VALUE);
            JNameValuePair valuePair = new JNameValuePair(info, methodId, literal);
            assert (annotation.getNameValuePair(methodId) == null) : "Type can not have more than one generic signature";
            this.request.append(new PutNameValuePair(annotation, valuePair));
        }

        private void addEnclosingMethod(@Nonnull JDefinedClassOrInterface type) {
            JDefinedClass classType;
            JMethod method;
            if (type instanceof JDefinedClass && (method = (classType = (JDefinedClass)type).getEnclosingMethod()) != null) {
                SourceInfo info = type.getSourceInfo();
                JAnnotation annotation = this.createAnnotation(type, this.enclosingMethodAnnotationType, info);
                JMethodLiteral newLiteral = new JMethodLiteral(method, info);
                JMethodIdWide methodId = this.getOrCreateMethodId(this.enclosingMethodAnnotationType, ELT_VALUE);
                JNameValuePair valuePair = new JNameValuePair(info, methodId, newLiteral);
                assert (annotation.getNameValuePair(methodId) == null) : "Type can not have more than one enclosing method";
                this.request.append(new PutNameValuePair(annotation, valuePair));
            }
        }

        private void addThrows(@Nonnull JMethod method) {
            ThrownExceptionMarker marker = method.getMarker(ThrownExceptionMarker.class);
            if (marker != null) {
                List<JClass> throwns = marker.getThrownExceptions();
                SourceInfo info = method.getSourceInfo();
                JAnnotation annotation = this.createAnnotation(method, this.throwsAnnotationType, info);
                ArrayList<JLiteral> literals = new ArrayList<JLiteral>();
                for (JClass thrown : throwns) {
                    literals.add(new JClassLiteral(info, thrown, this.javaLangClass));
                }
                JMethodIdWide methodId = this.getOrCreateMethodId(this.throwsAnnotationType, ELT_VALUE);
                JArrayLiteral array = new JArrayLiteral(info, literals);
                JNameValuePair valuePair = new JNameValuePair(info, methodId, array);
                this.request.append(new PutNameValuePair(annotation, valuePair));
            }
        }

        private void addMemberClasses(@Nonnull JDefinedClassOrInterface type) {
            ArrayList<JLiteral> literals = new ArrayList<JLiteral>();
            SourceInfo info = type.getSourceInfo();
            ImmutableList<JClassOrInterface> sortedMemberTypes = this.typeOrdering.immutableSortedCopy(type.getMemberTypes());
            for (JClassOrInterface member : sortedMemberTypes) {
                if (member instanceof JDefinedClass && ((JDefinedClass)member).getEnclosingMethod() != null) continue;
                literals.add(new JClassLiteral(info, member, this.javaLangClass));
            }
            if (!literals.isEmpty()) {
                JMethodIdWide methodId = this.getOrCreateMethodId(this.memberClassAnnotationType, ELT_VALUE);
                JAnnotation annotation = this.getAnnotation(type, this.memberClassAnnotationType, info);
                JArrayLiteral array = new JArrayLiteral(info, literals);
                JNameValuePair valuePair = new JNameValuePair(info, methodId, array);
                this.request.append(new PutNameValuePair(annotation, valuePair));
            }
        }

        private void addEnclosingClass(@Nonnull JDefinedClassOrInterface innerType) {
            SourceInfo info = innerType.getSourceInfo();
            JAnnotation annotation = this.createAnnotation(innerType, this.enclosingClassAnnotationType, info);
            JClassLiteral newValue = new JClassLiteral(info, innerType.getEnclosingType(), this.javaLangClass);
            JMethodIdWide methodId = this.getOrCreateMethodId(this.enclosingClassAnnotationType, ELT_VALUE);
            JNameValuePair valuePair = new JNameValuePair(info, methodId, newValue);
            this.request.append(new PutNameValuePair(annotation, valuePair));
        }

        private void addInnerClass(@Nonnull JDefinedClassOrInterface innerType) {
            SourceInfo info = innerType.getSourceInfo();
            JAnnotation annotation = this.createAnnotation(innerType, this.innerAnnotationType, info);
            SimpleName marker = innerType.getMarker(SimpleName.class);
            assert (marker != null);
            String innerShortName = marker.getSimpleName();
            JValueLiteral newValue = !innerShortName.isEmpty() ? new JStringLiteral(info, innerShortName) : new JNullLiteral(info);
            JMethodIdWide nameMethodId = this.getOrCreateMethodId(this.innerAnnotationType, ELT_NAME);
            JNameValuePair nameValuePair = new JNameValuePair(info, nameMethodId, newValue);
            this.request.append(new PutNameValuePair(annotation, nameValuePair));
            int accessFlags = innerType.getModifier();
            if (innerType.isAnonymous()) {
                accessFlags &= 0xFFFFFFEF;
            }
            if (JModifier.isInterface(accessFlags)) {
                accessFlags |= 8;
            }
            JMethodIdWide flagsMethodId = this.getOrCreateMethodId(this.innerAnnotationType, ELT_ACCESS_FLAGS);
            JNameValuePair flagsValuePair = new JNameValuePair(info, flagsMethodId, new JIntLiteral(info, accessFlags &= 0x761F));
            this.request.append(new PutNameValuePair(annotation, flagsValuePair));
        }

        @Nonnull
        private JAnnotation createAnnotation(@Nonnull Annotable annotable, @Nonnull JAnnotationType annotationType, @Nonnull SourceInfo info) {
            JAnnotation annotation = new JAnnotation(info, JRetentionPolicy.SYSTEM, annotationType);
            this.request.append(new AddAnnotation(annotation, annotable));
            return annotation;
        }

        private boolean isSystemAnnotation(@Nonnull JAnnotationType annotationType) {
            return annotationType.isSameType(this.defaultAnnotationType) || annotationType.isSameType(this.enclosingClassAnnotationType) || annotationType.isSameType(this.enclosingMethodAnnotationType) || annotationType.isSameType(this.innerAnnotationType) || annotationType.isSameType(this.memberClassAnnotationType) || annotationType.isSameType(this.signatureAnnotationType) || annotationType.isSameType(this.throwsAnnotationType);
        }

        @Nonnull
        private JAnnotation getAnnotation(@Nonnull Annotable annotable, @Nonnull JAnnotationType annotationType, @Nonnull SourceInfo info) {
            assert (this.isSystemAnnotation(annotationType));
            JAnnotation annotation = null;
            Collection<JAnnotation> annotations = annotable.getAnnotations(annotationType);
            if (annotations.isEmpty()) {
                annotation = this.createAnnotation(annotable, annotationType, info);
            } else {
                assert (annotations.size() == 1);
                annotation = annotations.iterator().next();
            }
            return annotation;
        }

        @Nonnull
        private JArrayLiteral buildSignatureAnnotationValue(@Nonnull String signature, @Nonnull SourceInfo info) {
            int sigLength = signature.length();
            ArrayList<JLiteral> pieces = new ArrayList<JLiteral>();
            int at = 0;
            while (at < sigLength) {
                int endAt;
                char c = signature.charAt(at);
                if (c == 'L') {
                    for (endAt = at + 1; endAt < sigLength; ++endAt) {
                        c = signature.charAt(endAt);
                        if (c == ';') {
                            ++endAt;
                        } else if (c != '<') {
                            continue;
                        }
                        break;
                    }
                } else {
                    while (endAt < sigLength && (c = signature.charAt(endAt)) != 'L') {
                        ++endAt;
                    }
                }
                pieces.add(new JStringLiteral(info, signature.substring(at, endAt)));
                at = endAt;
            }
            return new JArrayLiteral(info, pieces);
        }
    }
}

