/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.backend.dex.ConstantBuilder;
import com.android.jack.backend.dex.annotations.tag.ReflectAnnotations;
import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.dx.rop.annotation.Annotation;
import com.android.jack.dx.rop.annotation.AnnotationVisibility;
import com.android.jack.dx.rop.annotation.Annotations;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JRetentionPolicy;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.library.PrebuiltCompatibility;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Protect;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import java.util.Collection;
import javax.annotation.Nonnull;

@HasKeyId
@Constraint(need={JAnnotation.class, ReflectAnnotations.class})
@Protect(add={JAnnotation.class}, modify={JAnnotation.class}, remove={JAnnotation.class})
public class AnnotationBuilder {
    @Nonnull
    public static final BooleanPropertyId CLASS_RETENTION = ((BooleanPropertyId)BooleanPropertyId.create("jack.dex.annotation.class-retention", "Emit annotations with class retention in the final dex").addDefaultValue(Boolean.TRUE).addCategory(PrebuiltCompatibility.class)).addCategory(DumpInLibrary.class);
    private final boolean enableBuildRetention = ThreadConfig.get(CLASS_RETENTION);
    @Nonnull
    private static SourceAnnotationException sourceAnnotationException = new SourceAnnotationException();
    @Nonnull
    private static BuildAnnotationException buildAnnotationException = new BuildAnnotationException();
    @Nonnull
    private final ConstantBuilder constantBuilder = new ConstantBuilder();

    @Nonnull
    public Annotations createAnnotations(@Nonnull Collection<JAnnotation> annotations) {
        Annotations ropAnnotations = new Annotations();
        for (JAnnotation annotation : annotations) {
            Annotation ropAnnotation;
            try {
                ropAnnotation = this.createAnnotation(annotation);
            }
            catch (SourceAnnotationException e) {
                continue;
            }
            catch (BuildAnnotationException e) {
                continue;
            }
            ropAnnotations.add(ropAnnotation);
        }
        ropAnnotations.setImmutable();
        return ropAnnotations;
    }

    @Nonnull
    private Annotation createAnnotation(@Nonnull JAnnotation annotation) throws SourceAnnotationException, BuildAnnotationException {
        Annotation ropAnnotation = new Annotation(RopHelper.getCstType(annotation.getType()), this.getVisibility(annotation.getRetentionPolicy()));
        this.constantBuilder.createAnnotationPairs(annotation, ropAnnotation);
        ropAnnotation.setImmutable();
        return ropAnnotation;
    }

    @Nonnull
    private AnnotationVisibility getVisibility(@Nonnull JRetentionPolicy retentionPolicy) throws SourceAnnotationException, BuildAnnotationException {
        switch (retentionPolicy) {
            case SOURCE: {
                throw sourceAnnotationException;
            }
            case CLASS: {
                if (this.enableBuildRetention) {
                    return AnnotationVisibility.BUILD;
                }
                throw buildAnnotationException;
            }
            case RUNTIME: {
                return AnnotationVisibility.RUNTIME;
            }
            case SYSTEM: {
                return AnnotationVisibility.SYSTEM;
            }
        }
        throw new AssertionError();
    }

    private static class BuildAnnotationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private BuildAnnotationException() {
        }
    }

    private static class SourceAnnotationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private SourceAnnotationException() {
        }
    }
}

