/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.api.v01.impl;

import com.android.jack.IllegalOptionsException;
import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.JackUserException;
import com.android.jack.Options;
import com.android.jack.api.impl.ApiFeature;
import com.android.jack.api.impl.JackConfigImpl;
import com.android.jack.api.v01.Api01CompilationTask;
import com.android.jack.api.v01.Api01Config;
import com.android.jack.api.v01.CompilationException;
import com.android.jack.api.v01.ConfigurationException;
import com.android.jack.api.v01.DebugInfoLevel;
import com.android.jack.api.v01.JavaSourceVersion;
import com.android.jack.api.v01.MultiDexKind;
import com.android.jack.api.v01.ReporterKind;
import com.android.jack.api.v01.ResourceCollisionPolicy;
import com.android.jack.api.v01.TypeCollisionPolicy;
import com.android.jack.api.v01.UnrecoverableException;
import com.android.jack.api.v01.VerbosityLevel;
import com.android.jack.api.v04.impl.Api04ConfigImpl;
import com.android.jack.config.id.JavaVersionPropertyId;
import com.android.jack.frontend.FrontendCompilationException;
import com.android.jack.google.common.base.Joiner;
import com.android.jack.reporting.Reporter;
import com.android.jack.resource.ResourceImporter;
import com.android.jack.shrob.obfuscation.MappingPrinter;
import com.android.sched.scheduler.ProcessException;
import com.android.sched.util.RunnableHooks;
import com.android.sched.util.codec.ListCodec;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class Api01ConfigImpl
implements JackConfigImpl,
Api01Config {
    @Nonnull
    protected final Options options = new Options();
    @CheckForNull
    private Class<? extends ApiFeature> api;

    @Override
    @Nonnull
    public Api01CompilationTask getTask() throws ConfigurationException {
        assert (this.api != null);
        RunnableHooks configHooks = new RunnableHooks();
        try {
            Jack.check(this.api, this.options, configHooks);
        }
        catch (com.android.sched.util.config.ConfigurationException e) {
            try {
                configHooks.runHooks();
            }
            catch (Error | RuntimeException throwable) {
                // empty catch block
            }
            throw new ConfigurationException(e.getMessage(), e);
        }
        catch (IllegalOptionsException e) {
            try {
                configHooks.runHooks();
            }
            catch (Error | RuntimeException throwable) {
                // empty catch block
            }
            throw new ConfigurationException(e.getMessage(), e);
        }
        return new Api01CompilationTaskImpl(this.api, this.options, configHooks);
    }

    @Override
    public void setClasspath(@Nonnull List<File> classpath) {
        this.options.setClasspath(Joiner.on(File.pathSeparator).join(classpath));
    }

    @Override
    public void setDebugInfoLevel(@Nonnull DebugInfoLevel debugLevel) throws ConfigurationException {
        switch (debugLevel) {
            case FULL: {
                this.options.addProperty(Options.EMIT_LOCAL_DEBUG_INFO.getName(), "true");
                this.options.addProperty(Options.EMIT_LINE_NUMBER_DEBUG_INFO.getName(), "true");
                this.options.addProperty(Options.EMIT_SOURCE_FILE_DEBUG_INFO.getName(), "true");
                break;
            }
            case LINES: {
                this.options.addProperty(Options.EMIT_LOCAL_DEBUG_INFO.getName(), "false");
                this.options.addProperty(Options.EMIT_LINE_NUMBER_DEBUG_INFO.getName(), "true");
                this.options.addProperty(Options.EMIT_SOURCE_FILE_DEBUG_INFO.getName(), "true");
                break;
            }
            case NONE: {
                this.options.addProperty(Options.EMIT_LOCAL_DEBUG_INFO.getName(), "false");
                this.options.addProperty(Options.EMIT_LINE_NUMBER_DEBUG_INFO.getName(), "false");
                this.options.addProperty(Options.EMIT_SOURCE_FILE_DEBUG_INFO.getName(), "false");
                break;
            }
            default: {
                throw new ConfigurationException("Debug info level '" + debugLevel.toString() + "' is unsupported");
            }
        }
    }

    @Override
    public void setImportedJackLibraryFiles(@Nonnull List<File> importedJackLibraryFiles) {
        this.options.setImportedLibraries(importedJackLibraryFiles);
    }

    @Override
    public void setIncrementalDir(@Nonnull File incrementalDir) {
        this.options.setIncrementalFolder(incrementalDir);
    }

    @Override
    public void setJarJarConfigFiles(@Nonnull List<File> jarJarConfigFiles) {
        this.options.setJarjarRulesFiles(Api04ConfigImpl.manageFilesCharsetAsList(jarJarConfigFiles));
    }

    @Override
    public void setJavaSourceVersion(@Nonnull JavaSourceVersion javaSourceVersion) throws ConfigurationException {
        JavaVersionPropertyId.JavaVersion javaSourceVersionWrapped = null;
        switch (javaSourceVersion) {
            case JAVA_3: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_3;
                break;
            }
            case JAVA_4: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_4;
                break;
            }
            case JAVA_5: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_5;
                break;
            }
            case JAVA_6: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_6;
                break;
            }
            case JAVA_7: {
                javaSourceVersionWrapped = JavaVersionPropertyId.JavaVersion.JAVA_7;
                break;
            }
            default: {
                throw new ConfigurationException("Java source version '" + (Object)((Object)javaSourceVersion) + "' is unsupported");
            }
        }
        this.options.addProperty(Options.JAVA_SOURCE_VERSION.getName(), javaSourceVersionWrapped.toString());
    }

    @Override
    public void setMetaDirs(@Nonnull List<File> metaDirs) {
        this.options.setMetaDirs(metaDirs);
    }

    @Override
    public void setMultiDexKind(@Nonnull MultiDexKind multiDexKind) throws ConfigurationException {
        switch (multiDexKind) {
            case LEGACY: {
                this.options.setMultiDexKind(Options.MultiDexKind.LEGACY);
                break;
            }
            case NATIVE: {
                this.options.setMultiDexKind(Options.MultiDexKind.NATIVE);
                break;
            }
            case NONE: {
                this.options.setMultiDexKind(Options.MultiDexKind.NONE);
                break;
            }
            default: {
                throw new ConfigurationException("Multi dex kind '" + (Object)((Object)multiDexKind) + "' is unsupported");
            }
        }
    }

    @Override
    public void setObfuscationMappingOutputFile(@Nonnull File obfuscationMappingOutputFile) {
        this.options.addProperty(MappingPrinter.MAPPING_OUTPUT_ENABLED.getName(), "true");
        this.options.addProperty(MappingPrinter.MAPPING_OUTPUT_FILE.getName(), Api04ConfigImpl.manageFileCharset(obfuscationMappingOutputFile).getPath());
    }

    @Override
    public void setOutputDexDir(@Nonnull File outputDexDir) {
        this.options.setOutputDir(outputDexDir);
    }

    @Override
    public void setOutputJackFile(@Nonnull File outputJackFile) {
        this.options.setJayceOutputZip(outputJackFile);
    }

    @Override
    public void setProcessorNames(@Nonnull List<String> processorNames) {
        this.options.addProperty(Options.ANNOTATION_PROCESSOR_MANUAL.getName(), "true");
        this.options.addProperty(Options.ANNOTATION_PROCESSOR_MANUAL_LIST.getName(), ((ListCodec)Options.ANNOTATION_PROCESSOR_MANUAL_LIST.getCodec()).formatValue(processorNames));
    }

    @Override
    public void setProcessorOptions(@Nonnull Map<String, String> processorOptions) {
        this.options.addProperty(Options.ANNOTATION_PROCESSOR_OPTIONS.getName(), Options.ANNOTATION_PROCESSOR_OPTIONS.getCodec().formatValue(processorOptions));
    }

    @Override
    public void setProcessorPath(@Nonnull List<File> processorPath) {
        this.options.addProperty(Options.ANNOTATION_PROCESSOR_PATH.getName(), "true");
        this.options.addProperty(Options.ANNOTATION_PROCESSOR_PATH_LIST.getName(), Joiner.on(File.pathSeparatorChar).join(processorPath));
    }

    @Override
    public void setProguardConfigFiles(@Nonnull List<File> proguardConfigFiles) {
        this.options.setProguardFlagsFile(Api04ConfigImpl.manageFilesCharsetAsList(proguardConfigFiles));
    }

    @Override
    public void setProperty(@Nonnull String key, @Nonnull String value) {
        this.options.addProperty(key, value);
    }

    @Override
    public void setReporter(@Nonnull ReporterKind reporterKind, @Nonnull OutputStream reporterStream) throws ConfigurationException {
        String reporterKindAsString = null;
        switch (reporterKind) {
            case DEFAULT: {
                reporterKindAsString = "default";
                break;
            }
            case SDK: {
                reporterKindAsString = "sdk";
                break;
            }
            default: {
                throw new ConfigurationException("Reporter kind '" + (Object)((Object)reporterKind) + "' is unsupported");
            }
        }
        this.options.addProperty(Reporter.REPORTER.getName(), reporterKindAsString);
        this.options.setReporterStream(reporterStream);
    }

    @Override
    public void setResourceDirs(@Nonnull List<File> resourceDirs) {
        this.options.setResourceDirs(resourceDirs);
    }

    @Override
    public void setResourceImportCollisionPolicy(@Nonnull ResourceCollisionPolicy resourceImportCollisionPolicy) throws ConfigurationException {
        String collisionPolicy = null;
        switch (resourceImportCollisionPolicy) {
            case FAIL: {
                collisionPolicy = "fail";
                break;
            }
            case KEEP_FIRST: {
                collisionPolicy = "keep-first";
                break;
            }
            default: {
                throw new ConfigurationException("Resource collision policy '" + resourceImportCollisionPolicy.toString() + "' is unsupported");
            }
        }
        this.options.addProperty(ResourceImporter.RESOURCE_COLLISION_POLICY.getName(), collisionPolicy);
    }

    @Override
    public void setSourceEntries(@Nonnull Collection<File> sourceEntries) {
        this.options.setInputSources(Api04ConfigImpl.manageFilesCharsetAsList(sourceEntries));
    }

    @Override
    public void setTypeImportCollisionPolicy(@Nonnull TypeCollisionPolicy typeImportCollisionPolicy) throws ConfigurationException {
        String collissionPolicy = null;
        switch (typeImportCollisionPolicy) {
            case FAIL: {
                collissionPolicy = "fail";
                break;
            }
            case KEEP_FIRST: {
                collissionPolicy = "keep-first";
                break;
            }
            default: {
                throw new ConfigurationException("Type collision policy '" + (Object)((Object)typeImportCollisionPolicy) + "' is unsupported");
            }
        }
        this.options.addProperty(ResourceImporter.RESOURCE_COLLISION_POLICY.getName(), collissionPolicy);
    }

    @Override
    public void setVerbosityLevel(@Nonnull VerbosityLevel verbosityLevel) throws ConfigurationException {
        Options.VerbosityLevel jackVerbosityLevel;
        switch (verbosityLevel) {
            case DEBUG: {
                jackVerbosityLevel = Options.VerbosityLevel.INFO;
                break;
            }
            case ERROR: {
                jackVerbosityLevel = Options.VerbosityLevel.ERROR;
                break;
            }
            case INFO: {
                jackVerbosityLevel = Options.VerbosityLevel.INFO;
                break;
            }
            case WARNING: {
                jackVerbosityLevel = Options.VerbosityLevel.WARNING;
                break;
            }
            default: {
                throw new ConfigurationException("Verbosity level '" + (Object)((Object)verbosityLevel) + "' is unsupported");
            }
        }
        this.options.setVerbosityLevel(jackVerbosityLevel);
    }

    @Override
    public void setApi(Class<? extends ApiFeature> api) {
        this.api = api;
    }

    private static class Api01CompilationTaskImpl
    implements Api01CompilationTask {
        @Nonnull
        private final Class<? extends ApiFeature> api;
        @Nonnull
        private final Options options;
        @Nonnull
        private final RunnableHooks runSessionHooks;

        public Api01CompilationTaskImpl(@Nonnull Class<? extends ApiFeature> api, @Nonnull Options options, @Nonnull RunnableHooks runSessionHooks) {
            this.api = api;
            this.options = options;
            this.runSessionHooks = runSessionHooks;
        }

        @Override
        public void run() throws CompilationException, UnrecoverableException {
            ProcessException pe = null;
            try {
                try {
                    try {
                        Jack.run(this.api, this.options, this.runSessionHooks);
                    }
                    catch (ProcessException e) {
                        pe = e;
                        throw e.getCause();
                    }
                }
                catch (Throwable e1) {
                    try {
                        this.runSessionHooks.runHooks();
                    }
                    catch (Error | RuntimeException throwable) {
                        // empty catch block
                    }
                    throw e1;
                }
                this.runSessionHooks.runHooks();
            }
            catch (FrontendCompilationException e) {
                throw new CompilationException(e.getMessage(), e);
            }
            catch (JackUserException e) {
                throw new CompilationException(e.getMessage(), e);
            }
            catch (JackAbortException e) {
                throw new CompilationException(e.getMessage(), e);
            }
            catch (com.android.sched.util.UnrecoverableException e) {
                throw new UnrecoverableException(e.getMessage(), e);
            }
            catch (Throwable e2) {
                ProcessException e2;
                if (pe != null) {
                    e2 = pe;
                }
                if (e2 instanceof RuntimeException) {
                    throw (RuntimeException)((Object)e2);
                }
                throw new RuntimeException(e2);
            }
        }
    }
}

