/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack;

import com.android.jack.IllegalOptionsException;
import com.android.jack.Jack;
import com.android.jack.JackAbortException;
import com.android.jack.JackUserException;
import com.android.jack.Options;
import com.android.jack.api.v04.impl.Api04Feature;
import com.android.jack.config.id.Douarn;
import com.android.jack.frontend.FrontendCompilationException;
import com.android.jack.kohsuke.args4j.CmdLineParser;
import com.android.jack.kohsuke.args4j.ParserProperties;
import com.android.jack.load.JackLoadingException;
import com.android.jack.plugin.v01.Plugin;
import com.android.sched.scheduler.ProcessException;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.util.TextUtils;
import com.android.sched.util.UnrecoverableException;
import com.android.sched.util.codec.Parser;
import com.android.sched.util.config.ChainedException;
import com.android.sched.util.config.ConfigurationException;
import com.android.sched.util.config.GatherConfigBuilder;
import com.android.sched.util.config.category.Category;
import com.android.sched.util.config.category.Version;
import com.android.sched.util.config.expression.BooleanExpression;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.location.Location;
import com.android.sched.util.location.NoLocation;
import com.android.sched.util.log.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class CommandLine {
    @Nonnull
    protected static final String INTERRUPTED_COMPILATION_WARNING = "Warning: This may have produced partial or corrupted output.";
    @Nonnegative
    private static final int CONSOLE_STACK_OVERFLOW_TOP = 20;
    @Nonnegative
    private static final int CONSOLE_STACK_OVERFLOW_BOTTOM = 30;
    @Nonnegative
    private static final int LOG_STACK_OVERFLOW_TOP = 100;
    @Nonnegative
    private static final int LOG_STACK_OVERFLOW_BOTTOM = 100;
    @Nonnull
    private static Logger logger = LoggerFactory.getLogger();

    protected static int runJack(@Nonnull PrintStream err, @Nonnull Options options) {
        ProcessException pe = null;
        try {
            try {
                Jack.checkAndRun(Api04Feature.class, options);
                return 0;
            }
            catch (ProcessException e) {
                pe = e;
                throw e.getCause();
            }
        }
        catch (ConfigurationException exceptions) {
            err.println(exceptions.getNextExceptionCount() + " error" + (exceptions.getNextExceptionCount() > 1 ? "s" : "") + " during configuration. Try --help-properties for help.");
            for (ChainedException exception : exceptions) {
                err.println("  " + exception.getMessage());
            }
            return 2;
        }
        catch (IllegalOptionsException e) {
            err.println(e.getMessage());
            err.println("Try --help for help.");
            return 2;
        }
        catch (FrontendCompilationException e) {
            return 4;
        }
        catch (JackUserException e) {
            err.println(e.getMessage());
            logger.log(Level.FINE, "Jack user exception:", e);
            return 4;
        }
        catch (JackLoadingException e) {
            err.println(e.getMessage());
            logger.log(Level.FINE, "Jack loading exception:", e);
            return 4;
        }
        catch (UnrecoverableException e) {
            err.println("Unrecoverable error: " + e.getMessage());
            err.println(INTERRUPTED_COMPILATION_WARNING);
            logger.log(Level.SEVERE, "Unrecoverable exception:", e);
            return 6;
        }
        catch (JackAbortException e) {
            logger.log(Level.FINE, "Jack fatal exception:", e);
            return 4;
        }
        catch (OutOfMemoryError e) {
            String info = "Out of memory error (version " + Jack.getVersion().getVerboseVersion() + ")";
            logger.log(Level.SEVERE, info + ':', pe != null ? pe : e);
            err.println(info + '.');
            CommandLine.printExceptionMessage(err, e);
            err.println("Try increasing heap size with java option '-Xmx<size>'.");
            err.println(INTERRUPTED_COMPILATION_WARNING);
            return 5;
        }
        catch (StackOverflowError e) {
            String info = "Stack overflow error (version " + Jack.getVersion().getVerboseVersion() + ")";
            logger.log(Level.SEVERE, info);
            if (pe != null) {
                logger.log(Level.SEVERE, pe.getMessage() + ".");
            }
            CommandLine.printStackOverflow(logger, e, 100, 100);
            if (pe != null) {
                err.println(pe.getMessage() + ".");
            }
            CommandLine.printExceptionMessage(err, e);
            CommandLine.printStackOverflow(err, e, 20, 30);
            err.println();
            err.println(info + '.');
            err.println("Try increasing stack size with property '" + ScheduleInstance.DEFAULT_STACK_SIZE.getName() + "'.");
            err.println(INTERRUPTED_COMPILATION_WARNING);
            return 5;
        }
        catch (VirtualMachineError e) {
            String info = "Virtual machine error (version " + Jack.getVersion().getVerboseVersion() + ")";
            logger.log(Level.SEVERE, info + ':', pe != null ? pe : e);
            err.println(info + '.');
            CommandLine.printExceptionMessage(err, e);
            err.println(INTERRUPTED_COMPILATION_WARNING);
            return 5;
        }
        catch (Throwable e) {
            String info = "Internal compiler error (version " + Jack.getVersion().getVerboseVersion() + ")";
            logger.log(Level.SEVERE, info + ':', pe != null ? pe : e);
            (pe != null ? pe : e).printStackTrace(err);
            err.println();
            err.println(info + '.');
            CommandLine.printExceptionMessage(err, e);
            err.println(INTERRUPTED_COMPILATION_WARNING);
            return 3;
        }
    }

    public static void printVersion(@Nonnull PrintStream printStream, @Nonnull Options options) throws IllegalOptionsException {
        options.ensurePluginManager();
        printStream.println("Jack compiler: " + Jack.getVersion().getVerboseVersion() + '.');
        for (Plugin plugin : options.getPluginManager().getPlugins()) {
            CommandLine.printVersion(printStream, plugin);
        }
    }

    public static void printVersion(@Nonnull PrintStream printStream, @Nonnull Plugin plugin) {
        printStream.println("Jack plugin:   " + plugin.getCanonicalName() + " (" + plugin.getFriendlyName() + ") " + plugin.getVersion().getVerboseVersion() + '.');
        printStream.println("               " + plugin.getDescription() + '.');
    }

    protected static void printUsage(@Nonnull PrintStream printStream) {
        CmdLineParser parser = new CmdLineParser(new Options(), ParserProperties.defaults().withUsageWidth(100));
        printStream.println("Usage: <options> <source files>");
        printStream.println();
        printStream.println("Options:");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        parser.printUsage(outputStream);
        printStream.append(outputStream.toString());
    }

    public static void printHelpProperties(@Nonnull PrintStream printStream, @Nonnull Options options) throws IOException, IllegalOptionsException {
        GatherConfigBuilder builder = options.getDefaultConfigBuilder();
        CommandLine.printProperties(printStream, builder, Douarn.class);
        printStream.println();
        printStream.println("Provisional properties (subject to change):");
        printStream.println();
        CommandLine.printProperties(printStream, builder, null);
    }

    private static void printProperties(@Nonnull PrintStream printStream, @Nonnull GatherConfigBuilder builder, @CheckForNull Class<? extends Category> category) {
        Collection<PropertyId<?>> collec = builder.getPropertyIds();
        PropertyId[] properties = collec.toArray(new PropertyId[collec.size()]);
        Arrays.sort(properties, new Comparator<PropertyId<?>>(){

            @Override
            public int compare(PropertyId<?> o1, PropertyId<?> o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (PropertyId property : properties) {
            BooleanExpression constraints;
            if ((category == null || !property.hasCategory(category)) && (category != null || property.hasCategory(Version.class))) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(property.getName());
            sb.append(':');
            Location location = builder.getLocation(property);
            if (!location.equals(NoLocation.getInstance())) {
                sb.append(" (declared by ");
                sb.append(location.getDescription());
                sb.append(')');
            }
            sb.append(TextUtils.LINE_SEPARATOR);
            sb.append("     ");
            sb.append(property.getDescription());
            String value = builder.getDefaultValue(property);
            if (value != null) {
                sb.append(" (default is '");
                sb.append(value);
                sb.append("')");
            }
            if ((constraints = property.getRequiredExpression()) != null) {
                sb.append(TextUtils.LINE_SEPARATOR);
                sb.append("     required if ");
                sb.append(constraints.getDescription());
            }
            sb.append(TextUtils.LINE_SEPARATOR);
            sb.append("     ");
            sb.append(property.getCodec().getUsage());
            List<Parser.ValueDescription> descriptions = property.getCodec().getValueDescriptions();
            if (descriptions.size() != 0) {
                for (Parser.ValueDescription entry : descriptions) {
                    sb.append(TextUtils.LINE_SEPARATOR);
                    sb.append("          ");
                    sb.append(entry.getValue());
                    sb.append(": ");
                    sb.append(entry.getDescription());
                }
            }
            printStream.println(sb);
        }
    }

    public static void printPluginsList(@Nonnull PrintStream printStream, @Nonnull Options options) throws IllegalOptionsException {
        options.ensurePluginManager();
        for (Plugin plugin : options.getPluginManager().getAvailablePlugins()) {
            CommandLine.printVersion(printStream, plugin);
        }
    }

    protected static void printExceptionMessage(@Nonnull PrintStream printer, @Nonnull Throwable t) {
        String exceptionMessage = t.getMessage();
        if (exceptionMessage != null) {
            printer.println(exceptionMessage + ".");
        }
    }

    protected static void printStackOverflow(@Nonnull PrintStream stream, @Nonnull StackOverflowError e, @Nonnegative int topCount, @Nonnegative int bottomCount) {
        StackTraceElement[] elts = e.getStackTrace();
        stream.println(elts.length + " calls reported in " + e.getClass().getCanonicalName() + ".");
        stream.println("(See -XX:MaxJavaStackTraceDepth to report more if necessary).");
        boolean ellipse = false;
        for (int idx = 0; idx < elts.length; ++idx) {
            if (idx < topCount || idx > elts.length - 1 - bottomCount) {
                stream.println("    at " + elts[idx].toString());
                continue;
            }
            if (ellipse) continue;
            ellipse = true;
            stream.println("    ...");
        }
    }

    protected static void printStackOverflow(@Nonnull Logger logger, @Nonnull StackOverflowError e, @Nonnegative int topCount, @Nonnegative int bottomCount) {
        StackTraceElement[] elts = e.getStackTrace();
        logger.log(Level.SEVERE, elts.length + " calls reported in " + e.getClass().getCanonicalName() + ".");
        boolean ellipse = false;
        for (int idx = 0; idx < elts.length; ++idx) {
            if (idx < topCount || idx > elts.length - 1 - bottomCount) {
                logger.log(Level.SEVERE, "    at " + elts[idx].toString());
                continue;
            }
            if (ellipse) continue;
            ellipse = true;
            logger.log(Level.SEVERE, "    ...");
        }
    }
}

