/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.utilities;

import com.strobel.annotations.NotNull;
import com.strobel.annotations.Nullable;
import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.IMethodSignature;
import com.strobel.assembler.metadata.JvmType;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataFilters;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.Comparer;
import com.strobel.core.Predicates;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.LambdaExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.MethodGroupExpression;
import com.strobel.decompiler.languages.java.ast.ParenthesizedExpression;
import com.strobel.decompiler.languages.java.ast.ReturnStatement;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.VariableInitializer;
import com.strobel.decompiler.semantics.ResolveResult;
import com.strobel.functions.Function;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public final class TypeUtilities {
    private static final String OBJECT_DESCRIPTOR = "java/lang/Object";
    private static final String STRING_DESCRIPTOR = "java/lang/String";
    private static final Map<JvmType, Integer> TYPE_TO_RANK_MAP;
    private static final int BYTE_RANK = 1;
    private static final int SHORT_RANK = 2;
    private static final int CHAR_RANK = 3;
    private static final int INT_RANK = 4;
    private static final int LONG_RANK = 5;
    private static final int FLOAT_RANK = 6;
    private static final int DOUBLE_RANK = 7;
    private static final int BOOL_RANK = 10;
    private static final int STRING_RANK = 100;
    private static final int MAX_NUMERIC_RANK = 7;

    private static int getTypeRank(@NotNull TypeReference type) {
        TypeReference unboxedType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(type);
        Integer rank = TYPE_TO_RANK_MAP.get((Object)unboxedType.getSimpleType());
        if (rank != null) {
            return rank;
        }
        if (StringUtilities.equals(type.getInternalName(), STRING_DESCRIPTOR)) {
            return 100;
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isPrimitive(@Nullable TypeReference type) {
        return type != null && type.isPrimitive();
    }

    public static boolean isPrimitiveOrWrapper(@Nullable TypeReference type) {
        if (type == null) {
            return false;
        }
        return MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(type).isPrimitive();
    }

    public static boolean isBoolean(@Nullable TypeReference type) {
        if (type == null) {
            return false;
        }
        return MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(type).getSimpleType() == JvmType.Boolean;
    }

    public static boolean isArithmetic(@Nullable TypeReference type) {
        if (type == null) {
            return false;
        }
        JvmType jvmType = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(type).getSimpleType();
        return jvmType.isNumeric() && jvmType != JvmType.Boolean;
    }

    public static boolean isBinaryOperatorApplicable(@NotNull BinaryOperatorType op, @NotNull AstType lType, @NotNull AstType rType, boolean strict) {
        return TypeUtilities.isBinaryOperatorApplicable(op, VerifyArgument.notNull(lType, "lType").toTypeReference(), VerifyArgument.notNull(rType, "rType").toTypeReference(), strict);
    }

    public static boolean isBinaryOperatorApplicable(@NotNull BinaryOperatorType op, @Nullable TypeReference lType, @Nullable TypeReference rType, boolean strict) {
        if (lType == null || rType == null) {
            return true;
        }
        VerifyArgument.notNull(op, "op");
        int lRank = TypeUtilities.getTypeRank(lType);
        int rRank = TypeUtilities.getTypeRank(rType);
        TypeReference lUnboxed = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(lType);
        TypeReference rUnboxed = MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(rType);
        int resultRank = 10;
        boolean isApplicable = false;
        switch (op) {
            case BITWISE_AND: 
            case BITWISE_OR: 
            case EXCLUSIVE_OR: {
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                isApplicable = lRank <= 5 && rRank <= 5 || TypeUtilities.isBoolean(lUnboxed) || TypeUtilities.isBoolean(rUnboxed);
                resultRank = lRank <= 5 ? 4 : 10;
                break;
            }
            case LOGICAL_AND: 
            case LOGICAL_OR: {
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                isApplicable = TypeUtilities.isBoolean(lType) && TypeUtilities.isBoolean(rType);
                break;
            }
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                isApplicable = lRank <= 7 && rRank <= 7;
                resultRank = 4;
                break;
            }
            case EQUALITY: 
            case INEQUALITY: {
                if (lUnboxed.isPrimitive() && rUnboxed.isPrimitive() && (lType.isPrimitive() || rType.isPrimitive())) {
                    isApplicable = lRank <= 7 && rRank <= 7 || lRank == 10 && rRank == 10;
                    break;
                }
                if (lType.isPrimitive()) {
                    return MetadataHelper.isConvertible(lType, rType);
                }
                if (rType.isPrimitive()) {
                    return MetadataHelper.isConvertible(rType, lType);
                }
                isApplicable = MetadataHelper.isConvertible(lType, rType) || MetadataHelper.isConvertible(rType, lType);
                break;
            }
            case ADD: {
                if (StringUtilities.equals(lType.getInternalName(), STRING_DESCRIPTOR)) {
                    isApplicable = !rType.isVoid();
                    resultRank = 100;
                    break;
                }
                if (StringUtilities.equals(rType.getInternalName(), STRING_DESCRIPTOR)) {
                    isApplicable = !lType.isVoid();
                    resultRank = 100;
                    break;
                }
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                resultRank = Math.max(lRank, rRank);
                isApplicable = lRank <= 7 && rRank <= 7;
                break;
            }
            case SUBTRACT: 
            case MULTIPLY: 
            case DIVIDE: 
            case MODULUS: {
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                resultRank = Math.max(lRank, rRank);
                isApplicable = lRank <= 7 && rRank <= 7;
                break;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case UNSIGNED_SHIFT_RIGHT: {
                if (!lUnboxed.isPrimitive() || !rUnboxed.isPrimitive()) break;
                isApplicable = lRank <= 5 && rRank <= 5;
                resultRank = 4;
            }
        }
        if (isApplicable && strict) {
            isApplicable = resultRank > 7 ? lRank == resultRank || StringUtilities.equals(lType.getInternalName(), OBJECT_DESCRIPTOR) : lRank <= 7;
        }
        return isApplicable;
    }

    @Nullable
    public static AstNode skipParenthesesUp(AstNode e) {
        AstNode result = e;
        while (result instanceof ParenthesizedExpression) {
            result = result.getParent();
        }
        return result;
    }

    @Nullable
    public static AstNode skipParenthesesDown(AstNode e) {
        AstNode result = e;
        while (result instanceof ParenthesizedExpression) {
            result = ((ParenthesizedExpression)result).getExpression();
        }
        return result;
    }

    @Nullable
    public static Expression skipParenthesesDown(Expression e) {
        Expression result = e;
        while (result instanceof ParenthesizedExpression) {
            result = ((ParenthesizedExpression)result).getExpression();
        }
        return result;
    }

    private static boolean checkSameExpression(Expression template, Expression expression) {
        return Comparer.equals(template, TypeUtilities.skipParenthesesDown(expression));
    }

    private static TypeReference getType(@NotNull Function<AstNode, ResolveResult> resolver, @NotNull AstNode node) {
        ResolveResult result = resolver.apply(node);
        return result != null ? result.getType() : null;
    }

    @Nullable
    public static TypeReference getExpectedTypeByParent(Function<AstNode, ResolveResult> resolver, Expression expression) {
        VerifyArgument.notNull(resolver, "resolver");
        VerifyArgument.notNull(expression, "expression");
        AstNode parent = TypeUtilities.skipParenthesesUp(expression.getParent());
        if (expression.getRole() == Roles.CONDITION) {
            return CommonTypeReferences.Boolean;
        }
        if (parent instanceof VariableInitializer) {
            if (TypeUtilities.checkSameExpression(expression, ((VariableInitializer)parent).getInitializer()) && parent.getParent() instanceof VariableDeclarationStatement) {
                return TypeUtilities.getType(resolver, parent.getParent());
            }
        } else if (parent instanceof AssignmentExpression) {
            if (TypeUtilities.checkSameExpression(expression, ((AssignmentExpression)parent).getRight())) {
                return TypeUtilities.getType(resolver, ((AssignmentExpression)parent).getLeft());
            }
        } else if (parent instanceof ReturnStatement) {
            LambdaExpression lambdaExpression = CollectionUtilities.firstOrDefault(parent.getAncestors(LambdaExpression.class));
            if (lambdaExpression != null) {
                DynamicCallSite callSite = lambdaExpression.getUserData(Keys.DYNAMIC_CALL_SITE);
                if (callSite == null) {
                    return null;
                }
                MethodReference method = (MethodReference)callSite.getBootstrapArguments().get(0);
                return method.getDeclaringType();
            }
            MethodDeclaration method = CollectionUtilities.firstOrDefault(parent.getAncestors(MethodDeclaration.class));
            if (method != null) {
                return TypeUtilities.getType(resolver, method.getReturnType());
            }
        } else if (parent instanceof ConditionalExpression) {
            if (TypeUtilities.checkSameExpression(expression, ((ConditionalExpression)parent).getTrueExpression())) {
                return TypeUtilities.getType(resolver, ((ConditionalExpression)parent).getFalseExpression());
            }
            if (TypeUtilities.checkSameExpression(expression, ((ConditionalExpression)parent).getFalseExpression())) {
                return TypeUtilities.getType(resolver, ((ConditionalExpression)parent).getTrueExpression());
            }
        }
        return null;
    }

    public static IMethodSignature getLambdaSignature(MethodGroupExpression node) {
        return TypeUtilities.getLambdaSignatureCore(node);
    }

    public static IMethodSignature getLambdaSignature(LambdaExpression node) {
        return TypeUtilities.getLambdaSignatureCore(node);
    }

    public static boolean isValidPrimitiveLiteralAssignment(TypeReference targetType, Object value) {
        Number n;
        VerifyArgument.notNull(targetType, "targetType");
        if (targetType.getSimpleType() == JvmType.Boolean) {
            return value instanceof Boolean;
        }
        if (!targetType.isPrimitive() || !(value instanceof Number) && !(value instanceof Character)) {
            return false;
        }
        Number number = n = value instanceof Character ? (Number)Integer.valueOf(((Character)value).charValue()) : (Number)((Number)value);
        if (n instanceof Float || n instanceof Double) {
            if (targetType.getSimpleType() == JvmType.Float) {
                return n.doubleValue() >= (double)1.4E-45f && n.doubleValue() <= 3.4028234663852886E38;
            }
            return targetType.getSimpleType() == JvmType.Double;
        }
        if (n instanceof Long) {
            switch (targetType.getSimpleType()) {
                case Long: 
                case Float: 
                case Double: {
                    return true;
                }
            }
            return false;
        }
        switch (targetType.getSimpleType()) {
            case Byte: {
                return n.intValue() >= -128 && n.intValue() <= 127;
            }
            case Character: {
                return n.intValue() >= 0 && n.intValue() <= 65535;
            }
            case Short: {
                return n.intValue() >= Short.MIN_VALUE && n.intValue() <= Short.MAX_VALUE;
            }
            case Integer: {
                return n.longValue() >= Integer.MIN_VALUE && n.longValue() <= Integer.MAX_VALUE;
            }
            case Long: 
            case Float: 
            case Double: {
                return true;
            }
        }
        return false;
    }

    private static IMethodSignature getLambdaSignatureCore(Expression node) {
        VerifyArgument.notNull(node, "node");
        TypeReference lambdaType = node.getUserData(Keys.TYPE_REFERENCE);
        DynamicCallSite callSite = node.getUserData(Keys.DYNAMIC_CALL_SITE);
        if (lambdaType == null) {
            if (callSite == null) {
                return null;
            }
            return (IMethodSignature)callSite.getBootstrapArguments().get(2);
        }
        TypeDefinition resolvedType = lambdaType.resolve();
        if (resolvedType == null) {
            if (callSite == null) {
                return null;
            }
            return (IMethodSignature)callSite.getBootstrapArguments().get(2);
        }
        MemberReference functionMethod = null;
        List<MethodReference> methods = MetadataHelper.findMethods(resolvedType, callSite != null ? MetadataFilters.matchName(callSite.getMethodName()) : Predicates.alwaysTrue());
        for (MethodReference m : methods) {
            MethodDefinition r = m.resolve();
            if (r == null || !r.isAbstract() || r.isStatic() || r.isDefault()) continue;
            functionMethod = r;
            break;
        }
        if (functionMethod != null) {
            TypeReference effectiveType;
            TypeReference asMemberOf = MetadataHelper.asSuper(functionMethod.getDeclaringType(), lambdaType);
            TypeReference typeReference = effectiveType = asMemberOf != null ? asMemberOf : lambdaType;
            if (MetadataHelper.isRawType(effectiveType)) {
                return MetadataHelper.erase((MethodReference)functionMethod);
            }
            functionMethod = MetadataHelper.asMemberOf((MethodReference)functionMethod, effectiveType);
        }
        return functionMethod;
    }

    static {
        EnumMap<JvmType, Integer> rankMap = new EnumMap<JvmType, Integer>(JvmType.class);
        rankMap.put(JvmType.Byte, 1);
        rankMap.put(JvmType.Short, 2);
        rankMap.put(JvmType.Character, 3);
        rankMap.put(JvmType.Integer, 4);
        rankMap.put(JvmType.Long, 5);
        rankMap.put(JvmType.Float, 6);
        rankMap.put(JvmType.Double, 7);
        rankMap.put(JvmType.Boolean, 10);
        TYPE_TO_RANK_MAP = Collections.unmodifiableMap(rankMap);
    }
}

