/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.ImportDeclaration;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.PackageDeclaration;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;
import com.strobel.util.ContractUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class CompilationUnit
extends AstNode {
    public static final Role<TypeDeclaration> TYPE_ROLE = Roles.TOP_LEVEL_TYPE_ROLE;
    public static final Role<ImportDeclaration> IMPORT_ROLE = new Role<ImportDeclaration>("Import", ImportDeclaration.class, ImportDeclaration.NULL);
    private AstNode _topExpression;
    private String _fileName;

    public final AstNodeCollection<ImportDeclaration> getImports() {
        return this.getChildrenByRole(IMPORT_ROLE);
    }

    public final PackageDeclaration getPackage() {
        return this.getChildByRole(Roles.PACKAGE);
    }

    public final void setPackage(PackageDeclaration value) {
        this.setChildByRole(Roles.PACKAGE, value);
    }

    public final String getFileName() {
        return this._fileName;
    }

    public final void setFileName(String fileName) {
        this.verifyNotFrozen();
        this._fileName = fileName;
    }

    public final AstNode getTopExpression() {
        return this._topExpression;
    }

    final void setTopExpression(AstNode topExpression) {
        this._topExpression = topExpression;
    }

    public final AstNodeCollection<TypeDeclaration> getTypes() {
        return this.getChildrenByRole(TYPE_ROLE);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.UNKNOWN;
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitCompilationUnit(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        return other instanceof CompilationUnit && !other.isNull() && this.getTypes().matches(((CompilationUnit)other).getTypes(), match);
    }

    public Iterable<TypeDeclaration> getTypes(final boolean includeInnerTypes) {
        return new Iterable<TypeDeclaration>(){

            @Override
            public final Iterator<TypeDeclaration> iterator() {
                return new Iterator<TypeDeclaration>(){
                    final Stack<AstNode> nodeStack = new Stack();
                    TypeDeclaration next = null;
                    {
                        this.nodeStack.push(CompilationUnit.this);
                    }

                    private TypeDeclaration selectNext() {
                        if (this.next != null) {
                            return this.next;
                        }
                        while (!this.nodeStack.isEmpty()) {
                            AstNode current = this.nodeStack.pop();
                            if (current instanceof TypeDeclaration) {
                                this.next = (TypeDeclaration)current;
                                break;
                            }
                            for (AstNode child : current.getChildren()) {
                                if (child instanceof Statement || child instanceof Expression || child.getRole() == Roles.TYPE_MEMBER && (!(child instanceof TypeDeclaration) || !includeInnerTypes)) continue;
                                this.nodeStack.push(child);
                            }
                        }
                        return null;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.selectNext() != null;
                    }

                    @Override
                    public final TypeDeclaration next() {
                        TypeDeclaration next = this.selectNext();
                        if (next == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = null;
                        return next;
                    }

                    @Override
                    public final void remove() {
                        throw ContractUtils.unsupported();
                    }
                };
            }
        };
    }
}

