/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.Cfg;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class BaseLiveAnalyze {
    protected int localSize;
    protected IrMethod method;
    public final List<Phi> phis = new ArrayList<Phi>();

    public BaseLiveAnalyze(IrMethod method) {
        this.method = method;
        this.localSize = method.locals.size();
    }

    public void analyze() {
        this.init();
        this.analyze0();
        this.analyzePhi();
    }

    protected void clearUnUsed() {
        Stmt p = this.method.stmts.getFirst();
        while (p != null) {
            Phi[] frame = (Phi[])p._ls_forward_frame;
            if (frame != null) {
                int i = 0;
                while (i < frame.length) {
                    Phi r = frame[i];
                    if (r != null && !r.used) {
                        frame[i] = null;
                    }
                    ++i;
                }
            }
            p = p.getNext();
        }
    }

    protected void analyzePhi() {
        this.markUsed();
        this.clearUnUsed();
    }

    protected void onUseLocal(Phi phi, Local local) {
    }

    protected void onAssignLocal(Phi[] frame, Phi phi, Value value) {
    }

    protected void use(ValueBox op, Phi[] frame) {
        if (op == null) {
            return;
        }
        Value v = op.value;
        switch (v.et) {
            case E0: {
                if (v.vt != Value.VT.LOCAL) break;
                Local local = (Local)v;
                Phi phi = frame[local._ls_index];
                phi.used = true;
                this.onUseLocal(phi, local);
                break;
            }
            case E1: {
                this.use(((Value.E1Expr)v).op, frame);
                break;
            }
            case E2: {
                Value.E2Expr e2 = (Value.E2Expr)v;
                this.use(e2.op1, frame);
                this.use(e2.op2, frame);
                break;
            }
            case En: {
                Value.EnExpr en = (Value.EnExpr)v;
                ValueBox[] valueBoxArray = en.ops;
                int n = en.ops.length;
                int n2 = 0;
                while (n2 < n) {
                    ValueBox vb = valueBoxArray[n2];
                    this.use(vb, frame);
                    ++n2;
                }
                break;
            }
        }
    }

    protected Phi newPhi() {
        Phi phi = new Phi();
        return phi;
    }

    protected Set<Phi> markUsed() {
        HashSet<Phi> used = new HashSet<Phi>(this.phis.size() / 2);
        LinkedList<Phi> q = new LinkedList<Phi>();
        q.addAll(this.phis);
        while (!q.isEmpty()) {
            Phi v = (Phi)q.poll();
            if (!v.used || used.contains(v)) continue;
            used.add(v);
            for (Phi p : v.parents) {
                p.used = true;
                q.add(p);
            }
        }
        this.phis.clear();
        this.phis.addAll(used);
        return used;
    }

    protected void analyze0() {
        Cfg.Forward(this.method, new Cfg.FrameVisitor<Phi[]>(){

            @Override
            public Phi[] exec(Stmt stmt) {
                Phi[] frame = (Phi[])stmt._ls_forward_frame;
                if (frame == null) {
                    stmt._ls_forward_frame = frame = new Phi[BaseLiveAnalyze.this.localSize];
                }
                Phi[] result = frame;
                switch (stmt.et) {
                    case E0: {
                        break;
                    }
                    case E1: {
                        BaseLiveAnalyze.this.use(((Stmt.E1Stmt)stmt).op, result);
                        break;
                    }
                    case E2: {
                        Stmt.E2Stmt e2 = (Stmt.E2Stmt)stmt;
                        if ((e2.st == Stmt.ST.ASSIGN || e2.st == Stmt.ST.IDENTITY) && ((AssignStmt)stmt).op1.value.vt == Value.VT.LOCAL) {
                            Local local = (Local)((AssignStmt)stmt).op1.value;
                            BaseLiveAnalyze.this.use(e2.op2, result);
                            result = new Phi[BaseLiveAnalyze.this.localSize];
                            System.arraycopy(frame, 0, result, 0, BaseLiveAnalyze.this.localSize);
                            Phi phi = BaseLiveAnalyze.this.newPhi();
                            BaseLiveAnalyze.this.phis.add(phi);
                            BaseLiveAnalyze.this.onAssignLocal(frame, phi, e2.op2.value);
                            result[local._ls_index] = phi;
                            break;
                        }
                        BaseLiveAnalyze.this.use(e2.op1, result);
                        BaseLiveAnalyze.this.use(e2.op2, result);
                        break;
                    }
                    case En: {
                        Stmt.EnStmt en = (Stmt.EnStmt)stmt;
                        ValueBox[] valueBoxArray = en.ops;
                        int n = en.ops.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ValueBox vb = valueBoxArray[n2];
                            BaseLiveAnalyze.this.use(vb, result);
                            ++n2;
                        }
                        break;
                    }
                }
                return result;
            }

            @Override
            public void merge(Phi[] frame, Stmt dist) {
                Phi[] distFrame = (Phi[])dist._ls_forward_frame;
                if (distFrame == null) {
                    dist._ls_forward_frame = distFrame = new Phi[BaseLiveAnalyze.this.localSize];
                }
                int i = 0;
                while (i < BaseLiveAnalyze.this.localSize) {
                    Phi srcPhi = frame[i];
                    if (srcPhi != null) {
                        Phi distPhi = distFrame[i];
                        if (distPhi == null) {
                            if (!dist._cfg_visited) {
                                distPhi = BaseLiveAnalyze.this.newPhi();
                                BaseLiveAnalyze.this.phis.add(distPhi);
                                distFrame[i] = distPhi;
                                distPhi.parents.add(srcPhi);
                                srcPhi.children.add(distPhi);
                            }
                        } else {
                            distPhi.parents.add(srcPhi);
                            srcPhi.children.add(distPhi);
                        }
                    }
                    ++i;
                }
            }
        });
    }

    protected void init() {
        int index = 0;
        for (Local local : this.method.locals) {
            local._ls_index = index++;
        }
        this.initCFG();
    }

    protected void initCFG() {
        Cfg.createCfgForLiveAnalyze(this.method);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Stmt stmt = this.method.stmts.getFirst();
        while (stmt != null) {
            Phi[] frame = (Phi[])stmt._ls_forward_frame;
            if (frame != null) {
                Phi[] phiArray = frame;
                int n = frame.length;
                int n2 = 0;
                while (n2 < n) {
                    Phi p = phiArray[n2];
                    if (p == null) {
                        sb.append('.');
                    } else if (p.used) {
                        sb.append('x');
                    } else {
                        sb.append('?');
                    }
                    ++n2;
                }
                sb.append(" | ");
            }
            sb.append(stmt.toString()).append('\n');
            stmt = stmt.getNext();
        }
        return sb.toString();
    }

    public static class Phi {
        public Set<Phi> parents = new HashSet<Phi>(3);
        public Set<Phi> children = new HashSet<Phi>(3);
        public boolean used;

        public String toString() {
            return ".";
        }
    }
}

