pub const Clobbers = switch (@import("builtin").cpu.arch) {
    .x86, .x86_64 => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        /// Condition codes. Subset of the bits in `eflags` and `rflags`.
        cc: bool = false,
        dirflag: bool = false,
        eflags: bool = false,
        flags: bool = false,
        fpcr: bool = false,
        fpsr: bool = false,
        mxcsr: bool = false,
        rflags: bool = false,

        rax: bool = false,
        rcx: bool = false,
        rdx: bool = false,
        rbx: bool = false,
        rsp: bool = false,
        rbp: bool = false,
        rsi: bool = false,
        rdi: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
        eax: bool = false,
        ecx: bool = false,
        edx: bool = false,
        ebx: bool = false,
        esp: bool = false,
        ebp: bool = false,
        esi: bool = false,
        edi: bool = false,
        r8d: bool = false,
        r9d: bool = false,
        r10d: bool = false,
        r11d: bool = false,
        r12d: bool = false,
        r13d: bool = false,
        r14d: bool = false,
        r15d: bool = false,
        ax: bool = false,
        cx: bool = false,
        dx: bool = false,
        bx: bool = false,
        sp: bool = false,
        bp: bool = false,
        si: bool = false,
        di: bool = false,
        r8w: bool = false,
        r9w: bool = false,
        r10w: bool = false,
        r11w: bool = false,
        r12w: bool = false,
        r13w: bool = false,
        r14w: bool = false,
        r15w: bool = false,
        al: bool = false,
        cl: bool = false,
        dl: bool = false,
        bl: bool = false,
        spl: bool = false,
        bpl: bool = false,
        sil: bool = false,
        dil: bool = false,
        r8b: bool = false,
        r9b: bool = false,
        r10b: bool = false,
        r11b: bool = false,
        r12b: bool = false,
        r13b: bool = false,
        r14b: bool = false,
        r15b: bool = false,
        ah: bool = false,
        ch: bool = false,
        dh: bool = false,
        bh: bool = false,
        zmm0: bool = false,
        zmm1: bool = false,
        zmm2: bool = false,
        zmm3: bool = false,
        zmm4: bool = false,
        zmm5: bool = false,
        zmm6: bool = false,
        zmm7: bool = false,
        zmm8: bool = false,
        zmm9: bool = false,
        zmm10: bool = false,
        zmm11: bool = false,
        zmm12: bool = false,
        zmm13: bool = false,
        zmm14: bool = false,
        zmm15: bool = false,
        zmm16: bool = false,
        zmm17: bool = false,
        zmm18: bool = false,
        zmm19: bool = false,
        zmm20: bool = false,
        zmm21: bool = false,
        zmm22: bool = false,
        zmm23: bool = false,
        zmm24: bool = false,
        zmm25: bool = false,
        zmm26: bool = false,
        zmm27: bool = false,
        zmm28: bool = false,
        zmm29: bool = false,
        zmm30: bool = false,
        zmm31: bool = false,
        ymm0: bool = false,
        ymm1: bool = false,
        ymm2: bool = false,
        ymm3: bool = false,
        ymm4: bool = false,
        ymm5: bool = false,
        ymm6: bool = false,
        ymm7: bool = false,
        ymm8: bool = false,
        ymm9: bool = false,
        ymm10: bool = false,
        ymm11: bool = false,
        ymm12: bool = false,
        ymm13: bool = false,
        ymm14: bool = false,
        ymm15: bool = false,
        ymm16: bool = false,
        ymm17: bool = false,
        ymm18: bool = false,
        ymm19: bool = false,
        ymm20: bool = false,
        ymm21: bool = false,
        ymm22: bool = false,
        ymm23: bool = false,
        ymm24: bool = false,
        ymm25: bool = false,
        ymm26: bool = false,
        ymm27: bool = false,
        ymm28: bool = false,
        ymm29: bool = false,
        ymm30: bool = false,
        ymm31: bool = false,
        xmm0: bool = false,
        xmm1: bool = false,
        xmm2: bool = false,
        xmm3: bool = false,
        xmm4: bool = false,
        xmm5: bool = false,
        xmm6: bool = false,
        xmm7: bool = false,
        xmm8: bool = false,
        xmm9: bool = false,
        xmm10: bool = false,
        xmm11: bool = false,
        xmm12: bool = false,
        xmm13: bool = false,
        xmm14: bool = false,
        xmm15: bool = false,
        xmm16: bool = false,
        xmm17: bool = false,
        xmm18: bool = false,
        xmm19: bool = false,
        xmm20: bool = false,
        xmm21: bool = false,
        xmm22: bool = false,
        xmm23: bool = false,
        xmm24: bool = false,
        xmm25: bool = false,
        xmm26: bool = false,
        xmm27: bool = false,
        xmm28: bool = false,
        xmm29: bool = false,
        xmm30: bool = false,
        xmm31: bool = false,
        mm0: bool = false,
        mm1: bool = false,
        mm2: bool = false,
        mm3: bool = false,
        mm4: bool = false,
        mm5: bool = false,
        mm6: bool = false,
        mm7: bool = false,
        st0: bool = false,
        st1: bool = false,
        st2: bool = false,
        st3: bool = false,
        st4: bool = false,
        st5: bool = false,
        st6: bool = false,
        st7: bool = false,
        es: bool = false,
        cs: bool = false,
        ss: bool = false,
        ds: bool = false,
        fs: bool = false,
        gs: bool = false,
    },
    .aarch64, .aarch64_be => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        nzcv: bool = false,

        x0: bool = false,
        x1: bool = false,
        x2: bool = false,
        x3: bool = false,
        x4: bool = false,
        x5: bool = false,
        x6: bool = false,
        x7: bool = false,
        x8: bool = false,
        x9: bool = false,
        x10: bool = false,
        x11: bool = false,
        x12: bool = false,
        x13: bool = false,
        x14: bool = false,
        x15: bool = false,
        x16: bool = false,
        x17: bool = false,
        x18: bool = false,
        x19: bool = false,
        x20: bool = false,
        x21: bool = false,
        x22: bool = false,
        x23: bool = false,
        x24: bool = false,
        x25: bool = false,
        x26: bool = false,
        x27: bool = false,
        x28: bool = false,
        x29: bool = false,
        x30: bool = false,

        w0: bool = false,
        w1: bool = false,
        w2: bool = false,
        w3: bool = false,
        w4: bool = false,
        w5: bool = false,
        w6: bool = false,
        w7: bool = false,
        w8: bool = false,
        w9: bool = false,
        w10: bool = false,
        w11: bool = false,
        w12: bool = false,
        w13: bool = false,
        w14: bool = false,
        w15: bool = false,
        w16: bool = false,
        w17: bool = false,
        w18: bool = false,
        w19: bool = false,
        w20: bool = false,
        w21: bool = false,
        w22: bool = false,
        w23: bool = false,
        w24: bool = false,
        w25: bool = false,
        w26: bool = false,
        w27: bool = false,
        w28: bool = false,
        w29: bool = false,

        lr: bool = false,
        sp: bool = false,
        wsp: bool = false,
        fpcr: bool = false,
        fpmr: bool = false,
        fpsr: bool = false,
        ffr: bool = false,

        p0: bool = false,
        p1: bool = false,
        p2: bool = false,
        p3: bool = false,
        p4: bool = false,
        p5: bool = false,
        p6: bool = false,
        p7: bool = false,
        p8: bool = false,
        p9: bool = false,
        p10: bool = false,
        p11: bool = false,
        p12: bool = false,
        p13: bool = false,
        p14: bool = false,
        p15: bool = false,

        z0: bool = false,
        z1: bool = false,
        z2: bool = false,
        z3: bool = false,
        z4: bool = false,
        z5: bool = false,
        z6: bool = false,
        z7: bool = false,
        z8: bool = false,
        z9: bool = false,
        z10: bool = false,
        z11: bool = false,
        z12: bool = false,
        z13: bool = false,
        z14: bool = false,
        z15: bool = false,
        z16: bool = false,
        z17: bool = false,
        z18: bool = false,
        z19: bool = false,
        z20: bool = false,
        z21: bool = false,
        z22: bool = false,
        z23: bool = false,
        z24: bool = false,
        z25: bool = false,
        z26: bool = false,
        z27: bool = false,
        z28: bool = false,
        z29: bool = false,
        z30: bool = false,
        z31: bool = false,

        v0: bool = false,
        v1: bool = false,
        v2: bool = false,
        v3: bool = false,
        v4: bool = false,
        v5: bool = false,
        v6: bool = false,
        v7: bool = false,
        v8: bool = false,
        v9: bool = false,
        v10: bool = false,
        v11: bool = false,
        v12: bool = false,
        v13: bool = false,
        v14: bool = false,
        v15: bool = false,
        v16: bool = false,
        v17: bool = false,
        v18: bool = false,
        v19: bool = false,
        v20: bool = false,
        v21: bool = false,
        v22: bool = false,
        v23: bool = false,
        v24: bool = false,
        v25: bool = false,
        v26: bool = false,
        v27: bool = false,
        v28: bool = false,
        v29: bool = false,
        v30: bool = false,
        v31: bool = false,

        d0: bool = false,
        d1: bool = false,
        d2: bool = false,
        d3: bool = false,
        d4: bool = false,
        d5: bool = false,
        d6: bool = false,
        d7: bool = false,
        d8: bool = false,
        d9: bool = false,
        d10: bool = false,
        d11: bool = false,
        d12: bool = false,
        d13: bool = false,
        d14: bool = false,
        d15: bool = false,
        d16: bool = false,
        d17: bool = false,
        d18: bool = false,
        d19: bool = false,
        d20: bool = false,
        d21: bool = false,
        d22: bool = false,
        d23: bool = false,
        d24: bool = false,
        d25: bool = false,
        d26: bool = false,
        d27: bool = false,
        d28: bool = false,
        d29: bool = false,
        d30: bool = false,
        d31: bool = false,

        s0: bool = false,
        s1: bool = false,
        s2: bool = false,
        s3: bool = false,
        s4: bool = false,
        s5: bool = false,
        s6: bool = false,
        s7: bool = false,
        s8: bool = false,
        s9: bool = false,
        s10: bool = false,
        s11: bool = false,
        s12: bool = false,
        s13: bool = false,
        s14: bool = false,
        s15: bool = false,
        s16: bool = false,
        s17: bool = false,
        s18: bool = false,
        s19: bool = false,
        s20: bool = false,
        s21: bool = false,
        s22: bool = false,
        s23: bool = false,
        s24: bool = false,
        s25: bool = false,
        s26: bool = false,
        s27: bool = false,
        s28: bool = false,
        s29: bool = false,
        s30: bool = false,
        s31: bool = false,

        h0: bool = false,
        h1: bool = false,
        h2: bool = false,
        h3: bool = false,
        h4: bool = false,
        h5: bool = false,
        h6: bool = false,
        h7: bool = false,
        h8: bool = false,
        h9: bool = false,
        h10: bool = false,
        h11: bool = false,
        h12: bool = false,
        h13: bool = false,
        h14: bool = false,
        h15: bool = false,
        h16: bool = false,
        h17: bool = false,
        h18: bool = false,
        h19: bool = false,
        h20: bool = false,
        h21: bool = false,
        h22: bool = false,
        h23: bool = false,
        h24: bool = false,
        h25: bool = false,
        h26: bool = false,
        h27: bool = false,
        h28: bool = false,
        h29: bool = false,
        h30: bool = false,
        h31: bool = false,

        b0: bool = false,
        b1: bool = false,
        b2: bool = false,
        b3: bool = false,
        b4: bool = false,
        b5: bool = false,
        b6: bool = false,
        b7: bool = false,
        b8: bool = false,
        b9: bool = false,
        b10: bool = false,
        b11: bool = false,
        b12: bool = false,
        b13: bool = false,
        b14: bool = false,
        b15: bool = false,
        b16: bool = false,
        b17: bool = false,
        b18: bool = false,
        b19: bool = false,
        b20: bool = false,
        b21: bool = false,
        b22: bool = false,
        b23: bool = false,
        b24: bool = false,
        b25: bool = false,
        b26: bool = false,
        b27: bool = false,
        b28: bool = false,
        b29: bool = false,
        b30: bool = false,
        b31: bool = false,

        za0q: bool = false,
        za1q: bool = false,
        za2q: bool = false,
        za3q: bool = false,
        za4q: bool = false,
        za5q: bool = false,
        za6q: bool = false,
        za7q: bool = false,
        za8q: bool = false,
        za9q: bool = false,
        za10q: bool = false,
        za11q: bool = false,
        za12q: bool = false,
        za13q: bool = false,
        za14q: bool = false,
        za15q: bool = false,

        za0d: bool = false,
        za1d: bool = false,
        za2d: bool = false,
        za3d: bool = false,
        za4d: bool = false,
        za5d: bool = false,
        za6d: bool = false,
        za7d: bool = false,

        za0s: bool = false,
        za1s: bool = false,
        za2s: bool = false,
        za3s: bool = false,

        za0h: bool = false,
        za1h: bool = false,
        za0b: bool = false,

        zt0: bool = false,
    },
    .arm, .armeb, .thumb, .thumbeb => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        apsr: bool = false,
        cpsr: bool = false,
        spsr: bool = false,
        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,

        fpscr: bool = false,
        vpr: bool = false,

        d0: bool = false,
        d1: bool = false,
        d2: bool = false,
        d3: bool = false,
        d4: bool = false,
        d5: bool = false,
        d6: bool = false,
        d7: bool = false,
        d8: bool = false,
        d9: bool = false,
        d10: bool = false,
        d11: bool = false,
        d12: bool = false,
        d13: bool = false,
        d14: bool = false,
        d15: bool = false,
        d16: bool = false,
        d17: bool = false,
        d18: bool = false,
        d19: bool = false,
        d20: bool = false,
        d21: bool = false,
        d22: bool = false,
        d23: bool = false,
        d24: bool = false,
        d25: bool = false,
        d26: bool = false,
        d27: bool = false,
        d28: bool = false,
        d29: bool = false,
        d30: bool = false,
        d31: bool = false,

        s0: bool = false,
        s1: bool = false,
        s2: bool = false,
        s3: bool = false,
        s4: bool = false,
        s5: bool = false,
        s6: bool = false,
        s7: bool = false,
        s8: bool = false,
        s9: bool = false,
        s10: bool = false,
        s11: bool = false,
        s12: bool = false,
        s13: bool = false,
        s14: bool = false,
        s15: bool = false,
        s16: bool = false,
        s17: bool = false,
        s18: bool = false,
        s19: bool = false,
        s20: bool = false,
        s21: bool = false,
        s22: bool = false,
        s23: bool = false,
        s24: bool = false,
        s25: bool = false,
        s26: bool = false,
        s27: bool = false,
        s28: bool = false,
        s29: bool = false,
        s30: bool = false,
        s31: bool = false,

        q0: bool = false,
        q1: bool = false,
        q2: bool = false,
        q3: bool = false,
        q4: bool = false,
        q5: bool = false,
        q6: bool = false,
        q7: bool = false,
        q8: bool = false,
        q9: bool = false,
        q10: bool = false,
        q11: bool = false,
        q12: bool = false,
        q13: bool = false,
        q14: bool = false,
        q15: bool = false,
    },
    .riscv32, .riscv64 => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        ssp: bool = false,

        x1: bool = false,
        x2: bool = false,
        x3: bool = false,
        x4: bool = false,
        x5: bool = false,
        x6: bool = false,
        x7: bool = false,
        x8: bool = false,
        x9: bool = false,
        x10: bool = false,
        x11: bool = false,
        x12: bool = false,
        x13: bool = false,
        x14: bool = false,
        x15: bool = false,
        x16: bool = false,
        x17: bool = false,
        x18: bool = false,
        x19: bool = false,
        x20: bool = false,
        x21: bool = false,
        x22: bool = false,
        x23: bool = false,
        x24: bool = false,
        x25: bool = false,
        x26: bool = false,
        x27: bool = false,
        x28: bool = false,
        x29: bool = false,
        x30: bool = false,
        x31: bool = false,

        fflags: bool = false,
        frm: bool = false,

        f0: bool = false,
        f1: bool = false,
        f2: bool = false,
        f3: bool = false,
        f4: bool = false,
        f5: bool = false,
        f6: bool = false,
        f7: bool = false,
        f8: bool = false,
        f9: bool = false,
        f10: bool = false,
        f11: bool = false,
        f12: bool = false,
        f13: bool = false,
        f14: bool = false,
        f15: bool = false,
        f16: bool = false,
        f17: bool = false,
        f18: bool = false,
        f19: bool = false,
        f20: bool = false,
        f21: bool = false,
        f22: bool = false,
        f23: bool = false,
        f24: bool = false,
        f25: bool = false,
        f26: bool = false,
        f27: bool = false,
        f28: bool = false,
        f29: bool = false,
        f30: bool = false,
        f31: bool = false,

        vtype: bool = false,
        vl: bool = false,
        vxsat: bool = false,
        vxrm: bool = false,
        vcsr: bool = false,

        v0: bool = false,
        v1: bool = false,
        v2: bool = false,
        v3: bool = false,
        v4: bool = false,
        v5: bool = false,
        v6: bool = false,
        v7: bool = false,
        v8: bool = false,
        v9: bool = false,
        v10: bool = false,
        v11: bool = false,
        v12: bool = false,
        v13: bool = false,
        v14: bool = false,
        v15: bool = false,
        v16: bool = false,
        v17: bool = false,
        v18: bool = false,
        v19: bool = false,
        v20: bool = false,
        v21: bool = false,
        v22: bool = false,
        v23: bool = false,
        v24: bool = false,
        v25: bool = false,
        v26: bool = false,
        v27: bool = false,
        v28: bool = false,
        v29: bool = false,
        v30: bool = false,
        v31: bool = false,
    },
    .xcore => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,

        cp: bool = false,
        dp: bool = false,
        sp: bool = false,
        lr: bool = false,
        sr: bool = false,
    },
    .xtensa => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        sar: bool = false,
        lbeg: bool = false,
        lend: bool = false,
        lcount: bool = false,
        atomctl: bool = false,
        scompare1: bool = false,
        threadptr: bool = false,
        litbase: bool = false,
        windowbase: bool = false,
        windowstart: bool = false,
        ps: bool = false,

        a0: bool = false,
        a1: bool = false,
        a2: bool = false,
        a3: bool = false,
        a4: bool = false,
        a5: bool = false,
        a6: bool = false,
        a7: bool = false,
        a8: bool = false,
        a9: bool = false,
        a10: bool = false,
        a11: bool = false,
        a12: bool = false,
        a13: bool = false,
        a14: bool = false,
        a15: bool = false,

        br: bool = false,
        b0: bool = false,
        b1: bool = false,
        b2: bool = false,
        b3: bool = false,
        b4: bool = false,
        b5: bool = false,
        b6: bool = false,
        b7: bool = false,
        b8: bool = false,
        b9: bool = false,
        b10: bool = false,
        b11: bool = false,
        b12: bool = false,
        b13: bool = false,
        b14: bool = false,
        b15: bool = false,

        acchi: bool = false,
        acclo: bool = false,
        m0: bool = false,
        m1: bool = false,
        m2: bool = false,
        m3: bool = false,
        fcr: bool = false,
        fsr: bool = false,

        f0: bool = false,
        f1: bool = false,
        f2: bool = false,
        f3: bool = false,
        f4: bool = false,
        f5: bool = false,
        f6: bool = false,
        f7: bool = false,
        f8: bool = false,
        f9: bool = false,
        f10: bool = false,
        f11: bool = false,
        f12: bool = false,
        f13: bool = false,
        f14: bool = false,
        f15: bool = false,
    },
    .lanai => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,
        /// Condition flags which aren't accessible outside of conditional execution.
        sw: bool = false,

        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
        r16: bool = false,
        r17: bool = false,
        r18: bool = false,
        r19: bool = false,
        r20: bool = false,
        r21: bool = false,
        r22: bool = false,
        r23: bool = false,
        r24: bool = false,
        r25: bool = false,
        r26: bool = false,
        r27: bool = false,
        r28: bool = false,
        r29: bool = false,
        r30: bool = false,
        r31: bool = false,
    },
    .avr => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,
        flags: bool = false,
        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
        r16: bool = false,
        r17: bool = false,
        r18: bool = false,
        r19: bool = false,
        r20: bool = false,
        r21: bool = false,
        r22: bool = false,
        r23: bool = false,
        r24: bool = false,
        r25: bool = false,
        r26: bool = false,
        r27: bool = false,
        r28: bool = false,
        r29: bool = false,
        r30: bool = false,
        r31: bool = false,
    },
    .msp430 => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        r0: bool = false,
        r1: bool = false,
        r2: bool = false,

        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
    },
    .m68k => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        ccr: bool = false,

        d0: bool = false,
        d1: bool = false,
        d2: bool = false,
        d3: bool = false,
        d4: bool = false,
        d5: bool = false,
        d6: bool = false,
        d7: bool = false,

        a0: bool = false,
        a1: bool = false,
        a2: bool = false,
        a3: bool = false,
        a4: bool = false,
        a5: bool = false,
        a6: bool = false,
        a7: bool = false,

        macsr: bool = false,
        acc: bool = false,
        acc0: bool = false,
        acc1: bool = false,
        acc2: bool = false,
        acc3: bool = false,

        mask: bool = false,
        fpcr: bool = false,
        fpsr: bool = false,

        fp0: bool = false,
        fp1: bool = false,
        fp2: bool = false,
        fp3: bool = false,
        fp4: bool = false,
        fp5: bool = false,
        fp6: bool = false,
        fp7: bool = false,
    },
    .sparc, .sparc64 => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        psr: bool = false,
        gsr: bool = false,
        y: bool = false,

        /// asr2; v9+
        ccr: bool = false,
        /// Lower bits of `ccr`.
        icc: bool = false,
        /// Upper bits of `ccr`.
        xcc: bool = false,

        g1: bool = false,
        g2: bool = false,
        g3: bool = false,
        g4: bool = false,
        g5: bool = false,
        g6: bool = false,
        g7: bool = false,

        o0: bool = false,
        o1: bool = false,
        o2: bool = false,
        o3: bool = false,
        o4: bool = false,
        o5: bool = false,
        o6: bool = false,
        o7: bool = false,

        l0: bool = false,
        l1: bool = false,
        l2: bool = false,
        l3: bool = false,
        l4: bool = false,
        l5: bool = false,
        l6: bool = false,
        l7: bool = false,

        i0: bool = false,
        i1: bool = false,
        i2: bool = false,
        i3: bool = false,
        i4: bool = false,
        i5: bool = false,
        i6: bool = false,
        i7: bool = false,

        fsr: bool = false,
        fprs: bool = false,

        q0: bool = false,
        q1: bool = false,
        q2: bool = false,
        q3: bool = false,
        q4: bool = false,
        q5: bool = false,
        q6: bool = false,
        q7: bool = false,
        q8: bool = false,
        q9: bool = false,
        q10: bool = false,
        q11: bool = false,
        q12: bool = false,
        q13: bool = false,
        q14: bool = false,
        q15: bool = false,
    },
    .bpfel, .bpfeb => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,

        w0: bool = false,
        w1: bool = false,
        w2: bool = false,
        w3: bool = false,
        w4: bool = false,
        w5: bool = false,
        w6: bool = false,
        w7: bool = false,
        w8: bool = false,
        w9: bool = false,
    },
    .hexagon => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        sa0: bool = false,
        sa1: bool = false,
        lc0: bool = false,
        lc1: bool = false,
        m0: bool = false,
        m1: bool = false,
        usr: bool = false,
        ugp: bool = false,
        gp: bool = false,
        cs0: bool = false,
        cs1: bool = false,
        framelimit: bool = false,
        framekey: bool = false,

        p0: bool = false,
        p1: bool = false,
        p2: bool = false,
        p3: bool = false,

        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
        r16: bool = false,
        r17: bool = false,
        r18: bool = false,
        r19: bool = false,
        r20: bool = false,
        r21: bool = false,
        r22: bool = false,
        r23: bool = false,
        r24: bool = false,
        r25: bool = false,
        r26: bool = false,
        r27: bool = false,
        r28: bool = false,
        r29: bool = false,
        r30: bool = false,
        r31: bool = false,

        q0: bool = false,
        q1: bool = false,
        q2: bool = false,
        q3: bool = false,

        v0: bool = false,
        v1: bool = false,
        v2: bool = false,
        v3: bool = false,
        v4: bool = false,
        v5: bool = false,
        v6: bool = false,
        v7: bool = false,
        v8: bool = false,
        v9: bool = false,
        v10: bool = false,
        v11: bool = false,
        v12: bool = false,
        v13: bool = false,
        v14: bool = false,
        v15: bool = false,
        v16: bool = false,
        v17: bool = false,
        v18: bool = false,
        v19: bool = false,
        v20: bool = false,
        v21: bool = false,
        v22: bool = false,
        v23: bool = false,
        v24: bool = false,
        v25: bool = false,
        v26: bool = false,
        v27: bool = false,
        v28: bool = false,
        v29: bool = false,
        v30: bool = false,
        v31: bool = false,
    },
    .s390x => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        ps: bool = false,
        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,

        fpc: bool = false,

        v0: bool = false,
        v1: bool = false,
        v2: bool = false,
        v3: bool = false,
        v4: bool = false,
        v5: bool = false,
        v6: bool = false,
        v7: bool = false,
        v8: bool = false,
        v9: bool = false,
        v10: bool = false,
        v11: bool = false,
        v12: bool = false,
        v13: bool = false,
        v14: bool = false,
        v15: bool = false,
        v16: bool = false,
        v17: bool = false,
        v18: bool = false,
        v19: bool = false,
        v20: bool = false,
        v21: bool = false,
        v22: bool = false,
        v23: bool = false,
        v24: bool = false,
        v25: bool = false,
        v26: bool = false,
        v27: bool = false,
        v28: bool = false,
        v29: bool = false,
        v30: bool = false,
        v31: bool = false,

        f0: bool = false,
        f1: bool = false,
        f2: bool = false,
        f3: bool = false,
        f4: bool = false,
        f5: bool = false,
        f6: bool = false,
        f7: bool = false,
        f8: bool = false,
        f9: bool = false,
        f10: bool = false,
        f11: bool = false,
        f12: bool = false,
        f13: bool = false,
        f14: bool = false,
        f15: bool = false,
    },
    .ve => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        psw: bool = false,

        s0: bool = false,
        s1: bool = false,
        s2: bool = false,
        s3: bool = false,
        s4: bool = false,
        s5: bool = false,
        s6: bool = false,
        s7: bool = false,
        s8: bool = false,
        s9: bool = false,
        s10: bool = false,
        s11: bool = false,
        s12: bool = false,
        s13: bool = false,
        s14: bool = false,
        s15: bool = false,
        s16: bool = false,
        s17: bool = false,
        s18: bool = false,
        s19: bool = false,
        s20: bool = false,
        s21: bool = false,
        s22: bool = false,
        s23: bool = false,
        s24: bool = false,
        s25: bool = false,
        s26: bool = false,
        s27: bool = false,
        s28: bool = false,
        s29: bool = false,
        s30: bool = false,
        s31: bool = false,
        s32: bool = false,
        s33: bool = false,
        s34: bool = false,
        s35: bool = false,
        s36: bool = false,
        s37: bool = false,
        s38: bool = false,
        s39: bool = false,
        s40: bool = false,
        s41: bool = false,
        s42: bool = false,
        s43: bool = false,
        s44: bool = false,
        s45: bool = false,
        s46: bool = false,
        s47: bool = false,
        s48: bool = false,
        s49: bool = false,
        s50: bool = false,
        s51: bool = false,
        s52: bool = false,
        s53: bool = false,
        s54: bool = false,
        s55: bool = false,
        s56: bool = false,
        s57: bool = false,
        s58: bool = false,
        s59: bool = false,
        s60: bool = false,
        s61: bool = false,
        s62: bool = false,
        s63: bool = false,

        vixr: bool = false,
        vl: bool = false,

        vm0: bool = false,
        vm1: bool = false,
        vm2: bool = false,
        vm3: bool = false,
        vm4: bool = false,
        vm5: bool = false,
        vm6: bool = false,
        vm7: bool = false,
        vm8: bool = false,
        vm9: bool = false,
        vm10: bool = false,
        vm11: bool = false,
        vm12: bool = false,
        vm13: bool = false,
        vm14: bool = false,
        vm15: bool = false,

        v0: bool = false,
        v1: bool = false,
        v2: bool = false,
        v3: bool = false,
        v4: bool = false,
        v5: bool = false,
        v6: bool = false,
        v7: bool = false,
        v8: bool = false,
        v9: bool = false,
        v10: bool = false,
        v11: bool = false,
        v12: bool = false,
        v13: bool = false,
        v14: bool = false,
        v15: bool = false,
        v16: bool = false,
        v17: bool = false,
        v18: bool = false,
        v19: bool = false,
        v20: bool = false,
        v21: bool = false,
        v22: bool = false,
        v23: bool = false,
        v24: bool = false,
        v25: bool = false,
        v26: bool = false,
        v27: bool = false,
        v28: bool = false,
        v29: bool = false,
        v30: bool = false,
        v31: bool = false,
        v32: bool = false,
        v33: bool = false,
        v34: bool = false,
        v35: bool = false,
        v36: bool = false,
        v37: bool = false,
        v38: bool = false,
        v39: bool = false,
        v40: bool = false,
        v41: bool = false,
        v42: bool = false,
        v43: bool = false,
        v44: bool = false,
        v45: bool = false,
        v46: bool = false,
        v47: bool = false,
        v48: bool = false,
        v49: bool = false,
        v50: bool = false,
        v51: bool = false,
        v52: bool = false,
        v53: bool = false,
        v54: bool = false,
        v55: bool = false,
        v56: bool = false,
        v57: bool = false,
        v58: bool = false,
        v59: bool = false,
        v60: bool = false,
        v61: bool = false,
        v62: bool = false,
        v63: bool = false,
    },
    .kalimba => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        i0: bool = false,
        i1: bool = false,
        i2: bool = false,
        i3: bool = false,
        i4: bool = false,
        i5: bool = false,
        i6: bool = false,
        i7: bool = false,

        m0: bool = false,
        m1: bool = false,
        m2: bool = false,
        m3: bool = false,
        l0: bool = false,
        l1: bool = false,
        l2: bool = false,
        l3: bool = false,
        l4: bool = false,
        l5: bool = false,
        doloopstart: bool = false,
        doloopend: bool = false,
        divresult: bool = false,
        divremainder: bool = false,
        rmac: bool = false,
        rmac0: bool = false,
        rmac1: bool = false,
        rmac2: bool = false,
        rlink: bool = false,
        rflags: bool = false,
        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
    },
    .or1k => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        maclo: bool = false,
        machi: bool = false,
        fpcsr: bool = false,
        fpmaddlo: bool = false,
        fpmaddhi: bool = false,
        vmaclo: bool = false,
        vmachi: bool = false,

        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
        r16: bool = false,
        r17: bool = false,
        r18: bool = false,
        r19: bool = false,
        r20: bool = false,
        r21: bool = false,
        r22: bool = false,
        r23: bool = false,
        r24: bool = false,
        r25: bool = false,
        r26: bool = false,
        r27: bool = false,
        r28: bool = false,
        r29: bool = false,
        r30: bool = false,
        r31: bool = false,
    },
    .csky => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        psr: bool = false,
        hi: bool = false,
        lo: bool = false,

        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
        r16: bool = false,
        r17: bool = false,
        r18: bool = false,
        r19: bool = false,
        r20: bool = false,
        r21: bool = false,
        r22: bool = false,
        r23: bool = false,
        r24: bool = false,
        r25: bool = false,
        r26: bool = false,
        r27: bool = false,
        r28: bool = false,
        r29: bool = false,
        r30: bool = false,
        r31: bool = false,

        vr0: bool = false,
        vr1: bool = false,
        vr2: bool = false,
        vr3: bool = false,
        vr4: bool = false,
        vr5: bool = false,
        vr6: bool = false,
        vr7: bool = false,
        vr8: bool = false,
        vr9: bool = false,
        vr10: bool = false,
        vr11: bool = false,
        vr12: bool = false,
        vr13: bool = false,
        vr14: bool = false,
        vr15: bool = false,
        vr16: bool = false,
        vr17: bool = false,
        vr18: bool = false,
        vr19: bool = false,
        vr20: bool = false,
        vr21: bool = false,
        vr22: bool = false,
        vr23: bool = false,
        vr24: bool = false,
        vr25: bool = false,
        vr26: bool = false,
        vr27: bool = false,
        vr28: bool = false,
        vr29: bool = false,
        vr30: bool = false,
        vr31: bool = false,
    },
    .arc => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        status32: bool = false,
        aux_macmode: bool = false,
        mulhi: bool = false,
        lp_start: bool = false,
        lp_end: bool = false,
        jli_base: bool = false,
        ldi_base: bool = false,
        ei_base: bool = false,

        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
        r16: bool = false,
        r17: bool = false,
        r18: bool = false,
        r19: bool = false,
        r20: bool = false,
        r21: bool = false,
        r22: bool = false,
        r23: bool = false,
        r24: bool = false,
        r25: bool = false,
        r26: bool = false,
        r27: bool = false,
        r28: bool = false,
        r29: bool = false,
        r30: bool = false,
        r31: bool = false,
        r32: bool = false,
        r33: bool = false,
        r34: bool = false,
        r35: bool = false,
        r36: bool = false,
        r37: bool = false,
        r38: bool = false,
        r39: bool = false,
        r40: bool = false,
        r41: bool = false,
        r42: bool = false,
        r43: bool = false,
        r44: bool = false,
        r45: bool = false,
        r46: bool = false,
        r47: bool = false,
        r48: bool = false,
        r49: bool = false,
        r50: bool = false,
        r51: bool = false,
        r52: bool = false,
        r53: bool = false,
        r54: bool = false,
        r55: bool = false,
        r56: bool = false,
        r57: bool = false,
        r58: bool = false,
        r59: bool = false,
        r60: bool = false,

        fmp_ctrl: bool = false,
        dsp_ctrl: bool = false,
        acc0_lo: bool = false,
        acc0_glo: bool = false,
        acc0_hi: bool = false,
        acc0_ghi: bool = false,
        fp_ctrl: bool = false,
        fpu_status: bool = false,
        vfpu_status: bool = false,

        f0: bool = false,
        f1: bool = false,
        f2: bool = false,
        f3: bool = false,
        f4: bool = false,
        f5: bool = false,
        f6: bool = false,
        f7: bool = false,
        f8: bool = false,
        f9: bool = false,
        f10: bool = false,
        f11: bool = false,
        f12: bool = false,
        f13: bool = false,
        f14: bool = false,
        f15: bool = false,
        f16: bool = false,
        f17: bool = false,
        f18: bool = false,
        f19: bool = false,
        f20: bool = false,
        f21: bool = false,
        f22: bool = false,
        f23: bool = false,
        f24: bool = false,
        f25: bool = false,
        f26: bool = false,
        f27: bool = false,
        f28: bool = false,
        f29: bool = false,
        f30: bool = false,
        f31: bool = false,
    },
    .loongarch32, .loongarch64 => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
        r16: bool = false,
        r17: bool = false,
        r18: bool = false,
        r19: bool = false,
        r20: bool = false,
        r21: bool = false,
        r22: bool = false,
        r23: bool = false,
        r24: bool = false,
        r25: bool = false,
        r26: bool = false,
        r27: bool = false,
        r28: bool = false,
        r29: bool = false,
        r30: bool = false,
        r31: bool = false,

        fcc0: bool = false,
        fcc1: bool = false,
        fcc2: bool = false,
        fcc3: bool = false,
        fcc4: bool = false,
        fcc5: bool = false,
        fcc6: bool = false,
        fcc7: bool = false,

        fcsr0: bool = false,
        fcsr1: bool = false,
        fcsr2: bool = false,
        fcsr3: bool = false,

        xr0: bool = false,
        xr1: bool = false,
        xr2: bool = false,
        xr3: bool = false,
        xr4: bool = false,
        xr5: bool = false,
        xr6: bool = false,
        xr7: bool = false,
        xr8: bool = false,
        xr9: bool = false,
        xr10: bool = false,
        xr11: bool = false,
        xr12: bool = false,
        xr13: bool = false,
        xr14: bool = false,
        xr15: bool = false,
        xr16: bool = false,
        xr17: bool = false,
        xr18: bool = false,
        xr19: bool = false,
        xr20: bool = false,
        xr21: bool = false,
        xr22: bool = false,
        xr23: bool = false,
        xr24: bool = false,
        xr25: bool = false,
        xr26: bool = false,
        xr27: bool = false,
        xr28: bool = false,
        xr29: bool = false,
        xr30: bool = false,
        xr31: bool = false,

        vr0: bool = false,
        vr1: bool = false,
        vr2: bool = false,
        vr3: bool = false,
        vr4: bool = false,
        vr5: bool = false,
        vr6: bool = false,
        vr7: bool = false,
        vr8: bool = false,
        vr9: bool = false,
        vr10: bool = false,
        vr11: bool = false,
        vr12: bool = false,
        vr13: bool = false,
        vr14: bool = false,
        vr15: bool = false,
        vr16: bool = false,
        vr17: bool = false,
        vr18: bool = false,
        vr19: bool = false,
        vr20: bool = false,
        vr21: bool = false,
        vr22: bool = false,
        vr23: bool = false,
        vr24: bool = false,
        vr25: bool = false,
        vr26: bool = false,
        vr27: bool = false,
        vr28: bool = false,
        vr29: bool = false,
        vr30: bool = false,
        vr31: bool = false,

        f0: bool = false,
        f1: bool = false,
        f2: bool = false,
        f3: bool = false,
        f4: bool = false,
        f5: bool = false,
        f6: bool = false,
        f7: bool = false,
        f8: bool = false,
        f9: bool = false,
        f10: bool = false,
        f11: bool = false,
        f12: bool = false,
        f13: bool = false,
        f14: bool = false,
        f15: bool = false,
        f16: bool = false,
        f17: bool = false,
        f18: bool = false,
        f19: bool = false,
        f20: bool = false,
        f21: bool = false,
        f22: bool = false,
        f23: bool = false,
        f24: bool = false,
        f25: bool = false,
        f26: bool = false,
        f27: bool = false,
        f28: bool = false,
        f29: bool = false,
        f30: bool = false,
        f31: bool = false,
    },
    .powerpc, .powerpcle, .powerpc64, .powerpc64le => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        cr0: bool = false,
        cr1: bool = false,
        cr2: bool = false,
        cr3: bool = false,
        cr4: bool = false,
        cr5: bool = false,
        cr6: bool = false,
        cr7: bool = false,

        xer: bool = false,
        ctr: bool = false,
        lr: bool = false,

        r0: bool = false,
        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
        r16: bool = false,
        r17: bool = false,
        r18: bool = false,
        r19: bool = false,
        r20: bool = false,
        r21: bool = false,
        r22: bool = false,
        r23: bool = false,
        r24: bool = false,
        r25: bool = false,
        r26: bool = false,
        r27: bool = false,
        r28: bool = false,
        r29: bool = false,
        r30: bool = false,
        r31: bool = false,

        fpscr: bool = false,
        vscr: bool = false,

        vs0: bool = false,
        vs1: bool = false,
        vs2: bool = false,
        vs3: bool = false,
        vs4: bool = false,
        vs5: bool = false,
        vs6: bool = false,
        vs7: bool = false,
        vs8: bool = false,
        vs9: bool = false,
        vs10: bool = false,
        vs11: bool = false,
        vs12: bool = false,
        vs13: bool = false,
        vs14: bool = false,
        vs15: bool = false,
        vs16: bool = false,
        vs17: bool = false,
        vs18: bool = false,
        vs19: bool = false,
        vs20: bool = false,
        vs21: bool = false,
        vs22: bool = false,
        vs23: bool = false,
        vs24: bool = false,
        vs25: bool = false,
        vs26: bool = false,
        vs27: bool = false,
        vs28: bool = false,
        vs29: bool = false,
        vs30: bool = false,
        vs31: bool = false,
        vs32: bool = false,
        vs33: bool = false,
        vs34: bool = false,
        vs35: bool = false,
        vs36: bool = false,
        vs37: bool = false,
        vs38: bool = false,
        vs39: bool = false,
        vs40: bool = false,
        vs41: bool = false,
        vs42: bool = false,
        vs43: bool = false,
        vs44: bool = false,
        vs45: bool = false,
        vs46: bool = false,
        vs47: bool = false,
        vs48: bool = false,
        vs49: bool = false,
        vs50: bool = false,
        vs51: bool = false,
        vs52: bool = false,
        vs53: bool = false,
        vs54: bool = false,
        vs55: bool = false,
        vs56: bool = false,
        vs57: bool = false,
        vs58: bool = false,
        vs59: bool = false,
        vs60: bool = false,
        vs61: bool = false,
        vs62: bool = false,
        vs63: bool = false,

        f0: bool = false,
        f1: bool = false,
        f2: bool = false,
        f3: bool = false,
        f4: bool = false,
        f5: bool = false,
        f6: bool = false,
        f7: bool = false,
        f8: bool = false,
        f9: bool = false,
        f10: bool = false,
        f11: bool = false,
        f12: bool = false,
        f13: bool = false,
        f14: bool = false,
        f15: bool = false,
        f16: bool = false,
        f17: bool = false,
        f18: bool = false,
        f19: bool = false,
        f20: bool = false,
        f21: bool = false,
        f22: bool = false,
        f23: bool = false,
        f24: bool = false,
        f25: bool = false,
        f26: bool = false,
        f27: bool = false,
        f28: bool = false,
        f29: bool = false,
        f30: bool = false,
        f31: bool = false,

        v0: bool = false,
        v1: bool = false,
        v2: bool = false,
        v3: bool = false,
        v4: bool = false,
        v5: bool = false,
        v6: bool = false,
        v7: bool = false,
        v8: bool = false,
        v9: bool = false,
        v10: bool = false,
        v11: bool = false,
        v12: bool = false,
        v13: bool = false,
        v14: bool = false,
        v15: bool = false,
        v16: bool = false,
        v17: bool = false,
        v18: bool = false,
        v19: bool = false,
        v20: bool = false,
        v21: bool = false,
        v22: bool = false,
        v23: bool = false,
        v24: bool = false,
        v25: bool = false,
        v26: bool = false,
        v27: bool = false,
        v28: bool = false,
        v29: bool = false,
        v30: bool = false,
        v31: bool = false,

        acc0: bool = false,
        acc1: bool = false,
        acc2: bool = false,
        acc3: bool = false,
        acc4: bool = false,
        acc5: bool = false,
        acc6: bool = false,
        acc7: bool = false,

        acc: bool = false,
        spefsc: bool = false,
    },
    .mips, .mipsel, .mips64, .mips64el => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,

        lr: bool = false,

        hi: bool = false,
        lo: bool = false,
        ac0: bool = false,
        ac1: bool = false,
        ac2: bool = false,
        ac3: bool = false,
        acx: bool = false,

        r1: bool = false,
        r2: bool = false,
        r3: bool = false,
        r4: bool = false,
        r5: bool = false,
        r6: bool = false,
        r7: bool = false,
        r8: bool = false,
        r9: bool = false,
        r10: bool = false,
        r11: bool = false,
        r12: bool = false,
        r13: bool = false,
        r14: bool = false,
        r15: bool = false,
        r16: bool = false,
        r17: bool = false,
        r18: bool = false,
        r19: bool = false,
        r20: bool = false,
        r21: bool = false,
        r22: bool = false,
        r23: bool = false,
        r24: bool = false,
        r25: bool = false,
        r26: bool = false,
        r27: bool = false,
        r28: bool = false,
        r29: bool = false,
        r30: bool = false,
        r31: bool = false,

        fcsr: bool = false,
        fcc0: bool = false,
        fcc1: bool = false,
        fcc2: bool = false,
        fcc3: bool = false,
        fcc4: bool = false,
        fcc5: bool = false,
        fcc6: bool = false,
        fcc7: bool = false,

        w0: bool = false,
        w1: bool = false,
        w2: bool = false,
        w3: bool = false,
        w4: bool = false,
        w5: bool = false,
        w6: bool = false,
        w7: bool = false,
        w8: bool = false,
        w9: bool = false,
        w10: bool = false,
        w11: bool = false,
        w12: bool = false,
        w13: bool = false,
        w14: bool = false,
        w15: bool = false,
        w16: bool = false,
        w17: bool = false,
        w18: bool = false,
        w19: bool = false,
        w20: bool = false,
        w21: bool = false,
        w22: bool = false,
        w23: bool = false,
        w24: bool = false,
        w25: bool = false,
        w26: bool = false,
        w27: bool = false,
        w28: bool = false,
        w29: bool = false,
        w30: bool = false,
        w31: bool = false,

        f0: bool = false,
        f1: bool = false,
        f2: bool = false,
        f3: bool = false,
        f4: bool = false,
        f5: bool = false,
        f6: bool = false,
        f7: bool = false,
        f8: bool = false,
        f9: bool = false,
        f10: bool = false,
        f11: bool = false,
        f12: bool = false,
        f13: bool = false,
        f14: bool = false,
        f15: bool = false,
        f16: bool = false,
        f17: bool = false,
        f18: bool = false,
        f19: bool = false,
        f20: bool = false,
        f21: bool = false,
        f22: bool = false,
        f23: bool = false,
        f24: bool = false,
        f25: bool = false,
        f26: bool = false,
        f27: bool = false,
        f28: bool = false,
        f29: bool = false,
        f30: bool = false,
        f31: bool = false,

        mpl0: bool = false,
        mpl1: bool = false,
        mpl2: bool = false,

        p0: bool = false,
        p1: bool = false,
        p2: bool = false,

        msa_ir: bool = false,
        msa_csr: bool = false,
        msa_access: bool = false,
        msa_save: bool = false,
        msa_modify: bool = false,
        msa_request: bool = false,
        msa_map: bool = false,
        msa_unmap: bool = false,
    },
    else => packed struct {
        /// Whether the inline assembly code may perform stores to memory
        /// addresses other than those derived from input pointer provenance.
        memory: bool = false,
    },
};
