/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.skin.SkinParamColors;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.MergeStrategy;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.utils.Direction;

public final class WElement {
    private final HColor backColor;
    private final Display label;
    private final int level;
    private final Stereotype stereotype;
    private final WElement parent;
    private final StyleBuilder styleBuilder;
    private final List<WElement> childrenLeft = new ArrayList<WElement>();
    private final List<WElement> childrenRight = new ArrayList<WElement>();
    private final IdeaShape shape;
    private UTranslate position;
    private XDimension2D dimension;
    public static final int STEP_BY_PARENT = 10001000;

    private StyleSignatureBasic getDefaultStyleDefinitionNode(int level) {
        if (level == 0) {
            if (this.shape == IdeaShape.NONE) {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.rootNode, SName.boxless).addStereotype(this.stereotype).addLevel(level);
            }
            return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.rootNode).addStereotype(this.stereotype).addLevel(level);
        }
        if (this.shape == IdeaShape.NONE && this.isLeaf()) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.leafNode, SName.boxless).addStereotype(this.stereotype).addLevel(level);
        }
        if (this.isLeaf()) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.leafNode).addStereotype(this.stereotype).addLevel(level);
        }
        if (this.shape == IdeaShape.NONE) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node, SName.boxless).addStereotype(this.stereotype).addLevel(level);
        }
        return StyleSignatureBasic.of(SName.root, SName.element, SName.wbsDiagram, SName.node).addStereotype(this.stereotype).addLevel(level);
    }

    public ISkinParam withBackColor(ISkinParam skinParam) {
        if (this.backColor == null) {
            return skinParam;
        }
        return new SkinParamColors(skinParam, Colors.empty().add(ColorType.BACK, this.backColor));
    }

    public Style getStyle() {
        int deltaPriority = 1411065408;
        Style result = this.styleBuilder.getMergedStyleSpecial(this.getDefaultStyleDefinitionNode(this.level), deltaPriority);
        WElement up = this.parent;
        while (up != null) {
            StyleSignatureBasic ss = up.getDefaultStyleDefinitionNode(this.level).addStar();
            Style styleParent = this.styleBuilder.getMergedStyleSpecial(ss, deltaPriority -= 10001000);
            result = result.mergeWith(styleParent, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            up = up.parent;
        }
        return result;
    }

    public WElement(HColor backColor, Display label, Stereotype stereotype, StyleBuilder styleBuilder, IdeaShape shape) {
        this(backColor, 0, label, stereotype, null, shape, styleBuilder);
    }

    private WElement(HColor backColor, int level, Display label, Stereotype stereotype, WElement parent, IdeaShape shape, StyleBuilder styleBuilder) {
        this.label = label;
        this.backColor = backColor;
        this.level = level;
        this.parent = parent;
        this.shape = shape;
        this.styleBuilder = styleBuilder;
        this.stereotype = stereotype;
    }

    public boolean isLeaf() {
        return this.childrenLeft.size() == 0 && this.childrenRight.size() == 0;
    }

    public WElement createElement(HColor backColor, int newLevel, Display newLabel, Stereotype stereotype, Direction direction, IdeaShape shape, StyleBuilder styleBuilder) {
        WElement result = new WElement(backColor, newLevel, newLabel, stereotype, this, shape, styleBuilder);
        if (direction == Direction.LEFT && newLevel == 1) {
            this.childrenRight.add(0, result);
        }
        if (direction == Direction.LEFT) {
            this.childrenLeft.add(result);
        } else {
            this.childrenRight.add(result);
        }
        return result;
    }

    public String toString() {
        return this.label.toString();
    }

    public final int getLevel() {
        return this.level;
    }

    public final Display getLabel() {
        return this.label;
    }

    public Collection<WElement> getChildren(Direction direction) {
        if (direction == Direction.LEFT) {
            return Collections.unmodifiableList(this.childrenLeft);
        }
        return Collections.unmodifiableList(this.childrenRight);
    }

    public WElement getParent() {
        return this.parent;
    }

    public final IdeaShape getShape() {
        return this.shape;
    }

    public final StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }

    public final void setGeometry(UTranslate position, XDimension2D dimension) {
        this.position = position;
        this.dimension = dimension;
    }

    public final UTranslate getPosition() {
        return this.position;
    }

    public final XDimension2D getDimension() {
        return this.dimension;
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }
}

