/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.CredentialRegistrator;
import org.keycloak.authentication.InitiatedActionSupport;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.credential.RecoveryAuthnCodesCredentialModel;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.userprofile.ValidationException;
import org.keycloak.utils.CredentialHelper;
import org.keycloak.validate.ValidationError;

public class RecoveryAuthnCodesAction
implements RequiredActionProvider,
RequiredActionFactory,
EnvironmentDependentProviderFactory,
CredentialRegistrator {
    private static final String FIELD_GENERATED_RECOVERY_AUTHN_CODES_HIDDEN = "generatedRecoveryAuthnCodes";
    private static final String FIELD_GENERATED_AT_HIDDEN = "generatedAt";
    private static final String FIELD_USER_LABEL_HIDDEN = "userLabel";
    public static final String PROVIDER_ID;
    private static final RecoveryAuthnCodesAction INSTANCE;
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES;
    public static final String WARNING_THRESHOLD = "warning_threshold";
    public static final int RECOVERY_CODES_WARNING_THRESHOLD_DEFAULT = 4;

    public String getId() {
        return PROVIDER_ID;
    }

    public String getCredentialType(KeycloakSession session, AuthenticationSessionModel authenticationSession) {
        return "recovery-authn-codes";
    }

    public String getDisplayText() {
        return "Recovery Authentication Codes";
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return INSTANCE;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public boolean isOneTimeAction() {
        return true;
    }

    public InitiatedActionSupport initiatedActionSupport() {
        return InitiatedActionSupport.SUPPORTED;
    }

    public void evaluateTriggers(RequiredActionContext context) {
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().createResponse(UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext reqActionContext) {
        EventBuilder event = reqActionContext.getEvent();
        event.event(EventType.UPDATE_CREDENTIAL);
        event.detail("credential_type", "recovery-authn-codes");
        MultivaluedMap httpReqParamsMap = reqActionContext.getHttpRequest().getDecodedFormParameters();
        String generatedCodesString = (String)httpReqParamsMap.getFirst((Object)FIELD_GENERATED_RECOVERY_AUTHN_CODES_HIDDEN);
        String generatedAtTimeString = (String)httpReqParamsMap.getFirst((Object)FIELD_GENERATED_AT_HIDDEN);
        String generatedUserLabel = (String)httpReqParamsMap.getFirst((Object)FIELD_USER_LABEL_HIDDEN);
        if (!generatedAtTimeString.equals(reqActionContext.getAuthenticationSession().getAuthNote("RecoveryAuthnCodes.generatedAt")) || !generatedCodesString.equals(reqActionContext.getAuthenticationSession().getAuthNote("RecoveryAuthnCodes.generatedRecoveryAuthnCodes"))) {
            this.requiredActionChallenge(reqActionContext);
            return;
        }
        reqActionContext.getAuthenticationSession().removeAuthNote("RecoveryAuthnCodes.generatedAt");
        reqActionContext.getAuthenticationSession().removeAuthNote("RecoveryAuthnCodes.generatedRecoveryAuthnCodes");
        List<String> generatedCodes = Arrays.asList(generatedCodesString.split(","));
        RecoveryAuthnCodesCredentialModel credentialModel = this.createFromValues(generatedCodes, Long.valueOf(generatedAtTimeString), generatedUserLabel);
        if ("on".equals(httpReqParamsMap.getFirst((Object)"logout-sessions"))) {
            AuthenticatorUtil.logoutOtherSessions(reqActionContext);
        }
        CredentialHelper.createRecoveryCodesCredential((KeycloakSession)reqActionContext.getSession(), (RealmModel)reqActionContext.getRealm(), (UserModel)reqActionContext.getUser(), (RecoveryAuthnCodesCredentialModel)credentialModel, generatedCodes);
        reqActionContext.success();
    }

    protected RecoveryAuthnCodesCredentialModel createFromValues(List<String> generatedCodes, Long generatedAtTime, String generatedUserLabel) {
        return RecoveryAuthnCodesCredentialModel.createFromValues(generatedCodes, (long)generatedAtTime, (String)generatedUserLabel);
    }

    public void close() {
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.RECOVERY_CODES);
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return Stream.concat(List.copyOf(CONFIG_PROPERTIES).stream(), super.getConfigMetadata().stream()).toList();
    }

    public void validateConfig(KeycloakSession session, RealmModel realm, RequiredActionConfigModel model) {
        int parsedMaxAuthAge;
        super.validateConfig(session, realm, model);
        try {
            parsedMaxAuthAge = this.parseWarningThreshold(model);
        }
        catch (Exception ex) {
            throw new ValidationException(new ValidationError(this.getId(), WARNING_THRESHOLD, "error-invalid-value"));
        }
        if (parsedMaxAuthAge < 0) {
            throw new ValidationException(new ValidationError(this.getId(), WARNING_THRESHOLD, "error-number-out-of-range-too-small", new Object[]{0}));
        }
    }

    private int parseWarningThreshold(RequiredActionConfigModel model) throws NumberFormatException {
        return Integer.parseInt(model.getConfigValue(WARNING_THRESHOLD));
    }

    static {
        List properties;
        PROVIDER_ID = UserModel.RequiredAction.CONFIGURE_RECOVERY_AUTHN_CODES.name();
        INSTANCE = new RecoveryAuthnCodesAction();
        CONFIG_PROPERTIES = properties = ProviderConfigurationBuilder.create().property().name(WARNING_THRESHOLD).label("Warning Threshold").helpText("When user has smaller amount of remaining recovery codes on his account than the value configured here, account console will show warning to the user, which will recommend him to setup new set of recovery codes.").type("Integer").defaultValue((Object)4).add().build();
    }
}

