/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.EquivalentAddressGroup;
import io.grpc.NameResolver;
import io.grpc.StatusOr;
import io.netty.channel.unix.DomainSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;

final class UdsNameResolver
extends NameResolver {
    private NameResolver.Listener2 listener;
    private final String authority;

    UdsNameResolver(String authority, String targetPath, NameResolver.Args args) {
        Preconditions.checkArgument((authority == null ? 1 : 0) != 0, (Object)"non-null authority not supported");
        this.authority = targetPath;
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public void start(NameResolver.Listener2 listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"already started");
        this.listener = (NameResolver.Listener2)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        this.resolve();
    }

    public void refresh() {
        this.resolve();
    }

    private void resolve() {
        NameResolver.ResolutionResult.Builder resolutionResultBuilder = NameResolver.ResolutionResult.newBuilder();
        ArrayList<EquivalentAddressGroup> servers = new ArrayList<EquivalentAddressGroup>(1);
        servers.add(new EquivalentAddressGroup((SocketAddress)new DomainSocketAddress(this.authority)));
        resolutionResultBuilder.setAddressesOrError(StatusOr.fromValue(servers));
        this.listener.onResult2(resolutionResultBuilder.build());
    }

    public void shutdown() {
    }
}

