/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jta.internal;

import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.transaction.TransactionRequiredForJoinException;
import org.hibernate.resource.transaction.backend.jta.internal.JtaIsolationDelegate;
import org.hibernate.resource.transaction.backend.jta.internal.JtaLogging;
import org.hibernate.resource.transaction.backend.jta.internal.JtaPlatformInaccessibleException;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionAdapter;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionAdapterTransactionManagerImpl;
import org.hibernate.resource.transaction.backend.jta.internal.JtaTransactionAdapterUserTransactionImpl;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.RegisteredSynchronization;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.SynchronizationCallbackCoordinator;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.SynchronizationCallbackCoordinatorNonTrackingImpl;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.SynchronizationCallbackCoordinatorTrackingImpl;
import org.hibernate.resource.transaction.backend.jta.internal.synchronization.SynchronizationCallbackTarget;
import org.hibernate.resource.transaction.internal.SynchronizationRegistryStandardImpl;
import org.hibernate.resource.transaction.spi.IsolationDelegate;
import org.hibernate.resource.transaction.spi.SynchronizationRegistry;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorOwner;
import org.hibernate.resource.transaction.spi.TransactionObserver;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class JtaTransactionCoordinatorImpl
implements TransactionCoordinator,
SynchronizationCallbackTarget {
    private final TransactionCoordinatorBuilder transactionCoordinatorBuilder;
    private final TransactionCoordinatorOwner transactionCoordinatorOwner;
    private final JtaPlatform jtaPlatform;
    private final boolean autoJoinTransactions;
    private final boolean preferUserTransactions;
    private final boolean performJtaThreadTracking;
    private boolean synchronizationRegistered;
    private SynchronizationCallbackCoordinator callbackCoordinator;
    private TransactionDriverControlImpl physicalTransactionDelegate;
    private final SynchronizationRegistryStandardImpl synchronizationRegistry = new SynchronizationRegistryStandardImpl();
    private int timeOut = -1;
    private transient List<TransactionObserver> observers = null;

    JtaTransactionCoordinatorImpl(TransactionCoordinatorBuilder transactionCoordinatorBuilder, TransactionCoordinatorOwner owner, boolean autoJoinTransactions, JtaPlatform jtaPlatform) {
        this.transactionCoordinatorBuilder = transactionCoordinatorBuilder;
        this.transactionCoordinatorOwner = owner;
        this.autoJoinTransactions = autoJoinTransactions;
        JdbcSessionContext jdbcSessionContext = owner.getJdbcSessionOwner().getJdbcSessionContext();
        this.jtaPlatform = jtaPlatform;
        this.preferUserTransactions = jdbcSessionContext.isPreferUserTransaction();
        this.performJtaThreadTracking = jdbcSessionContext.isJtaTrackByThread();
        this.synchronizationRegistered = false;
        this.pulse();
    }

    public JtaTransactionCoordinatorImpl(TransactionCoordinatorBuilder transactionCoordinatorBuilder, TransactionCoordinatorOwner owner, boolean autoJoinTransactions, JtaPlatform jtaPlatform, boolean preferUserTransactions, boolean performJtaThreadTracking, TransactionObserver ... observers) {
        this.transactionCoordinatorBuilder = transactionCoordinatorBuilder;
        this.transactionCoordinatorOwner = owner;
        this.autoJoinTransactions = autoJoinTransactions;
        this.jtaPlatform = jtaPlatform;
        this.preferUserTransactions = preferUserTransactions;
        this.performJtaThreadTracking = performJtaThreadTracking;
        if (observers != null) {
            this.observers = new ArrayList<TransactionObserver>(observers.length);
            Collections.addAll(this.observers, observers);
        }
        this.synchronizationRegistered = false;
        this.pulse();
    }

    private Iterable<TransactionObserver> observers() {
        return this.observers == null ? Collections.emptyList() : new ArrayList<TransactionObserver>(this.observers);
    }

    public SynchronizationCallbackCoordinator getSynchronizationCallbackCoordinator() {
        if (this.callbackCoordinator == null) {
            this.callbackCoordinator = this.performJtaThreadTracking ? new SynchronizationCallbackCoordinatorTrackingImpl(this) : new SynchronizationCallbackCoordinatorNonTrackingImpl(this);
        }
        return this.callbackCoordinator;
    }

    @Override
    public void pulse() {
        if (this.autoJoinTransactions && !this.synchronizationRegistered) {
            if (!this.jtaPlatform.canRegisterSynchronization()) {
                JtaLogging.JTA_LOGGER.trace("JTA platform says we cannot currently register synchronization; skipping");
            } else {
                this.joinJtaTransaction();
            }
        }
    }

    private void joinJtaTransaction() {
        if (!this.synchronizationRegistered) {
            this.jtaPlatform.registerSynchronization(new RegisteredSynchronization(this.getSynchronizationCallbackCoordinator()));
            this.getSynchronizationCallbackCoordinator().synchronizationRegistered();
            this.synchronizationRegistered = true;
            JtaLogging.JTA_LOGGER.trace("Hibernate RegisteredSynchronization successfully registered with JTA platform");
            this.getTransactionCoordinatorOwner().startTransactionBoundary();
        }
    }

    @Override
    public void explicitJoin() {
        if (this.synchronizationRegistered) {
            JtaLogging.JTA_LOGGER.trace("JTA transaction was already joined (RegisteredSynchronization already registered)");
        } else {
            if (this.getTransactionDriverControl().getStatus() != TransactionStatus.ACTIVE) {
                throw new TransactionRequiredForJoinException("Explicitly joining a JTA transaction requires a JTA transaction be currently active");
            }
            this.joinJtaTransaction();
        }
    }

    @Override
    public boolean isJoined() {
        return this.synchronizationRegistered;
    }

    public boolean isSynchronizationRegistered() {
        return this.synchronizationRegistered;
    }

    public TransactionCoordinatorOwner getTransactionCoordinatorOwner() {
        return this.transactionCoordinatorOwner;
    }

    @Override
    public JpaCompliance getJpaCompliance() {
        return this.transactionCoordinatorOwner.getJdbcSessionOwner().getJdbcSessionContext().getJpaCompliance();
    }

    @Override
    public TransactionCoordinator.TransactionDriver getTransactionDriverControl() {
        if (this.physicalTransactionDelegate == null) {
            this.physicalTransactionDelegate = this.makePhysicalTransactionDelegate();
        }
        return this.physicalTransactionDelegate;
    }

    private TransactionDriverControlImpl makePhysicalTransactionDelegate() {
        JtaTransactionAdapter adapter;
        JtaTransactionAdapter jtaTransactionAdapter = adapter = this.preferUserTransactions ? this.getTransactionAdapterPreferringUserTransaction() : this.getTransactionAdapterPreferringTransactionManager();
        if (adapter == null) {
            throw new JtaPlatformInaccessibleException("Unable to access TransactionManager or UserTransaction to make physical transaction delegate");
        }
        return new TransactionDriverControlImpl(adapter);
    }

    private JtaTransactionAdapter getTransactionAdapterPreferringTransactionManager() {
        JtaTransactionAdapter adapter = this.makeTransactionManagerAdapter();
        if (adapter == null) {
            JtaLogging.JTA_LOGGER.debug("Unable to access TransactionManager, attempting to use UserTransaction instead");
            return this.makeUserTransactionAdapter();
        }
        return adapter;
    }

    private JtaTransactionAdapter getTransactionAdapterPreferringUserTransaction() {
        JtaTransactionAdapter adapter = this.makeUserTransactionAdapter();
        if (adapter == null) {
            JtaLogging.JTA_LOGGER.debug("Unable to access UserTransaction, attempting to use TransactionManager instead");
            return this.makeTransactionManagerAdapter();
        }
        return adapter;
    }

    private JtaTransactionAdapter makeUserTransactionAdapter() {
        try {
            UserTransaction userTransaction = this.jtaPlatform.retrieveUserTransaction();
            if (userTransaction == null) {
                JtaLogging.JTA_LOGGER.debug("JtaPlatform.retrieveUserTransaction() returned null");
                return null;
            }
            return new JtaTransactionAdapterUserTransactionImpl(userTransaction);
        }
        catch (Exception exception) {
            JtaLogging.JTA_LOGGER.debugf("JtaPlatform.retrieveUserTransaction() threw an exception [%s]", exception.getMessage());
            return null;
        }
    }

    private JtaTransactionAdapter makeTransactionManagerAdapter() {
        try {
            TransactionManager transactionManager = this.jtaPlatform.retrieveTransactionManager();
            if (transactionManager == null) {
                JtaLogging.JTA_LOGGER.debug("JtaPlatform.retrieveTransactionManager() returned null");
                return null;
            }
            return new JtaTransactionAdapterTransactionManagerImpl(transactionManager);
        }
        catch (Exception exception) {
            JtaLogging.JTA_LOGGER.debugf("JtaPlatform.retrieveTransactionManager() threw an exception [%s]", exception.getMessage());
            return null;
        }
    }

    @Override
    public SynchronizationRegistry getLocalSynchronizations() {
        return this.synchronizationRegistry;
    }

    @Override
    public boolean isActive() {
        return this.transactionCoordinatorOwner.isActive();
    }

    public boolean isJtaTransactionCurrentlyActive() {
        return this.getTransactionDriverControl().getStatus() == TransactionStatus.ACTIVE;
    }

    @Override
    public IsolationDelegate createIsolationDelegate() {
        return new JtaIsolationDelegate(this.transactionCoordinatorOwner, this.jtaPlatform.retrieveTransactionManager());
    }

    @Override
    public TransactionCoordinatorBuilder getTransactionCoordinatorBuilder() {
        return this.transactionCoordinatorBuilder;
    }

    @Override
    public void setTimeOut(int seconds) {
        this.timeOut = seconds;
        this.physicalTransactionDelegate.jtaTransactionAdapter.setTimeOut(seconds);
    }

    @Override
    public int getTimeOut() {
        return this.timeOut;
    }

    @Override
    public void invalidate() {
        if (this.physicalTransactionDelegate != null) {
            this.physicalTransactionDelegate.invalidate();
        }
        this.physicalTransactionDelegate = null;
    }

    @Override
    public void beforeCompletion() {
        JtaLogging.JTA_LOGGER.trace("Notifying JTA transaction observers before completion");
        try {
            this.transactionCoordinatorOwner.beforeTransactionCompletion();
        }
        catch (Exception e) {
            this.physicalTransactionDelegate.markRollbackOnly();
            throw e;
        }
        finally {
            this.synchronizationRegistry.notifySynchronizationsBeforeTransactionCompletion();
            for (TransactionObserver observer : this.observers()) {
                observer.beforeCompletion();
            }
        }
    }

    @Override
    public void afterCompletion(boolean successful, boolean delayed) {
        if (this.transactionCoordinatorOwner.isActive()) {
            JtaLogging.JTA_LOGGER.trace("Notifying JTA transaction observers after completion");
            int statusToSend = successful ? 3 : 5;
            this.synchronizationRegistry.notifySynchronizationsAfterTransactionCompletion(statusToSend);
            this.transactionCoordinatorOwner.afterTransactionCompletion(successful, delayed);
            for (TransactionObserver observer : this.observers()) {
                observer.afterCompletion(successful, delayed);
            }
            this.synchronizationRegistered = false;
        }
    }

    @Override
    public void addObserver(TransactionObserver observer) {
        if (this.observers == null) {
            this.observers = new ArrayList<TransactionObserver>(3);
        }
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(TransactionObserver observer) {
        if (this.observers != null) {
            this.observers.remove(observer);
        }
    }

    public class TransactionDriverControlImpl
    implements TransactionCoordinator.TransactionDriver {
        private final JtaTransactionAdapter jtaTransactionAdapter;
        private boolean invalid;

        public TransactionDriverControlImpl(JtaTransactionAdapter jtaTransactionAdapter) {
            this.jtaTransactionAdapter = jtaTransactionAdapter;
        }

        protected void invalidate() {
            this.invalid = true;
        }

        @Override
        public void begin() {
            this.errorIfInvalid();
            this.jtaTransactionAdapter.begin();
            JtaTransactionCoordinatorImpl.this.joinJtaTransaction();
        }

        protected void errorIfInvalid() {
            if (this.invalid) {
                throw new IllegalStateException("Physical-transaction delegate is no longer valid");
            }
        }

        @Override
        public void commit() {
            this.errorIfInvalid();
            JtaTransactionCoordinatorImpl.this.getTransactionCoordinatorOwner().flushBeforeTransactionCompletion();
            this.jtaTransactionAdapter.commit();
        }

        @Override
        public void rollback() {
            this.errorIfInvalid();
            this.jtaTransactionAdapter.rollback();
        }

        @Override
        public TransactionStatus getStatus() {
            return this.jtaTransactionAdapter.getStatus();
        }

        @Override
        public void markRollbackOnly() {
            if (this.jtaTransactionAdapter.getStatus() != TransactionStatus.NOT_ACTIVE) {
                this.jtaTransactionAdapter.markRollbackOnly();
            }
        }
    }
}

