/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.criteria.JpaCompoundSelection;
import org.hibernate.query.sqm.DynamicInstantiationNature;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.jpa.AbstractJpaSelection;
import org.hibernate.query.sqm.tree.select.SqmAliasedExpressionContainer;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.sql.results.graph.instantiation.internal.InstantiationHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class SqmDynamicInstantiation<T>
extends AbstractJpaSelection<T>
implements SqmSelectableNode<T>,
SqmAliasedExpressionContainer<SqmDynamicInstantiationArgument<?>>,
JpaCompoundSelection<T> {
    private static final Logger log = Logger.getLogger(SqmDynamicInstantiation.class);
    private final SqmDynamicInstantiationTarget<T> instantiationTarget;
    private List<SqmDynamicInstantiationArgument<?>> arguments;

    public static <R> SqmDynamicInstantiation<R> forClassInstantiation(JavaType<R> targetJavaType, NodeBuilder nodeBuilder) {
        return new SqmDynamicInstantiation<R>(new DynamicInstantiationTargetImpl<R>(DynamicInstantiationNature.CLASS, targetJavaType), nodeBuilder);
    }

    public static <R> SqmDynamicInstantiation<R> classInstantiation(Class<R> targetJavaType, List<? extends SqmSelectableNode<?>> arguments, NodeBuilder nodeBuilder) {
        return new SqmDynamicInstantiation(new DynamicInstantiationTargetImpl(DynamicInstantiationNature.CLASS, nodeBuilder.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(targetJavaType)), arguments, nodeBuilder);
    }

    public static <M extends Map<?, ?>> SqmDynamicInstantiation<M> forMapInstantiation(JavaType<M> mapJavaType, NodeBuilder nodeBuilder) {
        return new SqmDynamicInstantiation<M>(new DynamicInstantiationTargetImpl<M>(DynamicInstantiationNature.MAP, mapJavaType), nodeBuilder);
    }

    public static <M extends Map<?, ?>> SqmDynamicInstantiation<M> mapInstantiation(List<? extends SqmSelectableNode<?>> arguments, NodeBuilder nodeBuilder) {
        return new SqmDynamicInstantiation(new DynamicInstantiationTargetImpl(DynamicInstantiationNature.MAP, nodeBuilder.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)Map.class))), arguments, nodeBuilder);
    }

    public static <L extends List<?>> SqmDynamicInstantiation<L> forListInstantiation(JavaType<L> listJavaType, NodeBuilder nodeBuilder) {
        return new SqmDynamicInstantiation<L>(new DynamicInstantiationTargetImpl<L>(DynamicInstantiationNature.LIST, listJavaType), nodeBuilder);
    }

    public static <L extends List<?>> SqmDynamicInstantiation<L> listInstantiation(List<? extends SqmSelectableNode<?>> arguments, NodeBuilder nodeBuilder) {
        return new SqmDynamicInstantiation(new DynamicInstantiationTargetImpl(DynamicInstantiationNature.LIST, nodeBuilder.getTypeConfiguration().getJavaTypeRegistry().getDescriptor((Type)((Object)List.class))), arguments, nodeBuilder);
    }

    private SqmDynamicInstantiation(SqmDynamicInstantiationTarget<T> instantiationTarget, NodeBuilder nodeBuilder) {
        super(instantiationTarget.getSqmType(), nodeBuilder);
        this.instantiationTarget = instantiationTarget;
    }

    private SqmDynamicInstantiation(SqmDynamicInstantiationTarget<T> instantiationTarget, List<? extends SqmSelectableNode<?>> arguments, NodeBuilder nodeBuilder) {
        super(instantiationTarget.getSqmType(), nodeBuilder);
        this.instantiationTarget = instantiationTarget;
        for (SqmSelectableNode<?> argument : arguments) {
            SqmDynamicInstantiationArgument arg = new SqmDynamicInstantiationArgument(argument, argument.getAlias(), this.nodeBuilder());
            this.addArgument(arg);
        }
    }

    private SqmDynamicInstantiation(SqmBindableType<T> sqmExpressible, NodeBuilder criteriaBuilder, SqmDynamicInstantiationTarget<T> instantiationTarget, List<SqmDynamicInstantiationArgument<?>> arguments) {
        super(sqmExpressible, criteriaBuilder);
        this.instantiationTarget = instantiationTarget;
        this.arguments = arguments;
    }

    public boolean checkInstantiation(TypeConfiguration typeConfiguration) {
        if (this.getInstantiationTarget().getNature() == DynamicInstantiationNature.CLASS) {
            if (this.getJavaType().isArray()) {
                return true;
            }
            List<Class<?>> argTypes = this.argumentTypes();
            if (this.isFullyAliased()) {
                List<String> aliases = this.getArguments().stream().map(SqmDynamicInstantiationArgument::getAlias).collect(Collectors.toList());
                return InstantiationHelper.isInjectionCompatible(this.getJavaType(), aliases, argTypes) || InstantiationHelper.isConstructorCompatible(this.getJavaType(), argTypes, typeConfiguration);
            }
            return InstantiationHelper.isConstructorCompatible(this.getJavaType(), argTypes, typeConfiguration);
        }
        return true;
    }

    private List<Class<?>> argumentTypes() {
        return this.getArguments().stream().map(arg -> {
            SqmBindableType expressible = arg.getExpressible();
            return expressible != null && expressible.getExpressibleJavaType() != null ? expressible.getExpressibleJavaType().getJavaTypeClass() : Void.class;
        }).collect(Collectors.toList());
    }

    public boolean isFullyAliased() {
        return this.getArguments().stream().allMatch(arg -> arg.getAlias() != null);
    }

    @Override
    public SqmDynamicInstantiation<T> copy(SqmCopyContext context) {
        ArrayList arguments;
        SqmDynamicInstantiation existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        if (this.arguments == null) {
            arguments = null;
        } else {
            arguments = new ArrayList(this.arguments.size());
            for (SqmDynamicInstantiationArgument<?> argument : this.arguments) {
                arguments.add((SqmDynamicInstantiationArgument<?>)argument.copy(context));
            }
        }
        SqmDynamicInstantiation<T> instantiation = context.registerCopy(this, new SqmDynamicInstantiation<T>(this.getExpressible(), this.nodeBuilder(), this.instantiationTarget, arguments));
        this.copyTo(instantiation, context);
        return instantiation;
    }

    public SqmDynamicInstantiationTarget<T> getInstantiationTarget() {
        return this.instantiationTarget;
    }

    public List<SqmDynamicInstantiationArgument<?>> getArguments() {
        return this.arguments;
    }

    @Override
    public JavaType<T> getJavaTypeDescriptor() {
        return this.getInstantiationTarget().getTargetTypeDescriptor();
    }

    @Override
    public String asLoggableText() {
        return "<new " + this.instantiationTarget.getJavaType().getName() + ">";
    }

    public void addArgument(SqmDynamicInstantiationArgument<?> argument) {
        if (this.instantiationTarget.getNature() == DynamicInstantiationNature.LIST) {
            if (argument.getAlias() != null && log.isDebugEnabled()) {
                log.debugf("Argument [%s] for dynamic List instantiation declared an 'injection alias' [%s] but such aliases are ignored for dynamic List instantiations", (Object)argument.getSelectableNode().asLoggableText(), (Object)argument.getAlias());
            }
        } else if (this.instantiationTarget.getNature() == DynamicInstantiationNature.MAP && argument.getAlias() == null) {
            log.warnf("Argument [%s] for dynamic Map instantiation did not declare an 'injection alias' [%s] but such aliases are needed for dynamic Map instantiations; will likely cause problems later translating sqm", (Object)argument.getSelectableNode().asLoggableText(), (Object)argument.getAlias());
        }
        if (this.arguments == null) {
            this.arguments = new ArrayList();
        }
        this.arguments.add(argument);
    }

    @Override
    public SqmDynamicInstantiationArgument<?> add(SqmExpression<?> expression, String alias) {
        SqmDynamicInstantiationArgument argument = new SqmDynamicInstantiationArgument(expression, alias, this.nodeBuilder());
        this.addArgument(argument);
        return argument;
    }

    @Override
    public void add(SqmDynamicInstantiationArgument<?> aliasExpression) {
        this.addArgument(aliasExpression);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitDynamicInstantiation(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("new ");
        if (this.instantiationTarget.getNature() == DynamicInstantiationNature.LIST) {
            hql.append("list");
        } else if (this.instantiationTarget.getNature() == DynamicInstantiationNature.MAP) {
            hql.append("map");
        } else {
            hql.append(this.instantiationTarget.getTargetTypeDescriptor().getJavaTypeClass().getTypeName());
        }
        hql.append('(');
        this.arguments.get(0).appendHqlString(hql, context);
        for (int i = 1; i < this.arguments.size(); ++i) {
            hql.append(", ");
            this.arguments.get(i).appendHqlString(hql, context);
        }
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmDynamicInstantiation)) return false;
        SqmDynamicInstantiation that = (SqmDynamicInstantiation)object;
        if (!Objects.equals(this.instantiationTarget, that.instantiationTarget)) return false;
        if (!Objects.equals(this.arguments, that.arguments)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.instantiationTarget, this.arguments);
    }

    public SqmDynamicInstantiation<T> makeShallowCopy() {
        return new SqmDynamicInstantiation<T>(this.getInstantiationTarget(), this.nodeBuilder());
    }

    @Override
    public @Nullable JavaType<T> getNodeJavaType() {
        return this.instantiationTarget.getExpressibleJavaType();
    }

    @Override
    public void visitSubSelectableNodes(Consumer<SqmSelectableNode<?>> consumer) {
        for (SqmDynamicInstantiationArgument<?> argument : this.arguments) {
            consumer.accept(argument.getSelectableNode());
        }
    }

    @Override
    public List<SqmSelectableNode<?>> getSelectionItems() {
        ArrayList list = new ArrayList();
        this.visitSubSelectableNodes(list::add);
        return list;
    }

    private static class DynamicInstantiationTargetImpl<T>
    implements SqmDynamicInstantiationTarget<T> {
        private final DynamicInstantiationNature nature;
        private final JavaType<T> javaType;

        private DynamicInstantiationTargetImpl(DynamicInstantiationNature nature, JavaType<T> javaType) {
            this.nature = nature;
            this.javaType = javaType;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof DynamicInstantiationTargetImpl)) return false;
            DynamicInstantiationTargetImpl that = (DynamicInstantiationTargetImpl)object;
            if (this.nature != that.nature) return false;
            if (!Objects.equals(this.javaType, that.javaType)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.nature, this.javaType});
        }

        @Override
        public DynamicInstantiationNature getNature() {
            return this.nature;
        }

        @Override
        public JavaType<T> getTargetTypeDescriptor() {
            return this.javaType;
        }

        @Override
        public JavaType<T> getExpressibleJavaType() {
            return this.getTargetTypeDescriptor();
        }

        @Override
        public SqmDomainType<T> getSqmType() {
            return null;
        }
    }
}

