﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>
#include <aws/wellarchitected/model/Risk.h>
#include <aws/wellarchitected/model/WorkloadDiscoveryConfig.h>
#include <aws/wellarchitected/model/WorkloadEnvironment.h>
#include <aws/wellarchitected/model/WorkloadImprovementStatus.h>
#include <aws/wellarchitected/model/WorkloadJiraConfigurationOutput.h>
#include <aws/wellarchitected/model/WorkloadProfile.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace WellArchitected {
namespace Model {

/**
 * <p>A workload return object.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/Workload">AWS
 * API Reference</a></p>
 */
class Workload {
 public:
  AWS_WELLARCHITECTED_API Workload() = default;
  AWS_WELLARCHITECTED_API Workload(Aws::Utils::Json::JsonView jsonValue);
  AWS_WELLARCHITECTED_API Workload& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_WELLARCHITECTED_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{

  inline const Aws::String& GetWorkloadId() const { return m_workloadId; }
  inline bool WorkloadIdHasBeenSet() const { return m_workloadIdHasBeenSet; }
  template <typename WorkloadIdT = Aws::String>
  void SetWorkloadId(WorkloadIdT&& value) {
    m_workloadIdHasBeenSet = true;
    m_workloadId = std::forward<WorkloadIdT>(value);
  }
  template <typename WorkloadIdT = Aws::String>
  Workload& WithWorkloadId(WorkloadIdT&& value) {
    SetWorkloadId(std::forward<WorkloadIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetWorkloadArn() const { return m_workloadArn; }
  inline bool WorkloadArnHasBeenSet() const { return m_workloadArnHasBeenSet; }
  template <typename WorkloadArnT = Aws::String>
  void SetWorkloadArn(WorkloadArnT&& value) {
    m_workloadArnHasBeenSet = true;
    m_workloadArn = std::forward<WorkloadArnT>(value);
  }
  template <typename WorkloadArnT = Aws::String>
  Workload& WithWorkloadArn(WorkloadArnT&& value) {
    SetWorkloadArn(std::forward<WorkloadArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetWorkloadName() const { return m_workloadName; }
  inline bool WorkloadNameHasBeenSet() const { return m_workloadNameHasBeenSet; }
  template <typename WorkloadNameT = Aws::String>
  void SetWorkloadName(WorkloadNameT&& value) {
    m_workloadNameHasBeenSet = true;
    m_workloadName = std::forward<WorkloadNameT>(value);
  }
  template <typename WorkloadNameT = Aws::String>
  Workload& WithWorkloadName(WorkloadNameT&& value) {
    SetWorkloadName(std::forward<WorkloadNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetDescription() const { return m_description; }
  inline bool DescriptionHasBeenSet() const { return m_descriptionHasBeenSet; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  Workload& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline WorkloadEnvironment GetEnvironment() const { return m_environment; }
  inline bool EnvironmentHasBeenSet() const { return m_environmentHasBeenSet; }
  inline void SetEnvironment(WorkloadEnvironment value) {
    m_environmentHasBeenSet = true;
    m_environment = value;
  }
  inline Workload& WithEnvironment(WorkloadEnvironment value) {
    SetEnvironment(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Utils::DateTime& GetUpdatedAt() const { return m_updatedAt; }
  inline bool UpdatedAtHasBeenSet() const { return m_updatedAtHasBeenSet; }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  void SetUpdatedAt(UpdatedAtT&& value) {
    m_updatedAtHasBeenSet = true;
    m_updatedAt = std::forward<UpdatedAtT>(value);
  }
  template <typename UpdatedAtT = Aws::Utils::DateTime>
  Workload& WithUpdatedAt(UpdatedAtT&& value) {
    SetUpdatedAt(std::forward<UpdatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Vector<Aws::String>& GetAccountIds() const { return m_accountIds; }
  inline bool AccountIdsHasBeenSet() const { return m_accountIdsHasBeenSet; }
  template <typename AccountIdsT = Aws::Vector<Aws::String>>
  void SetAccountIds(AccountIdsT&& value) {
    m_accountIdsHasBeenSet = true;
    m_accountIds = std::forward<AccountIdsT>(value);
  }
  template <typename AccountIdsT = Aws::Vector<Aws::String>>
  Workload& WithAccountIds(AccountIdsT&& value) {
    SetAccountIds(std::forward<AccountIdsT>(value));
    return *this;
  }
  template <typename AccountIdsT = Aws::String>
  Workload& AddAccountIds(AccountIdsT&& value) {
    m_accountIdsHasBeenSet = true;
    m_accountIds.emplace_back(std::forward<AccountIdsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Vector<Aws::String>& GetAwsRegions() const { return m_awsRegions; }
  inline bool AwsRegionsHasBeenSet() const { return m_awsRegionsHasBeenSet; }
  template <typename AwsRegionsT = Aws::Vector<Aws::String>>
  void SetAwsRegions(AwsRegionsT&& value) {
    m_awsRegionsHasBeenSet = true;
    m_awsRegions = std::forward<AwsRegionsT>(value);
  }
  template <typename AwsRegionsT = Aws::Vector<Aws::String>>
  Workload& WithAwsRegions(AwsRegionsT&& value) {
    SetAwsRegions(std::forward<AwsRegionsT>(value));
    return *this;
  }
  template <typename AwsRegionsT = Aws::String>
  Workload& AddAwsRegions(AwsRegionsT&& value) {
    m_awsRegionsHasBeenSet = true;
    m_awsRegions.emplace_back(std::forward<AwsRegionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Vector<Aws::String>& GetNonAwsRegions() const { return m_nonAwsRegions; }
  inline bool NonAwsRegionsHasBeenSet() const { return m_nonAwsRegionsHasBeenSet; }
  template <typename NonAwsRegionsT = Aws::Vector<Aws::String>>
  void SetNonAwsRegions(NonAwsRegionsT&& value) {
    m_nonAwsRegionsHasBeenSet = true;
    m_nonAwsRegions = std::forward<NonAwsRegionsT>(value);
  }
  template <typename NonAwsRegionsT = Aws::Vector<Aws::String>>
  Workload& WithNonAwsRegions(NonAwsRegionsT&& value) {
    SetNonAwsRegions(std::forward<NonAwsRegionsT>(value));
    return *this;
  }
  template <typename NonAwsRegionsT = Aws::String>
  Workload& AddNonAwsRegions(NonAwsRegionsT&& value) {
    m_nonAwsRegionsHasBeenSet = true;
    m_nonAwsRegions.emplace_back(std::forward<NonAwsRegionsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetArchitecturalDesign() const { return m_architecturalDesign; }
  inline bool ArchitecturalDesignHasBeenSet() const { return m_architecturalDesignHasBeenSet; }
  template <typename ArchitecturalDesignT = Aws::String>
  void SetArchitecturalDesign(ArchitecturalDesignT&& value) {
    m_architecturalDesignHasBeenSet = true;
    m_architecturalDesign = std::forward<ArchitecturalDesignT>(value);
  }
  template <typename ArchitecturalDesignT = Aws::String>
  Workload& WithArchitecturalDesign(ArchitecturalDesignT&& value) {
    SetArchitecturalDesign(std::forward<ArchitecturalDesignT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetReviewOwner() const { return m_reviewOwner; }
  inline bool ReviewOwnerHasBeenSet() const { return m_reviewOwnerHasBeenSet; }
  template <typename ReviewOwnerT = Aws::String>
  void SetReviewOwner(ReviewOwnerT&& value) {
    m_reviewOwnerHasBeenSet = true;
    m_reviewOwner = std::forward<ReviewOwnerT>(value);
  }
  template <typename ReviewOwnerT = Aws::String>
  Workload& WithReviewOwner(ReviewOwnerT&& value) {
    SetReviewOwner(std::forward<ReviewOwnerT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Utils::DateTime& GetReviewRestrictionDate() const { return m_reviewRestrictionDate; }
  inline bool ReviewRestrictionDateHasBeenSet() const { return m_reviewRestrictionDateHasBeenSet; }
  template <typename ReviewRestrictionDateT = Aws::Utils::DateTime>
  void SetReviewRestrictionDate(ReviewRestrictionDateT&& value) {
    m_reviewRestrictionDateHasBeenSet = true;
    m_reviewRestrictionDate = std::forward<ReviewRestrictionDateT>(value);
  }
  template <typename ReviewRestrictionDateT = Aws::Utils::DateTime>
  Workload& WithReviewRestrictionDate(ReviewRestrictionDateT&& value) {
    SetReviewRestrictionDate(std::forward<ReviewRestrictionDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Flag indicating whether the workload owner has acknowledged that the
   * <i>Review owner</i> field is required.</p> <p>If a <b>Review owner</b> is not
   * added to the workload within 60 days of acknowledgement, access to the workload
   * is restricted until an owner is added.</p>
   */
  inline bool GetIsReviewOwnerUpdateAcknowledged() const { return m_isReviewOwnerUpdateAcknowledged; }
  inline bool IsReviewOwnerUpdateAcknowledgedHasBeenSet() const { return m_isReviewOwnerUpdateAcknowledgedHasBeenSet; }
  inline void SetIsReviewOwnerUpdateAcknowledged(bool value) {
    m_isReviewOwnerUpdateAcknowledgedHasBeenSet = true;
    m_isReviewOwnerUpdateAcknowledged = value;
  }
  inline Workload& WithIsReviewOwnerUpdateAcknowledged(bool value) {
    SetIsReviewOwnerUpdateAcknowledged(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetIndustryType() const { return m_industryType; }
  inline bool IndustryTypeHasBeenSet() const { return m_industryTypeHasBeenSet; }
  template <typename IndustryTypeT = Aws::String>
  void SetIndustryType(IndustryTypeT&& value) {
    m_industryTypeHasBeenSet = true;
    m_industryType = std::forward<IndustryTypeT>(value);
  }
  template <typename IndustryTypeT = Aws::String>
  Workload& WithIndustryType(IndustryTypeT&& value) {
    SetIndustryType(std::forward<IndustryTypeT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetIndustry() const { return m_industry; }
  inline bool IndustryHasBeenSet() const { return m_industryHasBeenSet; }
  template <typename IndustryT = Aws::String>
  void SetIndustry(IndustryT&& value) {
    m_industryHasBeenSet = true;
    m_industry = std::forward<IndustryT>(value);
  }
  template <typename IndustryT = Aws::String>
  Workload& WithIndustry(IndustryT&& value) {
    SetIndustry(std::forward<IndustryT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetNotes() const { return m_notes; }
  inline bool NotesHasBeenSet() const { return m_notesHasBeenSet; }
  template <typename NotesT = Aws::String>
  void SetNotes(NotesT&& value) {
    m_notesHasBeenSet = true;
    m_notes = std::forward<NotesT>(value);
  }
  template <typename NotesT = Aws::String>
  Workload& WithNotes(NotesT&& value) {
    SetNotes(std::forward<NotesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline WorkloadImprovementStatus GetImprovementStatus() const { return m_improvementStatus; }
  inline bool ImprovementStatusHasBeenSet() const { return m_improvementStatusHasBeenSet; }
  inline void SetImprovementStatus(WorkloadImprovementStatus value) {
    m_improvementStatusHasBeenSet = true;
    m_improvementStatus = value;
  }
  inline Workload& WithImprovementStatus(WorkloadImprovementStatus value) {
    SetImprovementStatus(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Map<Risk, int>& GetRiskCounts() const { return m_riskCounts; }
  inline bool RiskCountsHasBeenSet() const { return m_riskCountsHasBeenSet; }
  template <typename RiskCountsT = Aws::Map<Risk, int>>
  void SetRiskCounts(RiskCountsT&& value) {
    m_riskCountsHasBeenSet = true;
    m_riskCounts = std::forward<RiskCountsT>(value);
  }
  template <typename RiskCountsT = Aws::Map<Risk, int>>
  Workload& WithRiskCounts(RiskCountsT&& value) {
    SetRiskCounts(std::forward<RiskCountsT>(value));
    return *this;
  }
  inline Workload& AddRiskCounts(Risk key, int value) {
    m_riskCountsHasBeenSet = true;
    m_riskCounts.emplace(key, value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Vector<Aws::String>& GetPillarPriorities() const { return m_pillarPriorities; }
  inline bool PillarPrioritiesHasBeenSet() const { return m_pillarPrioritiesHasBeenSet; }
  template <typename PillarPrioritiesT = Aws::Vector<Aws::String>>
  void SetPillarPriorities(PillarPrioritiesT&& value) {
    m_pillarPrioritiesHasBeenSet = true;
    m_pillarPriorities = std::forward<PillarPrioritiesT>(value);
  }
  template <typename PillarPrioritiesT = Aws::Vector<Aws::String>>
  Workload& WithPillarPriorities(PillarPrioritiesT&& value) {
    SetPillarPriorities(std::forward<PillarPrioritiesT>(value));
    return *this;
  }
  template <typename PillarPrioritiesT = Aws::String>
  Workload& AddPillarPriorities(PillarPrioritiesT&& value) {
    m_pillarPrioritiesHasBeenSet = true;
    m_pillarPriorities.emplace_back(std::forward<PillarPrioritiesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Vector<Aws::String>& GetLenses() const { return m_lenses; }
  inline bool LensesHasBeenSet() const { return m_lensesHasBeenSet; }
  template <typename LensesT = Aws::Vector<Aws::String>>
  void SetLenses(LensesT&& value) {
    m_lensesHasBeenSet = true;
    m_lenses = std::forward<LensesT>(value);
  }
  template <typename LensesT = Aws::Vector<Aws::String>>
  Workload& WithLenses(LensesT&& value) {
    SetLenses(std::forward<LensesT>(value));
    return *this;
  }
  template <typename LensesT = Aws::String>
  Workload& AddLenses(LensesT&& value) {
    m_lensesHasBeenSet = true;
    m_lenses.emplace_back(std::forward<LensesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetOwner() const { return m_owner; }
  inline bool OwnerHasBeenSet() const { return m_ownerHasBeenSet; }
  template <typename OwnerT = Aws::String>
  void SetOwner(OwnerT&& value) {
    m_ownerHasBeenSet = true;
    m_owner = std::forward<OwnerT>(value);
  }
  template <typename OwnerT = Aws::String>
  Workload& WithOwner(OwnerT&& value) {
    SetOwner(std::forward<OwnerT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID assigned to the share invitation.</p>
   */
  inline const Aws::String& GetShareInvitationId() const { return m_shareInvitationId; }
  inline bool ShareInvitationIdHasBeenSet() const { return m_shareInvitationIdHasBeenSet; }
  template <typename ShareInvitationIdT = Aws::String>
  void SetShareInvitationId(ShareInvitationIdT&& value) {
    m_shareInvitationIdHasBeenSet = true;
    m_shareInvitationId = std::forward<ShareInvitationIdT>(value);
  }
  template <typename ShareInvitationIdT = Aws::String>
  Workload& WithShareInvitationId(ShareInvitationIdT&& value) {
    SetShareInvitationId(std::forward<ShareInvitationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tags associated with the workload.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  inline bool TagsHasBeenSet() const { return m_tagsHasBeenSet; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  Workload& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  Workload& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Discovery configuration associated to the workload.</p>
   */
  inline const WorkloadDiscoveryConfig& GetDiscoveryConfig() const { return m_discoveryConfig; }
  inline bool DiscoveryConfigHasBeenSet() const { return m_discoveryConfigHasBeenSet; }
  template <typename DiscoveryConfigT = WorkloadDiscoveryConfig>
  void SetDiscoveryConfig(DiscoveryConfigT&& value) {
    m_discoveryConfigHasBeenSet = true;
    m_discoveryConfig = std::forward<DiscoveryConfigT>(value);
  }
  template <typename DiscoveryConfigT = WorkloadDiscoveryConfig>
  Workload& WithDiscoveryConfig(DiscoveryConfigT&& value) {
    SetDiscoveryConfig(std::forward<DiscoveryConfigT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>List of AppRegistry application ARNs associated to the workload.</p>
   */
  inline const Aws::Vector<Aws::String>& GetApplications() const { return m_applications; }
  inline bool ApplicationsHasBeenSet() const { return m_applicationsHasBeenSet; }
  template <typename ApplicationsT = Aws::Vector<Aws::String>>
  void SetApplications(ApplicationsT&& value) {
    m_applicationsHasBeenSet = true;
    m_applications = std::forward<ApplicationsT>(value);
  }
  template <typename ApplicationsT = Aws::Vector<Aws::String>>
  Workload& WithApplications(ApplicationsT&& value) {
    SetApplications(std::forward<ApplicationsT>(value));
    return *this;
  }
  template <typename ApplicationsT = Aws::String>
  Workload& AddApplications(ApplicationsT&& value) {
    m_applicationsHasBeenSet = true;
    m_applications.emplace_back(std::forward<ApplicationsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Profile associated with a workload.</p>
   */
  inline const Aws::Vector<WorkloadProfile>& GetProfiles() const { return m_profiles; }
  inline bool ProfilesHasBeenSet() const { return m_profilesHasBeenSet; }
  template <typename ProfilesT = Aws::Vector<WorkloadProfile>>
  void SetProfiles(ProfilesT&& value) {
    m_profilesHasBeenSet = true;
    m_profiles = std::forward<ProfilesT>(value);
  }
  template <typename ProfilesT = Aws::Vector<WorkloadProfile>>
  Workload& WithProfiles(ProfilesT&& value) {
    SetProfiles(std::forward<ProfilesT>(value));
    return *this;
  }
  template <typename ProfilesT = WorkloadProfile>
  Workload& AddProfiles(ProfilesT&& value) {
    m_profilesHasBeenSet = true;
    m_profiles.emplace_back(std::forward<ProfilesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::Map<Risk, int>& GetPrioritizedRiskCounts() const { return m_prioritizedRiskCounts; }
  inline bool PrioritizedRiskCountsHasBeenSet() const { return m_prioritizedRiskCountsHasBeenSet; }
  template <typename PrioritizedRiskCountsT = Aws::Map<Risk, int>>
  void SetPrioritizedRiskCounts(PrioritizedRiskCountsT&& value) {
    m_prioritizedRiskCountsHasBeenSet = true;
    m_prioritizedRiskCounts = std::forward<PrioritizedRiskCountsT>(value);
  }
  template <typename PrioritizedRiskCountsT = Aws::Map<Risk, int>>
  Workload& WithPrioritizedRiskCounts(PrioritizedRiskCountsT&& value) {
    SetPrioritizedRiskCounts(std::forward<PrioritizedRiskCountsT>(value));
    return *this;
  }
  inline Workload& AddPrioritizedRiskCounts(Risk key, int value) {
    m_prioritizedRiskCountsHasBeenSet = true;
    m_prioritizedRiskCounts.emplace(key, value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Jira configuration for a specific workload.</p>
   */
  inline const WorkloadJiraConfigurationOutput& GetJiraConfiguration() const { return m_jiraConfiguration; }
  inline bool JiraConfigurationHasBeenSet() const { return m_jiraConfigurationHasBeenSet; }
  template <typename JiraConfigurationT = WorkloadJiraConfigurationOutput>
  void SetJiraConfiguration(JiraConfigurationT&& value) {
    m_jiraConfigurationHasBeenSet = true;
    m_jiraConfiguration = std::forward<JiraConfigurationT>(value);
  }
  template <typename JiraConfigurationT = WorkloadJiraConfigurationOutput>
  Workload& WithJiraConfiguration(JiraConfigurationT&& value) {
    SetJiraConfiguration(std::forward<JiraConfigurationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_workloadId;
  bool m_workloadIdHasBeenSet = false;

  Aws::String m_workloadArn;
  bool m_workloadArnHasBeenSet = false;

  Aws::String m_workloadName;
  bool m_workloadNameHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  WorkloadEnvironment m_environment{WorkloadEnvironment::NOT_SET};
  bool m_environmentHasBeenSet = false;

  Aws::Utils::DateTime m_updatedAt{};
  bool m_updatedAtHasBeenSet = false;

  Aws::Vector<Aws::String> m_accountIds;
  bool m_accountIdsHasBeenSet = false;

  Aws::Vector<Aws::String> m_awsRegions;
  bool m_awsRegionsHasBeenSet = false;

  Aws::Vector<Aws::String> m_nonAwsRegions;
  bool m_nonAwsRegionsHasBeenSet = false;

  Aws::String m_architecturalDesign;
  bool m_architecturalDesignHasBeenSet = false;

  Aws::String m_reviewOwner;
  bool m_reviewOwnerHasBeenSet = false;

  Aws::Utils::DateTime m_reviewRestrictionDate{};
  bool m_reviewRestrictionDateHasBeenSet = false;

  bool m_isReviewOwnerUpdateAcknowledged{false};
  bool m_isReviewOwnerUpdateAcknowledgedHasBeenSet = false;

  Aws::String m_industryType;
  bool m_industryTypeHasBeenSet = false;

  Aws::String m_industry;
  bool m_industryHasBeenSet = false;

  Aws::String m_notes;
  bool m_notesHasBeenSet = false;

  WorkloadImprovementStatus m_improvementStatus{WorkloadImprovementStatus::NOT_SET};
  bool m_improvementStatusHasBeenSet = false;

  Aws::Map<Risk, int> m_riskCounts;
  bool m_riskCountsHasBeenSet = false;

  Aws::Vector<Aws::String> m_pillarPriorities;
  bool m_pillarPrioritiesHasBeenSet = false;

  Aws::Vector<Aws::String> m_lenses;
  bool m_lensesHasBeenSet = false;

  Aws::String m_owner;
  bool m_ownerHasBeenSet = false;

  Aws::String m_shareInvitationId;
  bool m_shareInvitationIdHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_tags;
  bool m_tagsHasBeenSet = false;

  WorkloadDiscoveryConfig m_discoveryConfig;
  bool m_discoveryConfigHasBeenSet = false;

  Aws::Vector<Aws::String> m_applications;
  bool m_applicationsHasBeenSet = false;

  Aws::Vector<WorkloadProfile> m_profiles;
  bool m_profilesHasBeenSet = false;

  Aws::Map<Risk, int> m_prioritizedRiskCounts;
  bool m_prioritizedRiskCountsHasBeenSet = false;

  WorkloadJiraConfigurationOutput m_jiraConfiguration;
  bool m_jiraConfigurationHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
