/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.sort;

import java.text.Collator;
import java.util.Comparator;
import javax.swing.DefaultRowSorter;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.sort.DefaultSortController;

public class TableSortController<M extends TableModel>
extends DefaultSortController<M> {
    private M tableModel;

    public TableSortController() {
        this(null);
    }

    public TableSortController(M model) {
        this.setModel(model);
    }

    public void setModel(M model) {
        this.tableModel = model;
        if (model != null) {
            this.cachedModelRowCount = model.getRowCount();
        }
        this.setModelWrapper(new TableRowSorterModelWrapper());
    }

    @Override
    public Comparator<?> getComparator(int column2) {
        Comparator<?> comparator = super.getComparator(column2);
        if (comparator != null) {
            return comparator;
        }
        Class<?> columnClass = ((TableModel)this.getModel()).getColumnClass(column2);
        if (columnClass == String.class) {
            return Collator.getInstance();
        }
        if (Comparable.class.isAssignableFrom(columnClass)) {
            return COMPARABLE_COMPARATOR;
        }
        return Collator.getInstance();
    }

    @Override
    protected boolean useToString(int column2) {
        Comparator<?> comparator = super.getComparator(column2);
        if (comparator != null) {
            return false;
        }
        Class<?> columnClass = ((TableModel)this.getModel()).getColumnClass(column2);
        if (columnClass == String.class) {
            return false;
        }
        return !Comparable.class.isAssignableFrom(columnClass);
    }

    private class TableRowSorterModelWrapper
    extends DefaultRowSorter.ModelWrapper<M, Integer> {
        private TableRowSorterModelWrapper() {
        }

        @Override
        public M getModel() {
            return TableSortController.this.tableModel;
        }

        @Override
        public int getColumnCount() {
            return TableSortController.this.tableModel == null ? 0 : TableSortController.this.tableModel.getColumnCount();
        }

        @Override
        public int getRowCount() {
            return TableSortController.this.tableModel == null ? 0 : TableSortController.this.tableModel.getRowCount();
        }

        @Override
        public Object getValueAt(int row, int column2) {
            return TableSortController.this.tableModel.getValueAt(row, column2);
        }

        @Override
        public String getStringValueAt(int row, int column2) {
            return TableSortController.this.getStringValueProvider().getStringValue(row, column2).getString(this.getValueAt(row, column2));
        }

        @Override
        public Integer getIdentifier(int index) {
            return index;
        }
    }
}

