/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGridNotifications;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.dump.DumpInfo;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.util.Out;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ExtractionHelper {
    @NotNull
    public Out createOut(@Nullable String var1, @NotNull DataExtractor var2) throws IOException;

    public boolean isSingleFileMode();

    public void sourceDumped(@NotNull DataExtractor var1, @NotNull Out var2);

    public void onFinished(@NotNull BiConsumer<Project, DumpInfo> var1);

    public void after(@NotNull Project var1, @NotNull DumpInfo var2) throws IOException;

    @NlsContexts.ProgressTitle
    @NotNull
    public String getTitle(@NotNull String var1);

    public static void errorNotification(@NotNull Project project, @NotNull DumpInfo info) {
        String summary;
        if (project == null) {
            ExtractionHelper.$$$reportNull$$$0(0);
        }
        if (info == null) {
            ExtractionHelper.$$$reportNull$$$0(1);
        }
        if ((summary = info.getErrorSummary()).isEmpty()) {
            return;
        }
        DataGridNotifications.EXTRACTORS_GROUP.createNotification(summary, NotificationType.ERROR).setDisplayId("ExtractionHelper.error").notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dump/ExtractionHelper";
        objectArray[2] = "errorNotification";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TextExtractionHelper
    extends MemoryExtractionHelper {
        private final Ref<String> myRef = new Ref();

        @Override
        protected void dumpData(@NotNull DataExtractor extractor, @NotNull String data) {
            if (extractor == null) {
                TextExtractionHelper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                TextExtractionHelper.$$$reportNull$$$0(1);
            }
            this.myRef.set((Object)data);
        }

        @Nullable
        public String getDumpedResult() {
            return (String)this.myRef.get();
        }

        @Override
        @NotNull
        public String getTitle(@NotNull String displayName) {
            if (displayName == null) {
                TextExtractionHelper.$$$reportNull$$$0(2);
            }
            String string = DataGridBundle.message((String)"export.copy.to.text", (Object[])new Object[]{displayName});
            if (string == null) {
                TextExtractionHelper.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/ExtractionHelper$TextExtractionHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/ExtractionHelper$TextExtractionHelper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "dumpData";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getTitle";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class ClipboardExtractionHelper
    extends MemoryExtractionHelper {
        @Override
        protected void dumpData(@NotNull DataExtractor extractor, @NotNull String data) {
            boolean htmlNeeded;
            if (extractor == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(0);
            }
            if (data == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(1);
            }
            Object content = (htmlNeeded = extractor.getFileExtension().contains("htm")) ? new TextTransferable(data) : new StringSelection(data);
            UIUtil.invokeLaterIfNeeded(() -> ClipboardExtractionHelper.lambda$dumpData$0((Transferable)content));
        }

        @Override
        @NotNull
        public String getTitle(@NotNull String displayName) {
            if (displayName == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(2);
            }
            String string = DataGridBundle.message((String)"export.copy.to.clipboard", (Object[])new Object[]{displayName});
            if (string == null) {
                ClipboardExtractionHelper.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void lambda$dumpData$0(Transferable content) {
            CopyPasteManager.getInstance().setContents(content);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/ExtractionHelper$ClipboardExtractionHelper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "dumpData";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getTitle";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class MemoryExtractionHelper
    extends ExtractionHelperBase {
        @Override
        @NotNull
        public Out createOut(@Nullable String name, @NotNull DataExtractor extractor) {
            if (extractor == null) {
                MemoryExtractionHelper.$$$reportNull$$$0(0);
            }
            return new Out.Readable();
        }

        @Override
        public boolean isSingleFileMode() {
            return false;
        }

        @Override
        public void sourceDumped(@NotNull DataExtractor extractor, @NotNull Out out) {
            if (extractor == null) {
                MemoryExtractionHelper.$$$reportNull$$$0(1);
            }
            if (out == null) {
                MemoryExtractionHelper.$$$reportNull$$$0(2);
            }
            if (!(out instanceof Out.Readable)) {
                return;
            }
            Out.Readable readableOut = (Out.Readable)out;
            String data = readableOut.getString();
            this.dumpData(extractor, data);
        }

        protected abstract void dumpData(@NotNull DataExtractor var1, @NotNull String var2);

        @Override
        public void after(@NotNull Project project, @NotNull DumpInfo info) throws IOException {
            if (project == null) {
                MemoryExtractionHelper.$$$reportNull$$$0(3);
            }
            if (info == null) {
                MemoryExtractionHelper.$$$reportNull$$$0(4);
            }
            super.after(project, info);
            ExtractionHelper.errorNotification(project, info);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dump/ExtractionHelper$MemoryExtractionHelper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createOut";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sourceDumped";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class FileExtractionHelper
    extends ExtractionHelperBase {
        private final File myFile;

        public FileExtractionHelper(@NotNull File file) {
            if (file == null) {
                FileExtractionHelper.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        @Override
        @NotNull
        public Out createOut(@Nullable String name, @NotNull DataExtractor extractor) throws IOException {
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(1);
            }
            File fileToWrite = this.createFileToWrite(name, extractor);
            FileOutputStream outputStream = new FileOutputStream(fileToWrite);
            return new Out.FromStream((OutputStream)new BufferedOutputStream(outputStream));
        }

        private File createFileToWrite(@Nullable String name, @NotNull DataExtractor extractor) {
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(2);
            }
            if (this.myFile.isFile()) {
                return this.myFile;
            }
            return this.findFile(name, extractor);
        }

        private File findFile(@Nullable String name, @NotNull DataExtractor extractor) {
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(3);
            }
            name = name != null ? name : "out";
            File result = this.createFile(name, extractor, null);
            int index = 1;
            while (result.exists()) {
                result = this.createFile(name, extractor, index++);
            }
            return result;
        }

        private File createFile(@NotNull String name, @NotNull DataExtractor extractor, @Nullable Integer index) {
            if (name == null) {
                FileExtractionHelper.$$$reportNull$$$0(4);
            }
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(5);
            }
            return new File(this.myFile, GridExtractorsUtilCore.prepareFileName((String)name) + (String)(index == null ? "" : "_" + index) + "." + extractor.getFileExtension());
        }

        @Override
        public boolean isSingleFileMode() {
            return this.myFile.isFile();
        }

        @Override
        public void sourceDumped(@NotNull DataExtractor extractor, @NotNull Out out) {
            if (extractor == null) {
                FileExtractionHelper.$$$reportNull$$$0(6);
            }
            if (out == null) {
                FileExtractionHelper.$$$reportNull$$$0(7);
            }
        }

        @Override
        public void after(@NotNull Project project, @NotNull DumpInfo info) throws IOException {
            if (project == null) {
                FileExtractionHelper.$$$reportNull$$$0(8);
            }
            if (info == null) {
                FileExtractionHelper.$$$reportNull$$$0(9);
            }
            super.after(project, info);
            this.notification(project, info);
            ExtractionHelper.errorNotification(project, info);
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(this.myFile);
            if (virtualFile != null) {
                VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{virtualFile});
            }
        }

        private void notification(@NotNull Project project, @NotNull DumpInfo info) {
            if (project == null) {
                FileExtractionHelper.$$$reportNull$$$0(10);
            }
            if (info == null) {
                FileExtractionHelper.$$$reportNull$$$0(11);
            }
            String title = info.getTitle();
            long rowCount = info.getRowCount();
            String producerName = info.getProducerName();
            String sourceName = info.getSourceName();
            int sourcesCount = info.getSourcesCount();
            boolean needSources = sourceName != null && sourcesCount > 1;
            String content = DataGridBundle.message((String)"export.rows.saved.to.file.message", (Object[])new Object[]{needSources ? 1 : 0, sourcesCount, sourceName, rowCount, producerName != null ? 1 : 0, producerName, this.myFile.isFile() ? 1 : 0});
            @NotNull NotificationType type = !info.getErrorSummary().isEmpty() ? NotificationType.ERROR : NotificationType.INFORMATION;
            @NotNull String path = this.myFile.getPath();
            DataGridNotifications.EXTRACTORS_GROUP.createNotification(title, GridUtil.getContent(content, path), type).setDisplayId("FileExtractionHelper.finished").setListener((NotificationListener)new GridUtil.FileNotificationListener(project, path)).addAction((AnAction)new GridUtil.GridRevealFileAction(path)).notify(project);
        }

        @Override
        @NotNull
        public String getTitle(@NotNull String displayName) {
            if (displayName == null) {
                FileExtractionHelper.$$$reportNull$$$0(12);
            }
            String string = DataGridBundle.message((String)"export.save.to.file", (Object[])new Object[]{displayName});
            if (string == null) {
                FileExtractionHelper.$$$reportNull$$$0(13);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 13 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extractor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dump/ExtractionHelper$FileExtractionHelper";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createOut";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createFileToWrite";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findFile";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createFile";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "sourceDumped";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "after";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "notification";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getTitle";
                    break;
                }
                case 13: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 13 -> new IllegalStateException(string);
            };
        }
    }

    public static abstract class ExtractionHelperBase
    implements ExtractionHelper {
        private BiConsumer<Project, DumpInfo> myOnFinished = null;

        @Override
        public final void onFinished(@NotNull BiConsumer<Project, DumpInfo> consumer) {
            if (consumer == null) {
                ExtractionHelperBase.$$$reportNull$$$0(0);
            }
            this.myOnFinished = consumer;
        }

        @Override
        public void after(@NotNull Project project, @NotNull DumpInfo info) throws IOException {
            if (project == null) {
                ExtractionHelperBase.$$$reportNull$$$0(1);
            }
            if (info == null) {
                ExtractionHelperBase.$$$reportNull$$$0(2);
            }
            if (this.myOnFinished != null) {
                this.myOnFinished.accept(project, info);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dump/ExtractionHelper$ExtractionHelperBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onFinished";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

