/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfigurable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/svn/GeneralSvnConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "commandLineClient", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "configurationDirectoryText", "useCustomConfigurationDirectory", "Lcom/intellij/ui/components/JBCheckBox;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "apply", "", "isModified", "", "reset", "dispose", "intellij.vcs.svn"})
public final class GeneralSvnConfigurable
extends BoundSearchableConfigurable
implements Configurable.NoScroll,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final TextFieldWithBrowseButton commandLineClient;
    @NotNull
    private final TextFieldWithBrowseButton configurationDirectoryText;
    private JBCheckBox useCustomConfigurationDirectory;

    public GeneralSvnConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = SvnConfigurable.getGroupDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroupDisplayName(...)");
        super(string, "project.propSubversion", "vcs.Subversion");
        this.project = project;
        this.commandLineClient = new TextFieldWithBrowseButton(null, (Disposable)this);
        this.configurationDirectoryText = new TextFieldWithBrowseButton(null, (Disposable)this);
        this.commandLineClient.addBrowseFolderListener(this.project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(SvnBundle.message("dialog.title.select.path.to.subversion.executable", new Object[0])).withDescription(SvnBundle.message("label.select.path.to.subversion.executable", new Object[0])));
    }

    @NotNull
    public DialogPanel createPanel() {
        DialogPanel dialogPanel;
        SvnConfiguration settings = SvnConfiguration.getInstance(this.project);
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = BuilderKt.panel(arg_0 -> GeneralSvnConfigurable.createPanel$lambda$0(this, settings, result, arg_0));
        this.configurationDirectoryText.addActionListener(arg_0 -> GeneralSvnConfigurable.createPanel$lambda$1(this, result, arg_0));
        if (result.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            dialogPanel = null;
        } else {
            dialogPanel = (DialogPanel)result.element;
        }
        return dialogPanel;
    }

    public void apply() {
        SvnConfiguration settings = SvnConfiguration.getInstance(this.project);
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        String oldCommandLinePath = applicationSettings17.getCommandLinePath();
        super.apply();
        JBCheckBox jBCheckBox = this.useCustomConfigurationDirectory;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomConfigurationDirectory");
            jBCheckBox = null;
        }
        settings.setConfigurationDirParameters(!jBCheckBox.isSelected(), this.configurationDirectoryText.getText());
        SvnVcs vcs17 = SvnVcs.getInstance(this.project);
        boolean isClientValid = vcs17.checkCommandLineVersion();
        if (!this.project.isDefault() && isClientValid && !Intrinsics.areEqual((Object)oldCommandLinePath, (Object)applicationSettings17.getCommandLinePath())) {
            vcs17.invokeRefreshSvnRoots();
            VcsDirtyScopeManager.getInstance((Project)this.project).markEverythingDirty();
        }
    }

    public boolean isModified() {
        block5: {
            block4: {
                SvnConfiguration settings = SvnConfiguration.getInstance(this.project);
                boolean bl = settings.isUseDefaultConfiguration();
                JBCheckBox jBCheckBox = this.useCustomConfigurationDirectory;
                if (jBCheckBox == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomConfigurationDirectory");
                    jBCheckBox = null;
                }
                if (bl == jBCheckBox.isSelected()) break block4;
                String string = settings.getConfigurationDirectory();
                String string2 = this.configurationDirectoryText.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (Intrinsics.areEqual((Object)string, (Object)((Object)StringsKt.trim((CharSequence)string2)).toString())) break block5;
            }
            return true;
        }
        return super.isModified();
    }

    public void reset() {
        super.reset();
        SvnConfiguration settings = SvnConfiguration.getInstance(this.project);
        String path = settings.getConfigurationDirectory();
        if (settings.isUseDefaultConfiguration() || path == null) {
            path = SvnUtil.USER_CONFIGURATION_PATH.getValue().toString();
        }
        this.configurationDirectoryText.setText(path);
        JBCheckBox jBCheckBox = this.useCustomConfigurationDirectory;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomConfigurationDirectory");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(!settings.isUseDefaultConfiguration());
    }

    public void dispose() {
    }

    private static final Unit createPanel$lambda$0(GeneralSvnConfigurable this$0, SvnConfiguration $settings, Ref.ObjectRef $result, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        String string = SvnBundle.message("label.path.to.svn.executable", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> GeneralSvnConfigurable.createPanel$lambda$0$0(this$0, arg_0));
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GeneralSvnConfigurable.createPanel$lambda$0$1($settings, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GeneralSvnConfigurable.createPanel$lambda$0$2(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GeneralSvnConfigurable.createPanel$lambda$0$3(this$0, $result, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(GeneralSvnConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        $this$row.cell((JComponent)this$0.commandLineClient).align((Align)AlignX.FILL.INSTANCE).onReset(() -> GeneralSvnConfigurable.createPanel$lambda$0$0$0(this$0, applicationSettings17)).onApply(() -> GeneralSvnConfigurable.createPanel$lambda$0$0$1(applicationSettings17, this$0)).onIsModified(() -> GeneralSvnConfigurable.createPanel$lambda$0$0$2(applicationSettings17, this$0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$0(GeneralSvnConfigurable this$0, SvnApplicationSettings $applicationSettings17) {
        this$0.commandLineClient.setText($applicationSettings17.getCommandLinePath());
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0$1(SvnApplicationSettings $applicationSettings17, GeneralSvnConfigurable this$0) {
        String string = this$0.commandLineClient.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        $applicationSettings17.setCommandLinePath(((Object)StringsKt.trim((CharSequence)string)).toString());
        return Unit.INSTANCE;
    }

    private static final boolean createPanel$lambda$0$0$2(SvnApplicationSettings $applicationSettings17, GeneralSvnConfigurable this$0) {
        String string = $applicationSettings17.getCommandLinePath();
        String string2 = this$0.commandLineClient.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return !Intrinsics.areEqual((Object)string, (Object)((Object)StringsKt.trim((CharSequence)string2)).toString());
    }

    private static final Unit createPanel$lambda$0$1(SvnConfiguration $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SvnBundle.message("command.line.interactive.mode.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell = Cell.comment$default((Cell)$this$row.checkBox(string), (String)SvnBundle.message("command.line.interactive.mode.description", new Object[0]), (int)0, null, (int)6, null);
        Intrinsics.checkNotNull((Object)$settings);
        ButtonKt.bindSelected((Cell)cell, (Function0)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((SvnConfiguration)this.receiver).isRunUnderTerminal();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((SvnConfiguration)this.receiver).setRunUnderTerminal(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(GeneralSvnConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SvnBundle.message("settings.use.custom.directory", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this$0.useCustomConfigurationDirectory = (JBCheckBox)$this$row.checkBox(string).onChanged(arg_0 -> GeneralSvnConfigurable.createPanel$lambda$0$2$0(this$0, arg_0)).gap(RightGap.SMALL).getComponent();
        Cell cell = $this$row.cell((JComponent)this$0.configurationDirectoryText).align((Align)AlignX.FILL.INSTANCE);
        JBCheckBox jBCheckBox = this$0.useCustomConfigurationDirectory;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomConfigurationDirectory");
            jBCheckBox = null;
        }
        cell.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBCheckBox)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2$0(GeneralSvnConfigurable this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SvnConfiguration configuration = SvnConfiguration.getInstance(this$0.project);
        String path = configuration.getConfigurationDirectory();
        JBCheckBox jBCheckBox = this$0.useCustomConfigurationDirectory;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"useCustomConfigurationDirectory");
            jBCheckBox = null;
        }
        if (!jBCheckBox.isSelected() || path == null) {
            this$0.configurationDirectoryText.setText(SvnUtil.USER_CONFIGURATION_PATH.getValue().toString());
        } else {
            this$0.configurationDirectoryText.setText(path);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(GeneralSvnConfigurable this$0, Ref.ObjectRef $result, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = SvnBundle.message("button.text.clear.authentication.cache", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.commentRight$default((Cell)$this$row.button(string, arg_0 -> GeneralSvnConfigurable.createPanel$lambda$0$3$0(this$0, $result, arg_0)), (String)SvnBundle.message("label.text.delete.stored.credentials", new Object[0]), null, (int)2, null).align((Align)AlignY.BOTTOM.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3$0(GeneralSvnConfigurable this$0, Ref.ObjectRef $result, ActionEvent it) {
        DialogPanel dialogPanel;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Project project = this$0.project;
        if ($result.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            dialogPanel = null;
        } else {
            dialogPanel = (DialogPanel)$result.element;
        }
        SvnAuthenticationNotifier.Companion.clearAuthenticationCache(project, (Component)dialogPanel, this$0.configurationDirectoryText.getText());
        return Unit.INSTANCE;
    }

    private static final void createPanel$lambda$1(GeneralSvnConfigurable this$0, Ref.ObjectRef $result, ActionEvent actionEvent) {
        DialogPanel dialogPanel;
        String string = this$0.configurationDirectoryText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String path = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Consumer consumer = arg_0 -> GeneralSvnConfigurable.createPanel$lambda$1$0(this$0, arg_0);
        Project project = this$0.project;
        if ($result.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"result");
            dialogPanel = null;
        } else {
            dialogPanel = (DialogPanel)$result.element;
        }
        SvnConfigurable.selectConfigurationDirectory(path, (Consumer<? super String>)consumer, project, (Component)dialogPanel);
    }

    private static final void createPanel$lambda$1$0(GeneralSvnConfigurable this$0, String s) {
        this$0.configurationDirectoryText.setText(s);
    }
}

