/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.documentation.DocumentationMarkup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonCodeStyleService;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.decorator.PyFunctoolsWrapsDecoratedFunctionTypeProvider;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.documentation.PyStructuredDocstringFormatter;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.documentation.PythonDocumentationQuickInfoProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWhileStatement;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.QualifiedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.toolbox.Maybe;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDocumentationBuilder {
    private final PsiElement myElement;
    private final PsiElement myOriginalElement;
    private final HtmlBuilder myProlog;
    private final HtmlBuilder myBody;
    private final HtmlBuilder myContent;
    private final HtmlBuilder mySections;
    private final List<FormatterDocFragment> myFormatterFragments;
    private final Map<String, HtmlBuilder> mySectionsMap;
    private final TypeEvalContext myContext;
    private static final Pattern ourSpacesPattern = Pattern.compile("^\\s+");

    public PyDocumentationBuilder(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        if (element == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(0);
        }
        this.mySectionsMap = FactoryMap.createMap(item -> new HtmlBuilder(), LinkedHashMap::new);
        this.myElement = element;
        this.myOriginalElement = originalElement;
        this.myProlog = new HtmlBuilder();
        this.myBody = new HtmlBuilder();
        this.myContent = new HtmlBuilder();
        this.mySections = new HtmlBuilder();
        this.myFormatterFragments = new ArrayList<FormatterDocFragment>();
        this.myContext = TypeEvalContext.userInitiated((Project)this.myElement.getProject(), (PsiFile)this.myElement.getContainingFile());
    }

    @Nullable
    @Nls
    public String build() {
        PsiElement outerElement = this.myOriginalElement != null ? this.myOriginalElement.getParent() : null;
        PsiElement elementDefinition = this.resolveToDocStringOwner();
        PsiElement propertyDefinition = this.buildFromProperty(elementDefinition, outerElement);
        boolean isProperty = false;
        if (propertyDefinition != null) {
            isProperty = true;
            elementDefinition = propertyDefinition;
        }
        if (elementDefinition instanceof PyDocStringOwner) {
            this.buildFromDocstring((PyDocStringOwner)elementDefinition, isProperty);
        } else if (elementDefinition instanceof PyNamedParameter) {
            this.buildFromParameter((PyNamedParameter)elementDefinition);
        } else if (elementDefinition instanceof PyTypeParameter) {
            PyTypeParameter typeParameter = (PyTypeParameter)elementDefinition;
            this.buildFromTypeParameter(typeParameter);
        } else if (elementDefinition instanceof PyTypeAliasStatement) {
            PyTypeAliasStatement typeAliasStatement = (PyTypeAliasStatement)elementDefinition;
            this.buildFromTypeAliasStatement(typeAliasStatement);
        }
        ASTNode node = elementDefinition.getNode();
        if (node != null) {
            IElementType elementType = node.getElementType();
            if (PythonDialectsTokenSetProvider.getInstance().getKeywordTokens().contains(elementType)) {
                this.buildForKeyword(PyDocumentationBuilder.getDocFileNameForKeywordElement(elementDefinition, elementType));
            }
        }
        if (!this.mySectionsMap.isEmpty()) {
            List<String> canonicalSectionOrder = List.of(PyPsiBundle.message("QDOC.attributes", new Object[0]), PyPsiBundle.message("QDOC.params", new Object[0]), PyPsiBundle.message("QDOC.keyword.args", new Object[0]), PyPsiBundle.message("QDOC.returns", new Object[0]), PyPsiBundle.message("QDOC.raises", new Object[0]));
            ArrayList topSections = new ArrayList(canonicalSectionOrder);
            topSections.retainAll(this.mySectionsMap.keySet());
            ArrayList<String> remainingSections = new ArrayList<String>(this.mySectionsMap.keySet());
            remainingSections.removeAll(topSections);
            for (String header : ContainerUtil.concat(topSections, remainingSections)) {
                this.mySections.append((HtmlChunk)HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{HtmlChunk.text((String)header).wrapWith(DocumentationMarkup.SECTION_HEADER_CELL), this.mySectionsMap.get(header).wrapWith(DocumentationMarkup.SECTION_CONTENT_CELL)}));
            }
        }
        for (PythonDocumentationQuickInfoProvider point : PythonDocumentationQuickInfoProvider.EP_NAME.getExtensionList()) {
            String info = point.getHoverAdditionalQuickInfo(this.myContext, outerElement);
            if (info == null) continue;
            this.myBody.br();
            this.myBody.append(info);
            break;
        }
        if (this.myBody.isEmpty() && this.myContent.isEmpty()) {
            return null;
        }
        HtmlBuilder result = new HtmlBuilder();
        HtmlBuilder definitionBuilder = new HtmlBuilder();
        if (!this.myProlog.isEmpty()) {
            definitionBuilder.append(this.myProlog);
        }
        if (!this.myBody.isEmpty()) {
            definitionBuilder.append((HtmlChunk)this.myBody.wrapWith(DocumentationMarkup.PRE_ELEMENT).wrapWith(DocumentationMarkup.DEFINITION_ELEMENT));
        }
        result.append(definitionBuilder);
        if (!this.myContent.isEmpty()) {
            result.append((HtmlChunk)this.myContent.wrapWith(DocumentationMarkup.CONTENT_ELEMENT));
        }
        if (!this.mySectionsMap.isEmpty()) {
            result.append((HtmlChunk)this.mySections.wrapWith(DocumentationMarkup.SECTIONS_TABLE));
        }
        return result.wrapWithHtmlBody().toString();
    }

    private static String getDocFileNameForKeywordElement(PsiElement element, IElementType elementType) {
        PyStatement parentStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyStatement.class);
        if (parentStatement == null) {
            return element.getText();
        }
        if (elementType == PyTokenTypes.FROM_KEYWORD) {
            if (parentStatement.getFirstChild() instanceof PyYieldExpression) {
                return "yield";
            }
            if (parentStatement instanceof PyRaiseStatement) {
                return "raise";
            }
        } else if (elementType == PyTokenTypes.AS_KEYWORD) {
            if (parentStatement instanceof PyWithStatement) {
                return "with";
            }
            if (parentStatement instanceof PyTryExceptStatement) {
                return "except";
            }
        } else if (elementType == PyTokenTypes.ELSE_KEYWORD) {
            if (parentStatement instanceof PyWhileStatement) {
                return "while";
            }
            if (parentStatement instanceof PyForStatement) {
                return "for";
            }
            if (parentStatement instanceof PyTryExceptStatement) {
                return "try";
            }
        } else if (elementType == PyTokenTypes.IN_KEYWORD && parentStatement instanceof PyForStatement) {
            return "for";
        }
        return element.getText();
    }

    private void buildForKeyword(@NotNull String name) {
        if (name == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(1);
        }
        try (FileReader reader = new FileReader(PythonHelpersLocator.findPathStringInHelpers((String)("/tools/python_keywords/" + name)), StandardCharsets.UTF_8);){
            String text = FileUtil.loadTextAndClose((Reader)reader);
            String converted = StringUtil.convertLineSeparators((String)text, (String)"\n");
            this.myContent.appendRaw(converted);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void buildFromParameter(@NotNull PyNamedParameter parameter) {
        PyFunction func;
        if (parameter == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(2);
        }
        HtmlChunk link = (func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class, (boolean)true, (Class[])new Class[]{PyLambdaExpression.class})) != null ? PyDocumentationBuilder.getLinkToFunction(func, true) : HtmlChunk.text((String)"<unnamed>");
        String parameterName = parameter.getName();
        if (link != null && parameterName != null) {
            this.myBody.appendRaw(PyPsiBundle.message("QDOC.parameter.name.of.link", HtmlChunk.text((String)parameterName).bold(), link)).br();
        }
        if (func != null) {
            StructuredDocString structuredDocString;
            String description;
            PyStringLiteralExpression docString;
            PyClass containingClass = func.getContainingClass();
            PyStringLiteralExpression functionDocstring = PyDocumentationBuilder.getEffectiveDocStringExpression((PyDocStringOwner)func);
            PyStringLiteralExpression pyStringLiteralExpression = docString = functionDocstring == null && containingClass != null ? this.addFunctionInheritedDocString(func, containingClass) : functionDocstring;
            if (docString != null && StringUtil.isNotEmpty((String)(description = (structuredDocString = DocStringUtil.parse(docString.getStringValue())).getParamDescription(parameter.getName())))) {
                this.myContent.append(this.runFormatterService(description));
            }
        }
        this.myBody.append(PythonDocumentationProvider.describeParameter(parameter, this.myContext));
    }

    private void buildFromTypeParameter(@NotNull PyTypeParameter typeParameter) {
        if (typeParameter == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(3);
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)typeParameter);
        HtmlChunk link = null;
        String typeParamName = typeParameter.getName();
        if (scopeOwner instanceof PyFunction) {
            PyFunction pyFunction = (PyFunction)scopeOwner;
            link = PyDocumentationBuilder.getLinkToFunction(pyFunction, true);
        } else if (scopeOwner instanceof PyClass) {
            PyClass pyClass = (PyClass)scopeOwner;
            link = this.getLinkToClass(pyClass, true);
        } else if (scopeOwner instanceof PyTypeAliasStatement) {
            PyTypeAliasStatement typeAliasStatement = (PyTypeAliasStatement)scopeOwner;
            link = PyDocumentationBuilder.getLinkToTypeAliasStatement(typeAliasStatement);
        }
        if (link != null && typeParamName != null) {
            this.myBody.appendRaw(PyPsiBundle.message("QDOC.type.parameter.name.of.link", HtmlChunk.text((String)typeParamName).bold(), link)).br();
            this.myBody.append(PythonDocumentationProvider.describeTypeParameter(typeParameter, true, this.myContext));
        }
    }

    private void buildFromTypeAliasStatement(@NotNull PyTypeAliasStatement typeAliasStatement) {
        if (typeAliasStatement == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(4);
        }
        ScopeOwner scopeOwner = ScopeUtil.getScopeOwner((PsiElement)typeAliasStatement);
        HtmlChunk link = null;
        String typeParamName = typeAliasStatement.getName();
        if (scopeOwner instanceof PyFunction) {
            PyFunction pyFunction = (PyFunction)scopeOwner;
            link = PyDocumentationBuilder.getLinkToFunction(pyFunction, true);
        } else if (scopeOwner instanceof PyClass) {
            PyClass pyClass = (PyClass)scopeOwner;
            link = this.getLinkToClass(pyClass, true);
        } else if (scopeOwner instanceof PyFile) {
            PyFile pyFile = (PyFile)scopeOwner;
            link = PyDocumentationBuilder.getLinkToModule(pyFile);
        }
        if (link != null && typeParamName != null) {
            this.myBody.appendRaw(PyPsiBundle.message("QDOC.type.alias.statement.name.of.link", HtmlChunk.text((String)typeParamName).bold(), link)).br();
            this.myBody.append(PythonDocumentationProvider.describeTypeAlias(typeAliasStatement, this.myContext));
        }
    }

    @NotNull
    private HtmlChunk runFormatterService(@NotNull @Nls String description) {
        DocstringFormatterRequest output;
        if (description == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(5);
        }
        HtmlChunk htmlChunk = (output = PyStructuredDocstringFormatter.formatDocstring(this.myElement, new DocstringFormatterRequest(description, Collections.emptyList()), List.of("--fragments"))) != null ? HtmlChunk.raw((String)output.getBody()) : HtmlChunk.text((String)description);
        if (htmlChunk == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(6);
        }
        return htmlChunk;
    }

    @Nullable
    private PsiElement buildFromProperty(@NotNull PsiElement elementDefinition, @Nullable PsiElement outerElement) {
        PyStringLiteralExpression getterDocstring;
        PyFunction getter;
        PyStringLiteralExpression accessorDocstring;
        PyFunction accessorFunc;
        if (elementDefinition == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(7);
        }
        if (this.myOriginalElement == null) {
            return null;
        }
        String propertyName = this.myOriginalElement.getText();
        if (!PyNames.isIdentifier((String)propertyName)) {
            return null;
        }
        if (!(outerElement instanceof PyQualifiedExpression)) {
            return null;
        }
        PyExpression qualifier = ((PyQualifiedExpression)outerElement).getQualifier();
        if (qualifier == null) {
            return null;
        }
        PyType type = this.myContext.getType((PyTypedElement)qualifier);
        if (!(type instanceof PyClassType)) {
            return null;
        }
        PyClass cls = ((PyClassType)type).getPyClass();
        Property property = cls.findProperty(propertyName, true, null);
        if (property == null) {
            return null;
        }
        AccessDirection direction = AccessDirection.of((PyAstElement)((PyElement)outerElement));
        Maybe accessor = property.getByDirection(direction);
        HtmlChunk link = this.getLinkToClass(cls, true);
        if (link != null) {
            this.myBody.appendRaw(PyPsiBundle.message("QDOC.property.name.of.link", HtmlChunk.text((String)propertyName).bold(), link)).br();
        }
        String docstring = null;
        if (property.getDoc() != null) {
            docstring = property.getDoc();
        }
        if (docstring == null && (accessorFunc = PyUtil.as(accessor.valueOrNull(), PyFunction.class)) != null && (accessorDocstring = PyDocumentationBuilder.getEffectiveDocStringExpression((PyDocStringOwner)accessorFunc)) != null) {
            docstring = accessorDocstring.getStringValue();
        }
        Maybe propertyGetter = property.getGetter();
        if (docstring == null && direction != AccessDirection.READ && (getter = PyUtil.as(propertyGetter.valueOrNull(), PyFunction.class)) != null && (getterDocstring = PyDocumentationBuilder.getEffectiveDocStringExpression((PyDocStringOwner)getter)) != null) {
            this.mySectionsMap.get(PyPsiBundle.message("QDOC.copied.from", new Object[0])).append(PyPsiBundle.message("QDOC.property.getter", new Object[0]));
            docstring = getterDocstring.getStringValue();
        }
        if (docstring != null) {
            this.myContent.append(PyDocumentationBuilder.safeRunFormatterService(elementDefinition, docstring));
        }
        this.mySectionsMap.get(PyPsiBundle.message("QDOC.accessor.kind", new Object[0])).append(PyDocumentationBuilder.getAccessorKind(direction)).append((String)(accessor.valueOrNull() == null ? " " + PyPsiBundle.message("QDOC.not.defined.in.parentheses", new Object[0]) : ""));
        if (accessor.valueOrNull() != null) {
            return (PsiElement)accessor.value();
        }
        if (propertyGetter.valueOrNull() != null) {
            return (PsiElement)propertyGetter.value();
        }
        return property.getDefinitionSite();
    }

    @NotNull
    private static String getAccessorKind(@NotNull AccessDirection dir) {
        if (dir == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(8);
        }
        String accessorKind = dir == AccessDirection.READ ? "Getter" : (dir == AccessDirection.WRITE ? "Setter" : "Deleter");
        String string = accessorKind;
        if (string == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(9);
        }
        return string;
    }

    private void buildFromDocstring(@NotNull PyDocStringOwner elementDefinition, boolean isProperty) {
        String formatterInput;
        HtmlChunk linkToModule;
        PsiFile containing;
        if (elementDefinition == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(10);
        }
        PyStringLiteralExpression ownDocstring = PyDocumentationBuilder.getEffectiveDocStringExpression(elementDefinition);
        PyStringLiteralExpression effectiveDocstring = this.modifyDocStringByOwnerType(ownDocstring, elementDefinition, isProperty);
        if (PyUtil.isTopLevel((PsiElement)elementDefinition) && (containing = ((PsiElement)ObjectUtils.chooseNotNull((Object)PyiUtil.getOriginalElement((PyElement)elementDefinition), (Object)elementDefinition)).getContainingFile()) instanceof PyFile && (linkToModule = PyDocumentationBuilder.getLinkToModule((PyFile)containing)) != null) {
            this.myProlog.append((HtmlChunk)DocumentationMarkup.BOTTOM_ELEMENT.children(new HtmlChunk[]{HtmlChunk.icon((String)"AllIcons.Nodes.Package", (Icon)AllIcons.Nodes.Package), HtmlChunk.nbsp(), linkToModule.code()}));
        }
        if (elementDefinition instanceof PyClass) {
            PyClass pyClass = (PyClass)elementDefinition;
            this.myBody.append(PythonDocumentationProvider.describeDecorators((PyDecoratable)pyClass, (HtmlChunk)HtmlChunk.br()));
            this.myBody.append(PythonDocumentationProvider.describeClass(pyClass, this.myContext));
            if (effectiveDocstring != null) {
                PyFunction init;
                this.addAttributesSection(effectiveDocstring);
                if (effectiveDocstring == ownDocstring && (init = pyClass.findMethodByName("__init__", false, this.myContext)) != null) {
                    this.addFunctionSpecificSections(effectiveDocstring, init);
                }
            }
        } else if (elementDefinition instanceof PyFunction) {
            HtmlChunk link;
            PyFunction pyFunction = (PyFunction)elementDefinition;
            this.myBody.append(PythonDocumentationProvider.describeDecorators((PyDecoratable)pyFunction, (HtmlChunk)HtmlChunk.br()));
            this.myBody.append(PythonDocumentationProvider.describeFunction(pyFunction, this.myContext, false));
            PyClass pyClass = pyFunction.getContainingClass();
            if (!isProperty && pyClass != null && (link = this.getLinkToClass(pyClass, true)) != null) {
                this.myProlog.append((HtmlChunk)DocumentationMarkup.BOTTOM_ELEMENT.children(new HtmlChunk[]{HtmlChunk.icon((String)"AllIcons.Nodes.Class", (Icon)AllIcons.Nodes.Class), HtmlChunk.nbsp(), link.code()}));
            }
            if (effectiveDocstring != null) {
                this.addFunctionSpecificSections(effectiveDocstring, pyFunction);
                if (effectiveDocstring != ownDocstring && PyUtil.isInitOrNewMethod((PsiElement)pyFunction)) {
                    this.addAttributesSection(effectiveDocstring);
                }
            }
        } else if (elementDefinition instanceof PyFile) {
            PyFile pyFile = (PyFile)elementDefinition;
            this.addModulePath(pyFile);
        } else if (elementDefinition instanceof PyTargetExpression) {
            PyTargetExpression target = (PyTargetExpression)elementDefinition;
            this.addTargetDocumentation(target, isProperty);
        }
        String string = formatterInput = effectiveDocstring != null && !isProperty ? effectiveDocstring.getStringValue() : null;
        if (StringUtil.isEmpty((String)formatterInput) && this.myFormatterFragments.isEmpty()) {
            return;
        }
        DocstringFormatterRequest output = PyStructuredDocstringFormatter.formatDocstring(this.myElement, new DocstringFormatterRequest(StringUtil.notNullize((String)formatterInput), this.myFormatterFragments), List.of("--fragments"));
        if (output != null) {
            this.myContent.appendRaw(output.getBody());
            this.fillFormattedSections(output.getFragments());
        } else {
            if (effectiveDocstring != null) {
                this.myContent.append(PyDocumentationBuilder.updateLines(this.myElement, Strings.notNullize((String)formatterInput)));
            }
            this.fillFormattedSections(this.myFormatterFragments);
        }
    }

    @Nullable
    private PyStringLiteralExpression modifyDocStringByOwnerType(@Nullable PyStringLiteralExpression docstring, @NotNull PyDocStringOwner owner, boolean isProperty) {
        PyFunction pyFunction;
        PyClass containingClass;
        if (owner == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(11);
        }
        if (docstring != null) {
            return docstring;
        }
        if (owner instanceof PyClass) {
            PyClass pyClass = (PyClass)owner;
            PyFunction init = pyClass.findMethodByName("__init__", false, this.myContext);
            if (init != null) {
                return PyDocumentationBuilder.getEffectiveDocStringExpression((PyDocStringOwner)init);
            }
        } else if (owner instanceof PyFunction && (containingClass = (pyFunction = (PyFunction)owner).getContainingClass()) != null && !isProperty) {
            return this.addFunctionInheritedDocString(pyFunction, containingClass);
        }
        return docstring;
    }

    private void fillFormattedSections(@NotNull List<FormatterDocFragment> fragmentList) {
        if (fragmentList == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(12);
        }
        fragmentList.forEach(fragment -> {
            String html = fragment.html().toString();
            if (html.isEmpty()) {
                return;
            }
            HtmlBuilder section = switch (fragment.myFragmentType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.mySectionsMap.get(PyPsiBundle.message("QDOC.attributes", new Object[0]));
                case 1 -> this.mySectionsMap.get(PyPsiBundle.message("QDOC.params", new Object[0]));
                case 4 -> this.mySectionsMap.get(PyPsiBundle.message("QDOC.keyword.args", new Object[0]));
                case 3 -> this.mySectionsMap.get(PyPsiBundle.message("QDOC.raises", new Object[0]));
                case 2 -> this.mySectionsMap.get(PyPsiBundle.message("QDOC.returns", new Object[0]));
            };
            section.appendRaw(html);
        });
    }

    private void addTargetDocumentation(@NotNull PyTargetExpression target, boolean isProperty) {
        if (target == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(13);
        }
        if (this.isAttribute() && !isProperty) {
            StructuredDocString structuredDocString;
            String description;
            PyStringLiteralExpression docString;
            PyClass containingClass = target.getContainingClass();
            HtmlChunk link = this.getLinkToClass(containingClass, true);
            String targetName = target.getName();
            if (link != null && targetName != null) {
                if (PyUtil.isInstanceAttribute((PyExpression)target)) {
                    this.myBody.appendRaw(PyPsiBundle.message("QDOC.instance.attribute", HtmlChunk.text((String)targetName).bold(), link));
                } else {
                    this.myBody.appendRaw(PyPsiBundle.message("QDOC.class.attribute", HtmlChunk.text((String)targetName).bold(), link));
                }
                this.myBody.br();
            }
            if (PyDocumentationBuilder.getEffectiveDocStringExpression((PyDocStringOwner)target) == null && (docString = PyDocumentationBuilder.getEffectiveDocStringExpression((PyDocStringOwner)containingClass)) != null && StringUtil.isNotEmpty((String)(description = (structuredDocString = DocStringUtil.parse(docString.getStringValue())).getAttributeDescription(targetName)))) {
                this.myContent.append(this.runFormatterService(description));
            }
        }
        this.myBody.append(PythonDocumentationProvider.describeTarget(target, this.myContext));
    }

    private void addAttributesSection(@NotNull PyStringLiteralExpression docstring) {
        if (docstring == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(14);
        }
        StructuredDocString structured = DocStringUtil.parseDocString(docstring);
        List documentedAttributes = structured.getAttributes();
        StreamEx.of((Collection)documentedAttributes).forEach(name -> {
            String description = structured.getAttributeDescription(name);
            this.myFormatterFragments.add(new FormatterDocFragment((String)name, StringUtil.notNullize((String)description), FormatterDocFragmentType.ATTRIBUTE));
        });
    }

    private void addFunctionSpecificSections(@NotNull PyStringLiteralExpression docstring, @NotNull PyFunction function) {
        if (docstring == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(15);
        }
        if (function == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(16);
        }
        StructuredDocString structured = DocStringUtil.parseDocString(docstring);
        List parameters = function.getParameters(this.myContext);
        List actualNames = ContainerUtil.mapNotNull((Collection)parameters, PyCallableParameter::getName);
        ((StreamEx)StreamEx.of((Collection)actualNames).filter(name -> structured.getParamDescription(name) != null)).forEach(name -> {
            String description = structured.getParamDescription(name);
            this.myFormatterFragments.add(new FormatterDocFragment((String)name, StringUtil.notNullize((String)description), FormatterDocFragmentType.PARAMETER));
        });
        List allKeywordArgs = structured.getKeywordArguments();
        if (!ContainerUtil.exists((Iterable)parameters, PyCallableParameter::isKeywordContainer)) {
            allKeywordArgs.retainAll(new HashSet(actualNames));
        }
        StreamEx.of((Collection)allKeywordArgs).forEach(name -> {
            String description = structured.getKeywordArgumentDescription(name);
            this.myFormatterFragments.add(new FormatterDocFragment((String)name, StringUtil.notNullize((String)description), FormatterDocFragmentType.KEYWORD_ARGUMENT));
        });
        String returnDescription = structured.getReturnDescription();
        if (returnDescription != null) {
            this.myFormatterFragments.add(new FormatterDocFragment("return", returnDescription, FormatterDocFragmentType.RETURN));
        }
        StreamEx.of((Collection)structured.getRaisedExceptions()).forEach(name -> {
            String description = structured.getRaisedExceptionDescription(name);
            this.myFormatterFragments.add(new FormatterDocFragment((String)name, StringUtil.notNullize((String)description), FormatterDocFragmentType.RAISE));
        });
    }

    private boolean isAttribute() {
        return this.myElement instanceof PyTargetExpression && PyUtil.isAttribute((PyTargetExpression)this.myElement);
    }

    @NotNull
    private PsiElement resolveToDocStringOwner() {
        PyCallableType callableType;
        PyCallable callable;
        PyFunction function;
        PyType type;
        PsiElement resolved;
        PsiElement resolved2;
        PyExpression assignedValue;
        if (this.myElement instanceof PyTargetExpression && ((PyTargetExpression)this.myElement).getDocStringValue() == null && (assignedValue = ((PyTargetExpression)this.myElement).findAssignedValue()) instanceof PyReferenceExpression && (resolved2 = this.resolve((PyReferenceExpression)assignedValue)) instanceof PyDocStringOwner) {
            String name = ((PyTargetExpression)this.myElement).getName();
            if (name != null) {
                this.mySectionsMap.get(PyPsiBundle.message("QDOC.assigned.to", new Object[0])).append((HtmlChunk)HtmlChunk.text((String)name).code());
            }
            PsiElement psiElement = resolved2;
            if (psiElement == null) {
                PyDocumentationBuilder.$$$reportNull$$$0(17);
            }
            return psiElement;
        }
        if (this.myElement instanceof PyReferenceExpression && (resolved = this.resolve((PyReferenceExpression)this.myElement)) != null) {
            PsiElement psiElement = resolved;
            if (psiElement == null) {
                PyDocumentationBuilder.$$$reportNull$$$0(18);
            }
            return psiElement;
        }
        resolved2 = this.myElement;
        if (resolved2 instanceof PyFunction && (type = new PyFunctoolsWrapsDecoratedFunctionTypeProvider().getCallableType((PyCallable)(function = (PyFunction)resolved2), this.myContext)) instanceof PyCallableType && (callable = (callableType = (PyCallableType)type).getCallable()) != null) {
            PyCallable pyCallable = callable;
            if (pyCallable == null) {
                PyDocumentationBuilder.$$$reportNull$$$0(19);
            }
            return pyCallable;
        }
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(20);
        }
        return psiElement;
    }

    @Nullable
    private PsiElement resolve(@NotNull PyReferenceExpression element) {
        if (element == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(21);
        }
        PyResolveContext resolveContext = PyResolveContext.implicitContext((TypeEvalContext)this.myContext);
        QualifiedResolveResult resolveResult = element.followAssignmentsChain(resolveContext);
        return resolveResult.getElement();
    }

    @Nullable
    private PyStringLiteralExpression addFunctionInheritedDocString(@NotNull PyFunction pyFunction, @NotNull PyClass pyClass) {
        String methodName;
        if (pyFunction == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(22);
        }
        if (pyClass == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(23);
        }
        if ((methodName = pyFunction.getName()) == null) {
            return null;
        }
        boolean isConstructor = PyUtil.isInitOrNewMethod((PsiElement)pyFunction);
        List classes = pyClass.getAncestorClasses(this.myContext);
        if (isConstructor) {
            classes = ContainerUtil.prepend((List)classes, (Object[])new PyClass[]{pyClass});
        }
        for (PyClass ancestor : classes) {
            HtmlChunk ancestorLink;
            PyStringLiteralExpression docstringElement = null;
            PyFunction inherited = null;
            boolean isFromClass = false;
            if (isConstructor) {
                docstringElement = PyDocumentationBuilder.getEffectiveDocStringExpression((PyDocStringOwner)ancestor);
                boolean bl = isFromClass = docstringElement != null;
            }
            if (!isFromClass && (inherited = ancestor.findMethodByName(methodName, false, null)) != null) {
                docstringElement = PyDocumentationBuilder.getEffectiveDocStringExpression((PyDocStringOwner)inherited);
            }
            if (docstringElement == null || docstringElement.getStringValue().isEmpty()) continue;
            HtmlChunk htmlChunk = ancestorLink = isFromClass ? this.getLinkToClass(ancestor, false) : PyDocumentationBuilder.getLinkToFunction(inherited, false);
            if (ancestorLink != null) {
                this.mySectionsMap.get(PyPsiBundle.message("QDOC.copied.from", new Object[0])).append((HtmlChunk)ancestorLink.code());
            }
            return docstringElement;
        }
        if (PyNames.UNDERSCORED_ATTRIBUTES.contains(methodName)) {
            return this.addPredefinedMethodDoc(pyFunction, methodName);
        }
        return null;
    }

    @Nullable
    private PyStringLiteralExpression addPredefinedMethodDoc(@NotNull PyFunction fun, @NotNull String methodName) {
        PyClass objectClass;
        PyFunction predefinedMethod;
        PyClassType objectType;
        if (fun == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(24);
        }
        if (methodName == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(25);
        }
        if ((objectType = PyBuiltinCache.getInstance((PsiElement)fun).getObjectType()) != null && (predefinedMethod = (objectClass = objectType.getPyClass()).findMethodByName(methodName, false, null)) != null) {
            String predefinedDoc;
            PyStringLiteralExpression predefinedDocstring = PyDocumentationBuilder.getEffectiveDocStringExpression((PyDocStringOwner)predefinedMethod);
            String string = predefinedDoc = predefinedDocstring != null ? predefinedDocstring.getStringValue() : null;
            if (predefinedDoc != null && !predefinedDoc.isEmpty()) {
                this.mySectionsMap.get(PyPsiBundle.message("QDOC.copied.from", new Object[0])).append(PyPsiBundle.message("QDOC.built.in.description", new Object[0]));
                this.myContent.append(PyDocumentationBuilder.safeRunFormatterService((PsiElement)fun, predefinedDoc));
            }
            return predefinedDocstring;
        }
        return null;
    }

    @NotNull
    private static HtmlChunk safeRunFormatterService(@NotNull PsiElement element, @NotNull String docstring) {
        DocstringFormatterRequest formatted;
        if (element == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(26);
        }
        if (docstring == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(27);
        }
        if ((formatted = PyStructuredDocstringFormatter.formatDocstring(element, new DocstringFormatterRequest(docstring), Collections.emptyList())) != null) {
            HtmlChunk htmlChunk = HtmlChunk.raw((String)formatted.getBody());
            if (htmlChunk == null) {
                PyDocumentationBuilder.$$$reportNull$$$0(28);
            }
            return htmlChunk;
        }
        return PyDocumentationBuilder.updateLines(element, docstring);
    }

    @NotNull
    private static HtmlChunk updateLines(@NotNull PsiElement element, @NotNull String docstring) {
        if (element == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(29);
        }
        if (docstring == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(30);
        }
        List origLines = LineTokenizer.tokenizeIntoList((CharSequence)docstring.trim(), (boolean)false, (boolean)false);
        List updatedLines = ((StreamEx)StreamEx.of((Collection)PyIndentUtil.removeCommonIndent((Iterable)origLines, (boolean)true)).takeWhile(line -> !line.startsWith(">>>"))).toList();
        HtmlBuilder result = new HtmlBuilder();
        boolean isFirstLine = true;
        int tabSize = PythonCodeStyleService.getInstance().getTabSize(element.getContainingFile());
        for (Object line2 : updatedLines) {
            int leadingTabs;
            if (isFirstLine && ourSpacesPattern.matcher((CharSequence)line2).matches()) continue;
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                result.br();
            }
            for (leadingTabs = 0; leadingTabs < ((String)line2).length() && ((String)line2).charAt(leadingTabs) == '\t'; ++leadingTabs) {
            }
            if (leadingTabs > 0) {
                line2 = StringUtil.repeatSymbol((char)' ', (int)(tabSize * leadingTabs)) + ((String)line2).substring(leadingTabs);
            }
            result.append(HtmlChunk.text((String)line2));
        }
        HtmlChunk htmlChunk = result.toFragment();
        if (htmlChunk == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(31);
        }
        return htmlChunk;
    }

    private void addModulePath(@NotNull PyFile followed) {
        VirtualFile file;
        if (followed == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(32);
        }
        if ((file = followed.getVirtualFile()) == null) {
            this.myBody.append((HtmlChunk)HtmlChunk.text((String)PyPsiBundle.message("QDOC.module.path.unknown", new Object[0])).wrapWith(HtmlChunk.tag((String)"small")));
        } else {
            QualifiedName name = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)followed);
            if (name != null) {
                @NonNls String qualifiedName = ((QualifiedName)ObjectUtils.chooseNotNull((Object)QualifiedNameFinder.canonizeQualifiedName((PsiElement)followed, name, null), (Object)name)).toString();
                if (PyUtil.isPackage((PsiFile)followed)) {
                    this.myBody.appendRaw(PyPsiBundle.message("QDOC.package.name", HtmlChunk.text((String)qualifiedName).bold()));
                } else {
                    this.myBody.appendRaw(PyPsiBundle.message("QDOC.module.name", HtmlChunk.text((String)qualifiedName).bold()));
                }
            } else {
                @NonNls String path = file.getPath();
                this.myBody.append((HtmlChunk)HtmlChunk.raw((String)path).wrapWith(HtmlChunk.tag((String)"span").attr("path", path)));
            }
        }
    }

    @Nullable
    private static HtmlChunk getLinkToModule(@NotNull PyFile module) {
        QualifiedName name;
        if (module == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(33);
        }
        if ((name = QualifiedNameFinder.findCanonicalImportPath((PsiElement)module, null)) != null) {
            return PyDocumentationLink.toModule(name.toString(), name.toString());
        }
        VirtualFile vFile = module.getVirtualFile();
        if (vFile != null) {
            @NlsSafe String vFilePath = vFile.getPath();
            return HtmlChunk.raw((String)vFilePath);
        }
        return null;
    }

    @Nullable
    private HtmlChunk getLinkToClass(@NotNull PyClass pyClass, boolean preferQualifiedName) {
        String linkText;
        if (pyClass == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(34);
        }
        String qualifiedName = pyClass.getQualifiedName();
        String shortName = pyClass.getName();
        String string = linkText = preferQualifiedName && qualifiedName != null ? qualifiedName : shortName;
        if (linkText == null) {
            return null;
        }
        if (qualifiedName != null) {
            return PyDocumentationLink.toClass(pyClass, linkText);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PyClass.class, (boolean)false) == pyClass) {
            return PyDocumentationLink.toContainingClass(linkText);
        }
        return HtmlChunk.raw((String)linkText);
    }

    @Nullable
    private static HtmlChunk getLinkToFunction(@NotNull PyFunction function, boolean preferQualifiedName) {
        String linkText;
        if (function == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(35);
        }
        String qualifiedName = function.getQualifiedName();
        PyClass pyClass = function.getContainingClass();
        String shortName = pyClass == null ? function.getName() : pyClass.getName() + "." + function.getName();
        String string = linkText = preferQualifiedName && qualifiedName != null ? qualifiedName : shortName;
        if (linkText == null || function.getName() == null || pyClass != null && pyClass.getName() == null) {
            return null;
        }
        if (qualifiedName != null) {
            return PyDocumentationLink.toFunction(linkText, function);
        }
        return HtmlChunk.raw((String)linkText);
    }

    @Nullable
    private static HtmlChunk getLinkToTypeAliasStatement(@NotNull PyTypeAliasStatement typeAliasStatement) {
        if (typeAliasStatement == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(36);
        }
        String linkText = typeAliasStatement.getQualifiedName();
        PsiFile file = typeAliasStatement.getContainingFile();
        if (linkText == null || typeAliasStatement.getName() == null || file == null) {
            return null;
        }
        return PyDocumentationLink.toTypeAliasStatement(linkText, typeAliasStatement);
    }

    @Nullable
    static PyStringLiteralExpression getEffectiveDocStringExpression(@NotNull PyDocStringOwner owner) {
        PyStringLiteralExpression expression;
        if (owner == null) {
            PyDocumentationBuilder.$$$reportNull$$$0(37);
        }
        if ((expression = owner.getDocStringExpression()) != null) {
            return expression;
        }
        PsiElement original = PyiUtil.getOriginalElement((PyElement)owner);
        PyDocStringOwner originalOwner = PyUtil.as(original, PyDocStringOwner.class);
        return originalOwner != null ? originalOwner.getDocStringExpression() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 17, 18, 19, 20, 28, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 4: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAliasStatement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationBuilder";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDefinition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 11: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: 
            case 15: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docstring";
                break;
            }
            case 16: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
            case 23: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "followed";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runFormatterService";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorKind";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveToDocStringOwner";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "safeRunFormatterService";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "updateLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildForKeyword";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildFromParameter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildFromTypeParameter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildFromTypeAliasStatement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runFormatterService";
                break;
            }
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 28: 
            case 31: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildFromProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAccessorKind";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildFromDocstring";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "modifyDocStringByOwnerType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillFormattedSections";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTargetDocumentation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addAttributesSection";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionSpecificSections";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionInheritedDocString";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addPredefinedMethodDoc";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "safeRunFormatterService";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateLines";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addModulePath";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLinkToModule";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLinkToClass";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getLinkToFunction";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLinkToTypeAliasStatement";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveDocStringExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 17, 18, 19, 20, 28, 31 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static final class DocstringFormatterRequest {
        @NotNull
        @NlsSafe
        private final String body;
        @NotNull
        private final List<FormatterDocFragment> fragments;

        DocstringFormatterRequest() {
            this.body = "";
            this.fragments = Collections.emptyList();
        }

        @ApiStatus.Internal
        public DocstringFormatterRequest(@NotNull String body) {
            if (body == null) {
                DocstringFormatterRequest.$$$reportNull$$$0(0);
            }
            this.body = body;
            this.fragments = Collections.emptyList();
        }

        DocstringFormatterRequest(@NotNull String body, @NotNull List<FormatterDocFragment> fragments) {
            if (body == null) {
                DocstringFormatterRequest.$$$reportNull$$$0(1);
            }
            if (fragments == null) {
                DocstringFormatterRequest.$$$reportNull$$$0(2);
            }
            this.body = body;
            this.fragments = fragments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DocstringFormatterRequest)) {
                return false;
            }
            DocstringFormatterRequest structure = (DocstringFormatterRequest)o;
            return this.body.equals(structure.body) && this.fragments.equals(structure.fragments);
        }

        public int hashCode() {
            return Objects.hash(this.body, this.fragments);
        }

        @NotNull
        @NlsSafe
        String getBody() {
            String string = this.body;
            if (string == null) {
                DocstringFormatterRequest.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        List<FormatterDocFragment> getFragments() {
            List<FormatterDocFragment> list = this.fragments;
            if (list == null) {
                DocstringFormatterRequest.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationBuilder$DocstringFormatterRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationBuilder$DocstringFormatterRequest";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBody";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static final class FormatterDocFragment {
        @NlsSafe
        private static final String NDASH = " &ndash; ";
        @NlsSafe
        private final String myName;
        @NlsSafe
        private final String myDescription;
        private final FormatterDocFragmentType myFragmentType;

        private FormatterDocFragment(@NotNull String name, @NotNull String description, @NotNull FormatterDocFragmentType type) {
            if (name == null) {
                FormatterDocFragment.$$$reportNull$$$0(0);
            }
            if (description == null) {
                FormatterDocFragment.$$$reportNull$$$0(1);
            }
            if (type == null) {
                FormatterDocFragment.$$$reportNull$$$0(2);
            }
            this.myName = name;
            this.myDescription = description;
            this.myFragmentType = type;
        }

        @NotNull
        public HtmlChunk html() {
            if (this.myName.isEmpty() && this.myFragmentType != FormatterDocFragmentType.RETURN) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    FormatterDocFragment.$$$reportNull$$$0(3);
                }
                return htmlChunk;
            }
            HtmlBuilder builder = new HtmlBuilder();
            if (this.myFragmentType == FormatterDocFragmentType.RETURN) {
                HtmlChunk htmlChunk = builder.appendRaw(this.myDescription).toFragment();
                if (htmlChunk == null) {
                    FormatterDocFragment.$$$reportNull$$$0(4);
                }
                return htmlChunk;
            }
            builder.append((HtmlChunk)HtmlChunk.raw((String)this.myName).code());
            if (!this.myDescription.isEmpty()) {
                builder.appendRaw(NDASH).appendRaw(this.myDescription);
            }
            HtmlChunk.Element element = builder.wrapWith(HtmlChunk.p());
            if (element == null) {
                FormatterDocFragment.$$$reportNull$$$0(5);
            }
            return element;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            FormatterDocFragment that = (FormatterDocFragment)obj;
            return Objects.equals(this.myName, that.myName) && Objects.equals(this.myDescription, that.myDescription) && Objects.equals((Object)this.myFragmentType, (Object)that.myFragmentType);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.myName, this.myDescription, this.myFragmentType});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyDocumentationBuilder$FormatterDocFragment";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyDocumentationBuilder$FormatterDocFragment";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "html";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private static enum FormatterDocFragmentType {
        ATTRIBUTE,
        PARAMETER,
        RETURN,
        RAISE,
        KEYWORD_ARGUMENT;

    }
}

