/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.similarity.Levenshtein;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.AdverbAdjectiveConfusion;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SemiModal;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.en.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.List;
import java.util.Locale;
import one.util.streamex.StreamEx;

class ClausalComplements {
    static final String infinitiveRequiringVerbs = "agree|appear|arrange|ask|attempt|beg|afford|care|chance|choose|claim|consent|dare|decide|demand|deserve|determine|elect|endeavor|expect|fail|guarantee|hesitate|hope|hurry|incline|manage|neglect|offer|plan|prepare|pretend|proceed|profess|promise|prove|refuse|request|resolve|seek|shudder|strive|struggle|swear|tend|threaten|venture|volunteer|wait|wish|yearn";
    static final NodePattern verb_NPToInf_Gerund = NodePattern.N.lemma("advise|encourage|require|tell|allow");
    static final NodePattern requiringCompSubject = NodePattern.N.lemma("afford|aim|allow|bother|care|condescend|consent|endeavour|fail|hasten|hesitate|learn|long|manage|offer|prepare|proceed|refuse|seek|strive|tend|trouble|undertake|volunteer|accustom|aid|appoint|assist|cause|challenge|defy|drive|empower|enable|encourage|entice|entitle|entreat|force|get|incite|induce|inspire|invite|lead|leave|oblige|prompt|provoke|stimulate|summon|teach|tell|tempt|elect|want|command|direct|implore|instruct|order|persuade|remind|require|warn|ask|beg|desire|expect|request");

    ClausalComplements() {
    }

    static NodePattern useInfinitive() {
        NodeCorrector.Relative toToInfinitive = NodeCorrector.inflect("VB").join(NodeCorrector.insertBefore("to "));
        NodePattern correctToInfinitive = NodePattern.or(EnglishTreePatterns.withToMark.correct(NodeCorrector.inflect("VB")), NodePattern.N.correct(toToInfinitive));
        NodePattern addMessage = NodePattern.N.withHead(NodePattern.N.message("'$_' requires a base verb form"));
        NodePattern possiblyAdjNoun = NodePattern.N.potentialPos("JJ").directlyBefore(NodePattern.N.pos("NN.*"));
        NodePattern mainPattern = NodePattern.N.potentialPos("VB[NG]").noPotentialPos("VB").afterHead().noDependents("cop|aux|aux:pass").withHead(NodePattern.not(NodePattern.N.pos("NN.*")).markAs("Head")).noMatchUntil("Head", NodePattern.PUNCT).andNot(CommonPatterns.capitalizedMiddle).andOr(NodePattern.N.withHead("xcomp|acl", NodePattern.N.lemma(infinitiveRequiringVerbs).noDependents("obj")).noPos("VBN").andNot(NodePattern.N.potentialPos("JJ").withHead("xcomp", NodePattern.N.lemma("prove|appear"))).andNot(NodePattern.N.withHeadRelation("xcomp").onlyPos("VBG").noDependents("obj")).and(addMessage).and(correctToInfinitive), NodePattern.N.withHead("xcomp", NodePattern.N.lemma("want").noHeadRelation("acl:relcl").noDependents("i?obj")).andNot(possiblyAdjNoun).withDependent("obj|obl").and(addMessage).and(correctToInfinitive), NodePattern.N.withHead("xcomp", NodePattern.N.lemma("advise|remind").withDependent("obj").noDependents("ccomp")).andNot(possiblyAdjNoun).and(addMessage).and(correctToInfinitive), NodePattern.N.withHead("xcomp|advcl", NodePattern.N.lemma("eager|agree|appear|arrange|ask|attempt|beg|afford|care|chance|choose|claim|consent|dare|decide|demand|deserve|determine|elect|endeavor|expect|fail|guarantee|hesitate|hope|hurry|incline|manage|neglect|offer|plan|prepare|pretend|proceed|profess|promise|prove|refuse|request|resolve|seek|shudder|strive|struggle|swear|tend|threaten|venture|volunteer|wait|wish|yearn")).withDependent("mark", NodePattern.N.form("to").directlyAfter("Head")).and(addMessage).correct(NodeCorrector.inflect("VB")), NodePattern.N.withHead(NodePattern.N.lemma("help").noDependents("aux", NodePattern.N.lemma("can")).noDependents("obj", NodePattern.N.pos("NN.*"))).andOr(NodePattern.N.withHeadRelation("[xc]comp"), NodePattern.N.withHeadRelation("advcl").andOr(EnglishTreePatterns.withToMark, EnglishTreePatterns.negated, NodePattern.N.noDependents(NodePattern.N.beforeHead()))).andNot(NodePattern.N.pos("NN").and(Semantics.possiblyUncountableLemma.withHead(NodePattern.N.noDependents("obj")).trace("misparsed obj of 'help'"))).and(addMessage).and(NodePattern.or(EnglishTreePatterns.negated, NodePattern.N.correct(NodeCorrector.inflect("VB")))).and(correctToInfinitive), NodePattern.N.withHead("xcomp", NodePattern.N.lemma("remind").noDependents("obj|ccomp").markAs("Remind")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").andNot(possiblyAdjNoun).and(addMessage).correct(NodeCorrector.inflect("VB").join(NodeCorrector.insertBefore("__________ to "))).and(NodePattern.markedNodeMatches("Remind", NodePattern.N.correct(EnglishTreePatterns.changeVerbLemma("remember")))));
        NodePattern possible = NodePattern.N.form("possible").withHeadRelation("xcomp").markAs("Possible").directlyBefore(NodePattern.N.potentialPos("VBG")).andOr(EnglishTreePatterns.possibleDoubleXComp.directlyBefore(NodePattern.N.withHead("xcomp", NodePattern.N.noDependents("obj"))), NodePattern.N.directlyBefore(NodePattern.N.withHead("amod", NodePattern.N.withHeadRelation("obj").withPrevSibling(NodePattern.N.alreadyMarkedAs("Possible"))))).directlyBefore(NodePattern.N.correct(NodeCorrector.insertBefore(NodePointer.marked("Possible"), "it ").join(toToInfinitive))).message("'possible' requires 'to' with the base verb form");
        return NodePattern.or(possible, mainPattern).noForm("sharing");
    }

    static NodePattern useGerund() {
        String gerundRequiringVerbs = "abhor|acknowledge|admit|anticipate|appreciate|avoid|celebrate|confess|consider|defend|delay|detest|discontinue|discuss|dislike|dispute|dread|endure|enjoy|escape|evade|fancy|fear|feign|finish|forgive|mention|mind|miss|necessitate|omit|permit|picture|postpone|practice|prevent|recall|recollect|recommend|report|resent|resist|resume|risk|shirk|shun|suggest|support|tolerate|urge|warrant";
        NodePattern gerundRequiringNominals = NodePattern.or(NodePattern.N.form("worth").withDependent("cop"), NodePattern.N.lemma("difficulty|problem|fun").withHead("obj", NodePattern.N.lemma("have")), NodePattern.N.form("time").andOr(NodePattern.N.inFormSequence(2, "an?", "good|hard|difficult|easy", "time").withHead("obj", NodePattern.N.lemma("have")), NodePattern.N.withDependent("nmod:poss").withHead(NodePattern.N.lemma("spend|waste"))));
        NodePattern possiblyParticiple = NodePattern.N.pos("VBN").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").andNot(NodePattern.N.withHead("conj", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")));
        NodePattern gerundRequiringHead = NodePattern.or(NodePattern.N.lemma(gerundRequiringVerbs), verb_NPToInf_Gerund.noDependents("i?obj|aux:pass").andNot(NodePattern.N.pos("VBD").withDependent("aux", NodePattern.N.lemma("will"))).andNot(NodePattern.N.withHeadRelation("acl:relcl").noDependents("nsubj", NodePattern.N.form("which"))).andNot(NodePattern.N.withHeadRelation("parataxis").withPrevSibling(NodePattern.N.afterHead().pos("NN.*")))).noPos("VBG").andNot(possiblyParticiple).andNot(CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withDependent("i?obj|aux:pass|cop|compound"), NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("for|to"))))));
        NodePattern toGerundRequiringHead = NodePattern.or(NodePattern.N.form("accustomed").withDependent("cop|aux:pass"), NodePattern.N.form("used").withDependent("cop|aux:pass").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.lemma("I|we|s?he")), NodePattern.N.form("look").withDependent("advmod", NodePattern.N.form("forward")).noDependents("obl", NodePattern.N.withDependent("case", NodePattern.N.form("to"))));
        return NodePattern.N.pos("VBP?").afterHead().andOr(NodePattern.N.withHead("xcomp|advcl", toGerundRequiringHead.markAs("ToGerundHead")), NodePattern.N.withHead("ccomp|xcomp", gerundRequiringHead.markAs("GerundHead")).andNot(NodePattern.N.directlyAfterHead().sameWordAs("GerundHead")).noMatchUntil("GerundHead", NodePattern.PUNCT), NodePattern.N.withHead("acl|csubj", gerundRequiringNominals.markAs("GerundHead")).andOr(NodePattern.N.withDependent("obj|[xc]comp|advcl"), NodePattern.N.withHead(NodePattern.or(EnglishTreePatterns.negated, NodePattern.N.withDependent("det", NodePattern.N.form("no")))))).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations)).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations)).andNot(NodePattern.N.withDependent("mark", NodePattern.N.form("for|how|as"))).andNot(NodePattern.N.withDependent("i?obj|mark|advmod", NodePattern.N.pos("W.*"))).noDependents("i?obj", NodePattern.N.beforeHead().trace("subject misparsed as iobj")).andNot(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")).andNot(NodePattern.N.withHeadRelation("xcomp").pos("JJ.*")).andOptionally(NodePattern.N.withDependent("mark", NodePattern.N.form("to").markAs("To"))).andOptionally(NodePattern.N.withDependent(".*", CommonPatterns.firstChildPhrase.noDependents().markAs("SubjTypo").and(NodePattern.markedNodeMatches("To", NodePattern.N.after("SubjTypo"))))).and((verb, match) -> {
            Node to = match.findMarkedNode("To");
            List<String> gerunds = verb.tree().treeSupport().inflectNode(verb, "VB.*", "VBG");
            if (gerunds.isEmpty()) {
                return null;
            }
            NodeCorrector corrector = NodeCorrector.replace(verb, gerunds);
            Node toGerundHead = (match = match.withReportedNode(verb)).findMarkedNode("ToGerundHead");
            if (toGerundHead != null) {
                return to == null ? null : match.withCorrector(corrector).withMessage(toGerundHead.quotedPresentableText() + " requires an -ing form");
            }
            Node head = match.getMarkedNode("GerundHead");
            if (to != null) {
                if (to.nextUntil(verb).anyMatch(n -> !n.hasHeadRelation("advmod"))) {
                    return null;
                }
                corrector = corrector.join(NodeCorrector.removeNode(to));
                match = match.withReportedNode(to);
            }
            String useGerundMessage = "Use gerund '" + gerunds.getFirst().toLowerCase(Locale.ROOT) + "'";
            if (!head.hasPos("VB.*")) {
                return match.withCorrector(corrector).withMessage(useGerundMessage + " after " + head.quotedPresentableText());
            }
            if (!(!verb_NPToInf_Gerund.matches(head) || to == null || head.hasPos("VBN") && head.hasDependent("aux"))) {
                String fix;
                Node subjTypo = match.findMarkedNode("SubjTypo");
                if (subjTypo != null && (fix = (String)StreamEx.of((Object[])new String[]{"me", "you", "him", "her", "it", "us", "them", "one"}).findFirst(sug -> Levenshtein.WithDamerau.distance(sug, subjTypo.lowForm()) == 1).orElse(null)) != null) {
                    return EnglishTreePatterns.typoReplacement(fix).match(subjTypo, match.withReportedNode(subjTypo));
                }
                return match.withCorrectors(List.of(corrector, NodeCorrector.insertAfter(head, " you"), NodeCorrector.insertAfter(head, " one"))).withMessage(useGerundMessage + " or add a noun/pronoun after " + head.quotedPresentableText());
            }
            return match.withCorrector(corrector).withMessage(useGerundMessage + " or add a noun/pronoun after " + head.quotedPresentableText());
        }).andOptionally(NodePattern.markedNodeMatches("GerundHead", verb_NPToInf_Gerund.potentialPos("VBN").directlyBefore(NodePattern.N.form("to")).withDependent("nsubj(:pass)?", NodePattern.N.markAs("Subj")).noDependents("cop|aux|aux:pass").directlyAfter(NodePattern.N.includeIntoReport()).and((node, match) -> {
            boolean hasPast = node.tree().nodes().stream().anyMatch(n -> n != node && n.hasPos("VBD"));
            String be = VerbInflectionNumber.from(node, match.getMarkedNode("Subj")).past(hasPast).inflectBe();
            return match.withCorrector(NodeCorrector.insertBefore(node, be + " "));
        })));
    }

    static NodePattern missingInfinitiveTo() {
        NodePattern implyingCompSubject = NodePattern.N.lemma("agree|appear|arrange|claim|decide|demand|determine|guarantee|happen|hope|like|love|need|pretend|promise|resolve|seem|swear|threaten|vow").andNot(SemiModal.possiblyModalNeed).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.contractedNot));
        String objCompSubjectPossibleAmbiguity = "remind|learn|warn";
        NodePattern objAfterXcompAdj = NodePattern.N.withDependent("obj").potentialPos("JJ.*").and(NodePattern.markedNodeMatches("Head", NodePattern.or(AdverbAdjectiveConfusion.adjRequiringVerbs, AdverbAdjectiveConfusion.adjAllowingVerbs))).trace("misattached obj placed after the misparsed xcomp");
        NodePattern withTransitiveHead = NodePattern.or(NodePattern.markedNodeMatches("Head", implyingCompSubject).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").trace("implyingCompSubject"), NodePattern.markedNodeMatches("Head", requiringCompSubject.noDependents("i?obj")).noDependents("nsubj", NodePattern.N.form("that|I|we|they|s?he")).andNot(objAfterXcompAdj).trace("requiringCompSubject no obj"), NodePattern.N.withPrevSibling(NodePattern.N.markAs("Prev")).and(NodePattern.markedNodeMatches("Head", requiringCompSubject.withDependent("i?obj", NodePattern.N.alreadyMarkedAs("Prev")))).noDependents("nsubj").trace("requiringCompSubject with obj"), NodePattern.markedNodeMatches("Head", NodePattern.N.lemma("dare").withDependent("obj")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").trace("dare"), NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").and(NodePattern.markedNodeMatches("Head", NodePattern.N.lemma("wish"))).trace("wish"));
        NodePattern withIntransitiveHead = NodePattern.N.withHead(NodePattern.N.lemma("start|begin|stop|try|remember|forget")).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("i?obj"))).trace("withIntransitiveHead");
        NodePattern insertTo = NodePattern.N.withPhraseStart(NodePattern.or(NodePattern.N.form("so|t[a-z]").correct(NodeCorrector.replace("to")).includeIntoReport(), NodePattern.N.correct(NodeCorrector.insertBefore("to "))).includeIntoReport());
        NodePattern couldBeNoun = NodePattern.or(NodePattern.N.potentialPos("NN.*"), NodePattern.N.form("advise"), EnglishTreePatterns.verbsMissingNounPosTags).andOr(NodePattern.or(NodePattern.N.noDependents("obj|advmod|compound:prt").noDependents("obl", NodePattern.N.pos("NN.*|PRP")), NodePattern.N.withHeadRelation("xcomp").withDependent("obj", NodePattern.N.directlyAfterHead().pos("NNS?")), NodePattern.N.pos("NN").directlyBefore(NodePattern.N.form("of"))).andNot(EnglishTreePatterns.unlikelyToBeNoun), EnglishTreePatterns.build.directlyBefore(NodePattern.N.pos("NN.*")));
        NodePattern root_vs_relclComp_ambiguity = NodePattern.N.withHead("acl:relcl", NodePattern.ROOT.noDependents("cop"));
        NodePattern misparsedRelCl = NodePattern.N.withDependent("nsubj.*", NodePattern.N.form("that")).withHead("ccomp", NodePattern.N.pos("VBN").directlyAfter(NodePattern.N.pos("NN.*")));
        NodePattern headedPattern = NodePattern.N.afterHead().noDependents(NodePattern.not(NodePattern.N.anyPos().withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?|advmod")).beforeHead()).noDependents("cop|aux|aux:pass").noDependents(Questions.whPhrase).noDependents("advmod", EnglishTreePatterns.negation.afterHead()).andOr(NodePattern.N.withHead("xcomp|ccomp", NodePattern.not(root_vs_relclComp_ambiguity).noPos("NNS").markAs("Head")), NodePattern.N.withHead("obj", NodePattern.N.lemma("try|need").markAs("Head")), NodePattern.N.directlyAfterHead().withHead(NodePattern.N.withDependent("cop|aux:pass").markAs("Head")), NodePattern.N.directlyAfter(NodePattern.N.pos("VB.*").markAs("Head")).withPrevSibling(NodePattern.N.alreadyMarkedAs("Head"))).andNot(NodePattern.N.pos("JJ.*")).andNot(NodePattern.N.pos("VBN").directlyAfterHead().withHead(NodePattern.N.lemma("seem")).noDependents("i?obj|obl.*")).andNot(NodePattern.N.withHead("xcomp|ccomp", NodePattern.N.lemma("afraid|remember")).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")).andNot(NodePattern.N.withHead("ccomp", NodePattern.N.lemma(objCompSubjectPossibleAmbiguity)).withDependent("nsubj", NodePattern.N.form("I|we|they")).trace("definitely subjects of ccomp")).andNot(NodePattern.N.pos("VBN").andOr(NodePattern.markedNodeMatches("Head", NodePattern.N.lemma("get")), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("obj")))).andNot(NodePattern.N.withHeadRelation("ccomp").withPrevSibling(NodePattern.or(CommonPatterns.comma, CommonPatterns.colon))).andNot(NodePattern.N.inFormSequence(2, "if", "needs?", "be")).andNot(NodePattern.N.form("be").withHead("[xc]comp", NodePattern.N.lemma("leave").withDependent("obj"))).andNot(NodePattern.N.pos("NN.*").withHead("xcomp", NodePattern.N.form("allowed"))).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.quotations)).andNot(WordSeparation.doItYourself).andNot(misparsedRelCl).andNot(CommonPatterns.repeatedWord((w1, w2) -> true)).andNot(CommonPatterns.capitalizedMiddle.directlyBefore(CommonPatterns.capitalizedMiddle)).includeIntoReport().andOptionally(NodePattern.N.directlyAfter(NodePattern.N.alreadyMarkedAs("Head").includeIntoReport())).message("Use 'to' with the base verb form after '$Head'").andOr(withTransitiveHead.andOr(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.beforeHead().withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.includeIntoReport().correct(NodeCorrector.insertBefore("to ")))).andOptionally(NodePattern.markedNodeMatches("Head", NodePattern.N.lemma(objCompSubjectPossibleAmbiguity)).andNot(NodePattern.N.onlyPos("NN")).noForm("it|this|that").withHead(NodePattern.not(EnglishTreePatterns.negated)).includeIntoReport().withPhraseStart(NodePattern.N.correct(NodeCorrector.insertBefore("that "))))), insertTo), withIntransitiveHead.and(insertTo).andOr(NodePattern.N.withHead(NodePattern.N.pos("VBG")), NodePattern.N.correct(NodeCorrector.inflect("VBG"))), NodePattern.N.withHead("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis", NodePattern.N.pos("JJ.*").withDependent("cop|aux:pass")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").andNot(EnglishTreePatterns.negated).andNot(NodePattern.N.withPrevSibling(NodePattern.N.afterHead().withHeadRelation("csubj"))).andOptionally(NodePattern.or(NodePattern.N.form("thank|leave").withHead(NodePattern.N.correct(NodeCorrector.insertAfter(","))), NodePattern.N.withHead(NodePattern.N.form("sorry").correct(NodeCorrector.insertAfter(","))))).and(insertTo).trace("adjective copula"));
        NodePattern discourseLike = NodePattern.N.directlyAfter(NodePattern.N.form("like").withHeadRelation("discourse").directlyBeforeHead()).message("Use 'to' with the base verb form after 'like'").correct(NodeCorrector.insertBefore("to ")).trace("discourseLike");
        return NodePattern.N.pos("VBP?").andOr(headedPattern, discourseLike).andNot(couldBeNoun.trace("couldBeNoun"));
    }

    static NodePattern gerundVsInfinitive() {
        return NodePattern.or(ClausalComplements.useGerund(), ClausalComplements.useInfinitive()).andNot(CommonPatterns.capitalizedMiddle);
    }

    static NodePattern toFinite() {
        NodePattern oblMisparsedAsXcomp = NodePattern.N.pos("NNS").withHeadRelation("xcomp").andOr(NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("obj")).withOnlyDependents(NodePattern.N.alreadyMarkedAs("To")), NodePattern.N.withDependent("compound", NodePattern.N.beforeHead()).withDependent("mark", NodePattern.N.alreadyMarkedAs("To")));
        NodePattern withFrom = NodePattern.N.withDependent("case", NodePattern.N.form("from"));
        NodePattern fromToEllipsis = NodePattern.or(NodePattern.N.potentialPos("VBN").withHead("advcl", NodePattern.N.pos("VBN").andOr(NodePattern.N.withHead("acl", withFrom), NodePattern.N.withPrevSibling(withFrom))), NodePattern.N.withHead("obl|nmod", withFrom));
        return NodePattern.N.potentialPos("VB[ZD]").noPotentialPos("VB").and(CommonPatterns.possiblyConj(NodePattern.N.withHeadRelation("root|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis"))).noDependents("cop|aux|aux:pass", NodePattern.N.pos("VB[GN]?")).andNot(CommonPatterns.capitalizedMiddle).withDependent("mark", NodePattern.N.form("to").beforeHead().markAs("To").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("prior"))).andNot(NodePattern.N.directlyBefore(NodePattern.or(Questions.whWord, EnglishTreePatterns.quotations)))).noDependents("mark", NodePattern.N.after("To")).andNot(NodePattern.N.withHead("advcl", NodePattern.or(NodePattern.N.withDependent(".*", Questions.whPhrase), NodePattern.N.withHeadRelation("acl:relcl")))).andNot(NodePattern.N.potentialPos("NN.*").withHead(NodePattern.N.lemma("ask"))).andNot(NodePattern.N.withHead("advcl", NodePattern.N.pos("VB.*")).potentialPos("VBN").directlyBefore(NodePattern.N.pos("JJ.*|NN.*"))).andNot(fromToEllipsis).andNot(oblMisparsedAsXcomp).correct(NodeCorrector.inflect("VB")).message("'to' requires a base verb form");
    }
}

