/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring;

import com.google.common.base.Predicates;
import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.extractMethod.AbstractExtractMethodDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodDecorator;
import com.intellij.refactoring.extractMethod.ExtractMethodSettings;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.refactoring.util.AbstractParameterTablePanel;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.codeFragment.PyCodeFragment;
import com.jetbrains.python.refactoring.extractmethod.PyExtractMethodSettings;
import com.jetbrains.python.refactoring.extractmethod.PyExtractMethodUtil;
import com.jetbrains.python.refactoring.extractmethod.PyVariableData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExtractMethodDialog
extends AbstractExtractMethodDialog<Object> {
    private static final String TYPES_MESSAGE_KEY = "refactoring.extract.method.title.type";
    private static final String ADD_TYPE_ANNOTATIONS_MESSAGE_KEY = "refactoring.extract.method.addTypeAnnotations";
    private JCheckBox myAddTypeAnnotationsCheckbox;

    public PyExtractMethodDialog(Project project, String defaultName, PyCodeFragment fragment, Object[] visibilityVariants, ExtractMethodValidator validator, ExtractMethodDecorator<Object> decorator, FileType type2) {
        super(project, defaultName, (CodeFragment)fragment, visibilityVariants, validator, decorator, type2);
    }

    protected JComponent createCenterPanel() {
        JComponent original = super.createCenterPanel();
        assert (original != null);
        JPanel wrapper = new JPanel(new BorderLayout(0, 6));
        wrapper.add((Component)original, "Center");
        boolean selected = PyExtractMethodUtil.getAddTypeAnnotations((Project)this.myProject);
        this.myAddTypeAnnotationsCheckbox = new JCheckBox(PyBundle.message(ADD_TYPE_ANNOTATIONS_MESSAGE_KEY, new Object[0]), selected);
        wrapper.add((Component)this.myAddTypeAnnotationsCheckbox, "South");
        this.myAddTypeAnnotationsCheckbox.addChangeListener(changeEvent -> this.updateSignature());
        return wrapper;
    }

    protected void doOKAction() {
        PyExtractMethodUtil.setAddTypeAnnotations((Project)this.myProject, (boolean)this.myAddTypeAnnotationsCheckbox.isSelected());
        super.doOKAction();
    }

    @NotNull
    public PyExtractMethodSettings getExtractMethodSettings() {
        return new PyExtractMethodSettings(this.getMethodName(), this.getAbstractVariableData(), ((PyCodeFragment)this.myFragment).getOutputType(), ((PyCodeFragment)this.myFragment).getOutputTypes(), this.myAddTypeAnnotationsCheckbox.isSelected());
    }

    @NotNull
    protected @NotNull PyVariableData @NotNull [] innerCreateVariableDataByNames(@NotNull List<String> args) {
        if (args == null) {
            PyExtractMethodDialog.$$$reportNull$$$0(0);
        }
        PyVariableData[] datas = new PyVariableData[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            String name2;
            PyVariableData data = new PyVariableData();
            data.originalName = name2 = args.get(i);
            data.name = name2;
            data.passAsParameter = true;
            data.typeName = ((PyCodeFragment)this.myFragment).getInputTypeName(name2);
            data.type = ((PyCodeFragment)this.myFragment).getInputType(name2);
            datas[i] = data;
        }
        if (datas == null) {
            PyExtractMethodDialog.$$$reportNull$$$0(1);
        }
        return datas;
    }

    @NotNull
    protected @NotNull ColumnInfo @NotNull [] getParameterColumns() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[3];
        columnInfoArray[0] = new AbstractParameterTablePanel.PassParameterColumnInfo();
        columnInfoArray[1] = new AbstractParameterTablePanel.NameColumnInfo(arg_0 -> ((ExtractMethodValidator)this.myValidator).isValidName(arg_0));
        columnInfoArray[2] = new TypeColumnInfo();
        if (columnInfoArray == null) {
            PyExtractMethodDialog.$$$reportNull$$$0(2);
        }
        return columnInfoArray;
    }

    protected void updateSignature() {
        this.mySignaturePreviewTextArea.setSignature(this.myDecorator.createMethodSignature((ExtractMethodSettings)this.getExtractMethodSettings()));
    }

    @NotNull
    public @NotNull PyVariableData @NotNull [] getAbstractVariableData() {
        PyVariableData[] pyVariableDataArray = (PyVariableData[])this.myVariableData;
        if (pyVariableDataArray == null) {
            PyExtractMethodDialog.$$$reportNull$$$0(3);
        }
        return pyVariableDataArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/PyExtractMethodDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/PyExtractMethodDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "innerCreateVariableDataByNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterColumns";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAbstractVariableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "innerCreateVariableDataByNames";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class TypeColumnInfo
    extends ColumnInfo<PyVariableData, String> {
        private final Predicate<? super String> myNameValidator = Predicates.alwaysTrue();

        public TypeColumnInfo() {
            super(PyBundle.message(PyExtractMethodDialog.TYPES_MESSAGE_KEY, new Object[0]));
        }

        @Nullable
        public String valueOf(@NotNull PyVariableData data) {
            if (data == null) {
                TypeColumnInfo.$$$reportNull$$$0(0);
            }
            return data.getTypeName();
        }

        public void setValue(@NotNull PyVariableData data, @NotNull String value) {
            if (data == null) {
                TypeColumnInfo.$$$reportNull$$$0(1);
            }
            if (value == null) {
                TypeColumnInfo.$$$reportNull$$$0(2);
            }
            if (this.myNameValidator.test(value) && !Objects.equals(data.getTypeName(), value)) {
                data.typeName = value;
                data.type = null;
            }
        }

        public boolean isCellEditable(@NotNull PyVariableData data) {
            if (data == null) {
                TypeColumnInfo.$$$reportNull$$$0(3);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/refactoring/PyExtractMethodDialog$TypeColumnInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "valueOf";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCellEditable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

