/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJG\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2'\u0010\u0010\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\t0\u0012\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000b0\u0011H\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/ChangeListRemoveConfirmation;", "", "<init>", "()V", "checkCanDeleteChangelist", "Lcom/intellij/util/ThreeState;", "project", "Lcom/intellij/openapi/project/Project;", "list", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "explicitly", "", "deleteEmptyInactiveLists", "", "lists", "", "confirm", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "toAsk", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nChangeListRemoveConfirmation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangeListRemoveConfirmation.kt\ncom/intellij/openapi/vcs/changes/actions/ChangeListRemoveConfirmation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1617#2,9:85\n1869#2:94\n1870#2:96\n1626#2:97\n1869#2,2:98\n1#3:95\n*S KotlinDebug\n*F\n+ 1 ChangeListRemoveConfirmation.kt\ncom/intellij/openapi/vcs/changes/actions/ChangeListRemoveConfirmation\n*L\n65#1:85,9\n65#1:94\n65#1:96\n65#1:97\n80#1:98,2\n65#1:95\n*E\n"})
public final class ChangeListRemoveConfirmation {
    @NotNull
    public static final ChangeListRemoveConfirmation INSTANCE = new ChangeListRemoveConfirmation();

    private ChangeListRemoveConfirmation() {
    }

    @NotNull
    public final ThreeState checkCanDeleteChangelist(@NotNull Project project, @NotNull LocalChangeList list, boolean explicitly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        AbstractVcs[] activeVcss = ProjectLevelVcsManager.Companion.getInstance(project).getAllActiveVcss();
        boolean confirmationAsked = false;
        boolean removeVetoed = false;
        for (AbstractVcs vcs : activeVcss) {
            ThreeState permission;
            Intrinsics.checkNotNullExpressionValue((Object)vcs.mayRemoveChangeList(list, explicitly), (String)"mayRemoveChangeList(...)");
            if (permission != ThreeState.UNSURE) {
                confirmationAsked = true;
            }
            if (permission != ThreeState.NO) continue;
            removeVetoed = true;
            break;
        }
        if (!confirmationAsked) {
            return ThreeState.UNSURE;
        }
        if (removeVetoed) {
            return ThreeState.NO;
        }
        return ThreeState.YES;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void deleteEmptyInactiveLists(@NotNull Project project, @NotNull Collection<? extends LocalChangeList> lists, @NotNull Function1<? super List<? extends LocalChangeList>, Boolean> confirm) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(lists, (String)"lists");
        Intrinsics.checkNotNullParameter(confirm, (String)"confirm");
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager manager = changeListManager;
        List toRemove = new ArrayList();
        List toAsk = new ArrayList();
        Iterable $this$mapNotNull$iv = lists;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LocalChangeList it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LocalChangeList it = (LocalChangeList)element$iv$iv;
            boolean bl2 = false;
            if (manager.getChangeList(it.getId()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        block6: for (LocalChangeList list : (List)destination$iv$iv) {
            if (list.isDefault()) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[INSTANCE.checkCanDeleteChangelist(project, list, false).ordinal()]) {
                case 1: {
                    toAsk.add(list);
                    continue block6;
                }
                case 2: {
                    toRemove.add(list);
                    continue block6;
                }
                case 3: {
                    continue block6;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        if (!((Collection)toAsk).isEmpty() && ((Boolean)confirm.invoke((Object)toAsk)).booleanValue()) {
            toRemove.addAll(toAsk);
        }
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            LocalChangeList it = (LocalChangeList)element$iv;
            boolean bl = false;
            manager.removeChangeList(it.getName());
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.UNSURE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.YES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.NO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

