/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.ActivityId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.vcs.log.Hash;
import git4idea.DialogManager;
import git4idea.GitActivity;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitAbortRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitAbortRebaseProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsNotifier myNotifier;
    @Nullable
    private final GitRepository myRepositoryToAbort;
    @NotNull
    private final Map<GitRepository, String> myRepositoriesToRollback;
    @NotNull
    private final Map<GitRepository, String> myInitialCurrentBranches;
    @NotNull
    private final ProgressIndicator myIndicator;
    @Nullable
    private final GitChangesSaver mySaver;
    private final boolean myNotifySuccess;

    GitAbortRebaseProcess(@NotNull Project project, @Nullable GitRepository repositoryToAbort, @NotNull Map<GitRepository, String> repositoriesToRollback, @NotNull Map<GitRepository, String> initialCurrentBranches, @NotNull ProgressIndicator progressIndicator, @Nullable GitChangesSaver changesSaver, boolean notifySuccess) {
        if (project == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(0);
        }
        if (repositoriesToRollback == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(1);
        }
        if (initialCurrentBranches == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(2);
        }
        if (progressIndicator == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myRepositoryToAbort = repositoryToAbort;
        this.myRepositoriesToRollback = repositoriesToRollback;
        this.myInitialCurrentBranches = initialCurrentBranches;
        this.myIndicator = progressIndicator;
        this.mySaver = changesSaver;
        this.myNotifySuccess = notifySuccess;
        this.myGit = Git.getInstance();
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
    }

    void abortWithConfirmation() {
        LOG.info("Abort rebase. " + (this.myRepositoryToAbort == null ? "Nothing to abort" : DvcsUtil.getShortRepositoryName((Repository)this.myRepositoryToAbort)) + ". Roots to rollback: " + DvcsUtil.joinShortNames(this.myRepositoriesToRollback.keySet()));
        Ref ref = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)this.confirmAbort()));
        LOG.info("User choice: " + String.valueOf(ref.get()));
        if (ref.get() == AbortChoice.ROLLBACK_AND_ABORT) {
            this.doAbort(true);
        } else if (ref.get() == AbortChoice.ABORT) {
            this.doAbort(false);
        }
    }

    @NotNull
    private AbortChoice confirmAbort() {
        String title = GitBundle.message("rebase.abort.dialog.title", new Object[0]);
        if (this.myRepositoryToAbort != null) {
            if (this.myRepositoriesToRollback.isEmpty()) {
                String message = GitBundle.message("rebase.abort.dialog.message", DvcsUtil.getShortRepositoryName((Repository)this.myRepositoryToAbort));
                int choice = DialogManager.showOkCancelDialog(this.myProject, message, title, GitBundle.message("rebase.abort.dialog.ok.button.text", new Object[0]), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon());
                if (choice == 0) {
                    AbortChoice abortChoice = AbortChoice.ABORT;
                    if (abortChoice == null) {
                        GitAbortRebaseProcess.$$$reportNull$$$0(4);
                    }
                    return abortChoice;
                }
            } else {
                String message = GitBundle.message("rebase.abort.and.rollback.dialog.message", DvcsUtil.getShortRepositoryName((Repository)this.myRepositoryToAbort), DvcsUtil.joinShortNames(this.myRepositoriesToRollback.keySet(), (int)5));
                int choice = DialogManager.showYesNoCancelDialog(this.myProject, message, title, GitBundle.message("rebase.abort.and.rollback.dialog.yes.button.text", new Object[0]), GitBundle.message("rebase.abort.and.rollback.dialog.no.button.text", new Object[0]), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon());
                if (choice == 0) {
                    AbortChoice abortChoice = AbortChoice.ROLLBACK_AND_ABORT;
                    if (abortChoice == null) {
                        GitAbortRebaseProcess.$$$reportNull$$$0(5);
                    }
                    return abortChoice;
                }
                if (choice == 1) {
                    AbortChoice abortChoice = AbortChoice.ABORT;
                    if (abortChoice == null) {
                        GitAbortRebaseProcess.$$$reportNull$$$0(6);
                    }
                    return abortChoice;
                }
            }
        } else if (this.myRepositoriesToRollback.isEmpty()) {
            LOG.error(new Throwable());
        } else {
            String description = GitBundle.message("rebase.abort.rollback.successful.rebase.dialog.message", DvcsUtil.joinShortNames(this.myRepositoriesToRollback.keySet(), (int)-1));
            int choice = DialogManager.showOkCancelDialog(this.myProject, description, title, GitBundle.message("rebase.abort.rollback.successful.rebase.dialog.ok.button.text", new Object[0]), CommonBundle.getCancelButtonText(), Messages.getQuestionIcon());
            if (choice == 0) {
                AbortChoice abortChoice = AbortChoice.ROLLBACK_AND_ABORT;
                if (abortChoice == null) {
                    GitAbortRebaseProcess.$$$reportNull$$$0(7);
                }
                return abortChoice;
            }
        }
        AbortChoice abortChoice = AbortChoice.CANCEL;
        if (abortChoice == null) {
            GitAbortRebaseProcess.$$$reportNull$$$0(8);
        }
        return abortChoice;
    }

    private void doAbort(boolean rollback) {
        boolean[] success2 = new boolean[1];
        this.myNotifier.hideAllNotificationsById("git.rebase.stopped.for.editing");
        new GitFreezingProcess(this.myProject, GitBundle.message("activity.name.rebase", new Object[0]), () -> {
            String activityName = GitBundle.message("activity.name.abort.command", GitBundle.message("abort.operation.rebase.name", new Object[0]));
            try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)activityName, (ActivityId)GitActivity.Abort);){
                if (this.myRepositoryToAbort != null) {
                    this.myIndicator.setText2(GitBundle.message("rebase.abort.progress.indicator.command.in.repo.title", "git rebase --abort", DvcsUtil.getShortRepositoryName((Repository)this.myRepositoryToAbort)));
                    Hash startHash = GitUtil.getHead(this.myRepositoryToAbort);
                    GitRebaseCommandResult result2 = this.myGit.rebaseAbort(this.myRepositoryToAbort, new GitLineHandlerListener[0]);
                    if (result2.success()) {
                        GitUtil.updateAndRefreshChangedVfs(this.myRepositoryToAbort, startHash);
                    } else {
                        this.myNotifier.notifyError("git.rebase.abort.failed", GitBundle.message("rebase.abort.notification.failed.title", new Object[0]), result2.getErrorOutputAsHtmlString() + GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver), true);
                        return;
                    }
                }
                if (rollback) {
                    for (GitRepository repo : this.myRepositoriesToRollback.keySet()) {
                        String initialBranchPosition;
                        this.myIndicator.setText2(GitBundle.message("rebase.abort.progress.indicator.command.in.repo.title", "git reset --keep", DvcsUtil.getShortRepositoryName((Repository)repo)));
                        Hash startHash = GitUtil.getHead(repo);
                        GitCommandResult res = this.myGit.reset(repo, GitResetMode.KEEP, this.myRepositoriesToRollback.get(repo), new GitLineHandlerListener[0]);
                        if (res.success() && (initialBranchPosition = this.myInitialCurrentBranches.get(repo)) != null && !initialBranchPosition.equals(repo.getCurrentBranchName())) {
                            this.myIndicator.setText2(GitBundle.message("rebase.abort.progress.indicator.command.in.repo.title", "git checkout " + initialBranchPosition, DvcsUtil.getShortRepositoryName((Repository)repo)));
                            res = this.myGit.checkout(repo, initialBranchPosition, null, true, false, new GitLineHandlerListener[0]);
                        }
                        if (!res.success()) {
                            String description = this.myRepositoryToAbort != null ? GitBundle.message("rebase.abort.notification.warning.rollback.failed.with.repo.message", DvcsUtil.getShortRepositoryName((Repository)this.myRepositoryToAbort), repo, res.getErrorOutputAsHtmlString(), GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver)) : GitBundle.message("rebase.abort.notification.warning.rollback.failed.message", DvcsUtil.getShortRepositoryName((Repository)repo), res.getErrorOutputAsHtmlString(), GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver));
                            this.myNotifier.notifyImportantWarning("git.rebase.rollback.failed", GitBundle.message("rebase.abort.notification.warning.rollback.failed.title", new Object[0]), description);
                            return;
                        }
                        GitUtil.updateAndRefreshChangedVfs(repo, startHash);
                    }
                }
                success2[0] = true;
            }
        }).execute();
        if (success2[0]) {
            ChangeListManagerEx.getInstanceEx((Project)this.myProject).waitForUpdate();
            if (this.mySaver != null) {
                this.mySaver.load();
            }
            if (this.myNotifySuccess) {
                this.myNotifier.notifySuccess("git.rebase.abort.succeeded", "", GitBundle.message("rebase.abort.notification.successful.message", new Object[0]));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoriesToRollback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialCurrentBranches";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitAbortRebaseProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitAbortRebaseProcess";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "confirmAbort";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    static enum AbortChoice {
        ABORT,
        ROLLBACK_AND_ABORT,
        CANCEL;

    }
}

