/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.execution.test.runner.AbstractGradleTestRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.PatternGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.test.runner.TestClassGradleConfigurationProducer;
import org.jetbrains.plugins.gradle.util.GradleExecutionSettingsUtil;
import org.jetbrains.plugins.gradle.util.TasksToRun;

public class TestMethodGradleConfigurationProducer
extends AbstractGradleTestRunConfigurationProducer<PsiMethod, PsiClass> {
    @Override
    public boolean isPreferredConfiguration(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (other == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(1);
        }
        return !other.isProducedBy(PatternGradleConfigurationProducer.class) && (other.isProducedBy(TestClassGradleConfigurationProducer.class) || super.isPreferredConfiguration(self, other));
    }

    @Override
    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (other == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(3);
        }
        return !other.isProducedBy(PatternGradleConfigurationProducer.class) && (other.isProducedBy(TestClassGradleConfigurationProducer.class) || super.shouldReplace(self, other));
    }

    @Nullable
    protected PsiMethod getPsiMethodForLocation(@NotNull Location<?> contextLocation) {
        Location<PsiMethod> location;
        if (contextLocation == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(4);
        }
        return (location = GradleRunnerUtil.getMethodLocation(contextLocation)) != null ? (PsiMethod)location.getPsiElement() : null;
    }

    @Override
    @Nullable
    protected PsiMethod getElement(@NotNull ConfigurationContext context) {
        Location location;
        if (context == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context.getLocation()) == null) {
            return null;
        }
        PsiMethod psiMethod = this.getPsiMethodForLocation(location);
        if (psiMethod == null) {
            return null;
        }
        PsiClass psiClass = TestMethodGradleConfigurationProducer.getContainingClass(location, psiMethod);
        if (psiClass == null || psiClass.getName() == null || psiClass.getQualifiedName() == null) {
            return null;
        }
        PsiFile psiFile = psiMethod.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile source = psiFile.getVirtualFile();
        if (source == null) {
            return null;
        }
        return psiMethod;
    }

    @Override
    @NotNull
    protected String getLocationName(@NotNull ConfigurationContext context, @NotNull PsiMethod element) {
        if (context == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (element == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(7);
        }
        String string = element.getName();
        if (string == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    protected String suggestConfigurationName(@NotNull ConfigurationContext context, @NotNull PsiMethod element, @NotNull List<? extends PsiClass> chosenElements) {
        if (context == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (element == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (chosenElements == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(11);
        }
        PsiClass psiClass = Objects.requireNonNull(TestMethodGradleConfigurationProducer.getContainingClass(context.getLocation(), element));
        List<? extends PsiClass> elements = chosenElements.isEmpty() ? List.of(psiClass) : chosenElements;
        String string = StringUtil.join(elements, aClass -> aClass.getName() + "." + element.getName(), (String)"|");
        if (string == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Override
    protected void chooseSourceElements(@NotNull ConfigurationContext context, @NotNull PsiMethod element, @NotNull Consumer<List<PsiClass>> onElementsChosen) {
        if (context == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (element == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(14);
        }
        if (onElementsChosen == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(15);
        }
        PsiClass psiClass = Objects.requireNonNull(TestMethodGradleConfigurationProducer.getContainingClass(context.getLocation(), element));
        InheritorChooser.chooseAbstractClassInheritors((ConfigurationContext)context, (PsiClass)psiClass, onElementsChosen);
    }

    @Override
    @NotNull
    protected List<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> getAllTestsTaskToRun(@NotNull ConfigurationContext context, @NotNull PsiMethod element, @NotNull List<? extends PsiClass> chosenElements) {
        if (context == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (element == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(17);
        }
        if (chosenElements == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(18);
        }
        Project project = Objects.requireNonNull(context.getProject());
        Location location = Objects.requireNonNull(context.getLocation());
        VirtualFile source = Objects.requireNonNull(element.getContainingFile().getVirtualFile());
        PsiClass aClass = Objects.requireNonNull(TestMethodGradleConfigurationProducer.getContainingClass(location, element));
        List<? extends PsiClass> elements = chosenElements.isEmpty() ? List.of(aClass) : chosenElements;
        ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> testsTasksToRun = new ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun>();
        for (PsiClass psiClass : elements) {
            String testFilter = GradleExecutionSettingsUtil.createTestFilterFrom(location, psiClass, element);
            testsTasksToRun.addAll(ContainerUtil.map(TestMethodGradleConfigurationProducer.findAllTestsTaskToRun(source, project), it -> new AbstractGradleTestRunConfigurationProducer.TestTasksToRun((TasksToRun)it, testFilter)));
        }
        ArrayList<AbstractGradleTestRunConfigurationProducer.TestTasksToRun> arrayList = testsTasksToRun;
        if (arrayList == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Nullable
    private static PsiClass getContainingClass(@Nullable Location<?> location, @NotNull PsiMethod element) {
        if (element == null) {
            TestMethodGradleConfigurationProducer.$$$reportNull$$$0(20);
        }
        if (location instanceof PsiMemberParameterizedLocation) {
            PsiMemberParameterizedLocation memberParameterizedLocation = (PsiMemberParameterizedLocation)location;
            return memberParameterizedLocation.getContainingClass();
        }
        return element.getContainingClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 12, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLocation";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenElements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onElementsChosen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/TestMethodGradleConfigurationProducer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestConfigurationName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTestsTaskToRun";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPreferredConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPsiMethodForLocation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLocationName";
                break;
            }
            case 8: 
            case 12: 
            case 19: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "chooseSourceElements";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAllTestsTaskToRun";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 12, 19 -> new IllegalStateException(string);
        };
    }
}

