/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLParseException;
import net.n3.nanoxml.XMLUtil;

final class ContentReader
extends Reader {
    private final StdXMLReader reader;
    private final String buffer;
    private final IXMLEntityResolver resolver;
    private int bufferIndex;

    ContentReader(StdXMLReader reader, IXMLEntityResolver resolver, String buffer) {
        this.reader = reader;
        this.resolver = resolver;
        this.buffer = buffer;
        this.bufferIndex = 0;
    }

    @Override
    public int read(char[] outputBuffer, int offset, int size) throws IOException {
        try {
            int charsRead = 0;
            int bufferLength = this.buffer.length();
            if (offset + size > outputBuffer.length) {
                size = outputBuffer.length - offset;
            }
            while (charsRead < size) {
                char ch;
                if (this.bufferIndex < bufferLength) {
                    ch = this.buffer.charAt(this.bufferIndex);
                    ++this.bufferIndex;
                    outputBuffer[charsRead] = ch;
                    ++charsRead;
                    continue;
                }
                String str = XMLUtil.read(this.reader, '&');
                ch = str.charAt(0);
                if (ch == '<') {
                    this.reader.unread(ch);
                    break;
                }
                if (ch == '&' && str.length() > 1) {
                    if (str.charAt(1) == '#') {
                        ch = XMLUtil.processCharLiteral(str);
                    } else {
                        XMLUtil.processEntity(str, this.reader, this.resolver);
                        continue;
                    }
                }
                outputBuffer[charsRead] = ch;
                ++charsRead;
            }
            if (charsRead == 0) {
                charsRead = -1;
            }
            return charsRead;
        }
        catch (XMLParseException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            int bufferLength = this.buffer.length();
            while (true) {
                if (this.bufferIndex < bufferLength) {
                    ++this.bufferIndex;
                    continue;
                }
                String str = XMLUtil.read(this.reader, '&');
                char ch = str.charAt(0);
                if (ch == '<') {
                    this.reader.unread(ch);
                    break;
                }
                if (ch != '&' || str.length() <= 1 || str.charAt(1) == '#') continue;
                XMLUtil.processEntity(str, this.reader, this.resolver);
            }
        }
        catch (XMLParseException e) {
            throw new IOException(e.getMessage());
        }
    }
}

