/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.references.MavenPropertyPsiReference;
import org.jetbrains.idea.maven.dom.references.MavenPsiElementWrapper;

public final class MavenPropertyInParentInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        if (string == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "MavenPropertyInParent";
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        DomManager domManager;
        DomFileElement model;
        if (file2 == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(2);
        }
        if (file2 instanceof XmlFile && file2.isPhysical() && (model = (domManager = DomManager.getDomManager((Project)file2.getProject())).getFileElement((XmlFile)file2, MavenDomProjectModel.class)) != null) {
            boolean maven35 = MavenPropertyInParentInspection.isMaven35OrMore(file2);
            ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>(3);
            MavenDomParent mavenParent = ((MavenDomProjectModel)model.getRootElement()).getMavenParent();
            MavenPropertyInParentInspection.validate(manager, isOnTheFly, maven35, problems, mavenParent.getGroupId());
            MavenPropertyInParentInspection.validate(manager, isOnTheFly, maven35, problems, mavenParent.getArtifactId());
            MavenPropertyInParentInspection.validate(manager, isOnTheFly, maven35, problems, mavenParent.getVersion());
            if (problems.isEmpty()) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    private static boolean isMaven35OrMore(@NotNull PsiFile file2) {
        if (file2 == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(3);
        }
        return StringUtil.compareVersionNumbers((String)MavenDomUtil.getMavenVersion(file2.getVirtualFile(), file2.getProject()), (String)"3.5") >= 0;
    }

    private static void validate(@NotNull InspectionManager manager, boolean isOnTheFly, boolean maven35, @NotNull List<ProblemDescriptor> problems, @NotNull GenericDomValue<String> domValue) {
        String valueToCheck;
        String unresolvedValue;
        if (manager == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(4);
        }
        if (problems == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(5);
        }
        if (domValue == null) {
            MavenPropertyInParentInspection.$$$reportNull$$$0(6);
        }
        if ((unresolvedValue = domValue.getRawText()) == null) {
            return;
        }
        String string = valueToCheck = maven35 ? unresolvedValue.replaceAll("\\$\\{(revision|sha1|changelist)}", "") : unresolvedValue;
        if (valueToCheck.contains("${")) {
            XmlText[] textElements;
            XmlTag xmlTag;
            LocalQuickFix fix2 = null;
            String resolvedValue = domValue.getStringValue();
            if (resolvedValue == null) {
                return;
            }
            if (unresolvedValue.equals(resolvedValue) || resolvedValue.contains("${")) {
                resolvedValue = MavenPropertyInParentInspection.resolveXmlElement(domValue.getXmlElement());
            }
            if (!unresolvedValue.equals(resolvedValue) && !StringUtil.isEmpty((String)resolvedValue)) {
                final String finalResolvedValue = resolvedValue;
                fix2 = new LocalQuickFix(){

                    @IntentionFamilyName
                    @NotNull
                    public String getFamilyName() {
                        String string = MavenDomBundle.message("refactoring.inline.property", new Object[0]);
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                        PsiElement psiElement;
                        if (project == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (descriptor2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if ((psiElement = descriptor2.getPsiElement()) instanceof XmlTag) {
                            ((XmlTag)psiElement).getValue().setText(finalResolvedValue);
                        } else if (psiElement instanceof XmlText) {
                            ((XmlText)psiElement).setValue(finalResolvedValue);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 2;
                            case 1, 2 -> 3;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection$1";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "project";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "descriptor";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getFamilyName";
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                break;
                            }
                            case 1: 
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "applyFix";
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalStateException(string);
                            case 1, 2 -> new IllegalArgumentException(string);
                        };
                    }
                };
            }
            if ((xmlTag = domValue.getXmlTag()) != null && (textElements = xmlTag.getValue().getTextElements()).length > 0) {
                problems.add(manager.createProblemDescriptor((PsiElement)textElements[0], MavenDomBundle.message("inspection.property.in.parent.description", new Object[0]), fix2, ProblemHighlightType.GENERIC_ERROR, isOnTheFly));
            }
        }
    }

    @Nullable
    private static String resolveXmlElement(@Nullable XmlElement xmlElement) {
        if (xmlElement == null) {
            return null;
        }
        MavenPropertyPsiReference psiReference = (MavenPropertyPsiReference)ContainerUtil.findInstance((Object[])xmlElement.getReferences(), MavenPropertyPsiReference.class);
        if (psiReference == null) {
            return null;
        }
        PsiElement resolvedElement = psiReference.resolve();
        if (!(resolvedElement instanceof MavenPsiElementWrapper)) {
            return null;
        }
        PsiElement xmlTag = ((MavenPsiElementWrapper)resolvedElement).getWrappee();
        if (!(xmlTag instanceof XmlTag)) {
            return null;
        }
        return ((XmlTag)xmlTag).getValue().getTrimmedText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/inspections/MavenPropertyInParentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMaven35OrMore";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

