/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.diagnostic;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.PluginProblemReporter;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Attachment;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public class PluginException
extends RuntimeException
implements ExceptionWithAttachments {
    private final PluginId myPluginId;
    private final List<Attachment> myAttachments;

    public PluginException(@NotNull String message2, Throwable cause, @Nullable PluginId pluginId) {
        if (message2 == null) {
            PluginException.$$$reportNull$$$0(0);
        }
        super(message2, cause);
        this.myPluginId = pluginId;
        this.myAttachments = Collections.emptyList();
    }

    public PluginException(@NotNull Throwable e2, @Nullable PluginId pluginId) {
        if (e2 == null) {
            PluginException.$$$reportNull$$$0(1);
        }
        super(e2.getMessage(), e2);
        this.myPluginId = pluginId;
        this.myAttachments = Collections.emptyList();
    }

    public PluginException(@NotNull String message2, @Nullable PluginId pluginId) {
        if (message2 == null) {
            PluginException.$$$reportNull$$$0(2);
        }
        super(message2);
        this.myPluginId = pluginId;
        this.myAttachments = Collections.emptyList();
    }

    @Override
    @NotNull
    public String getMessage() {
        String message2 = super.getMessage();
        if (this.myPluginId == null || message2 != null && message2.contains("PluginDescriptor(")) {
            String string = message2;
            if (string == null) {
                PluginException.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = (message2 != null ? message2 : "null") + " [Plugin: " + this.myPluginId + "]";
        if (string == null) {
            PluginException.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public final Attachment @NotNull [] getAttachments() {
        Attachment[] attachmentArray = this.myAttachments.toArray(Attachment.EMPTY_ARRAY);
        if (attachmentArray == null) {
            PluginException.$$$reportNull$$$0(9);
        }
        return attachmentArray;
    }

    @NotNull
    public static PluginException createByClass(@NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        if (errorMessage == null) {
            PluginException.$$$reportNull$$$0(10);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(11);
        }
        PluginException pluginException = PluginProblemReporter.getInstance().createPluginExceptionByClass(errorMessage, cause, pluginClass);
        if (pluginException == null) {
            PluginException.$$$reportNull$$$0(12);
        }
        return pluginException;
    }

    @NotNull
    public static PluginException createByClass(@NotNull Throwable cause, @NotNull Class<?> pluginClass) {
        if (cause == null) {
            PluginException.$$$reportNull$$$0(13);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(14);
        }
        String message2 = cause.getMessage();
        PluginException pluginException = PluginProblemReporter.getInstance().createPluginExceptionByClass(message2 != null ? message2 : "", cause, pluginClass);
        if (pluginException == null) {
            PluginException.$$$reportNull$$$0(15);
        }
        return pluginException;
    }

    public static void logPluginError(@NotNull Logger logger, @NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        if (logger == null) {
            PluginException.$$$reportNull$$$0(16);
        }
        if (errorMessage == null) {
            PluginException.$$$reportNull$$$0(17);
        }
        if (pluginClass == null) {
            PluginException.$$$reportNull$$$0(18);
        }
        logger.error(PluginException.createByClass(errorMessage, cause, pluginClass));
    }

    public static void reportDeprecatedUsage(@NotNull String signature, @NotNull String details) {
        if (signature == null) {
            PluginException.$$$reportNull$$$0(19);
        }
        if (details == null) {
            PluginException.$$$reportNull$$$0(20);
        }
        String message2 = "`" + signature + "` is deprecated and going to be removed soon. " + details;
        PluginException t2 = new PluginException(message2, null);
        t2.setStackTrace(ArrayUtil.realloc(t2.getStackTrace(), 3, StackTraceElement[]::new));
        Logger.getInstance(PluginException.class).error(t2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attachments";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/diagnostic/PluginException";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "violator";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/diagnostic/PluginException";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachments";
                break;
            }
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createByClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createByClass";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "logPluginError";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "reportDeprecatedUsage";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "reportDeprecatedDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

