/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.core.util.objects.checker;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import org.apache.wicket.core.util.objects.checker.AbstractObjectChecker;
import org.apache.wicket.core.util.objects.checker.IObjectChecker;

public class ObjectSerializationChecker
extends AbstractObjectChecker {
    private final NotSerializableException cause;

    public ObjectSerializationChecker() {
        this((NotSerializableException)null);
    }

    public ObjectSerializationChecker(NotSerializableException cause) {
        this.cause = cause;
    }

    @Override
    public IObjectChecker.Result check(Object object) {
        IObjectChecker.Result result = IObjectChecker.Result.SUCCESS;
        if (!(object instanceof Serializable) && !Proxy.isProxyClass(object.getClass())) {
            result = new IObjectChecker.Result(IObjectChecker.Result.Status.FAILURE, "The object type is not Serializable!", this.cause);
        }
        return result;
    }
}

