/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl.ciphers;

import java.util.HashMap;
import java.util.Map;
import org.apache.tomcat.util.net.openssl.ciphers.Authentication;

public enum SignatureScheme {
    rsa_pkcs1_sha256(1025, Authentication.RSA),
    rsa_pkcs1_sha384(1281, Authentication.RSA),
    rsa_pkcs1_sha512(1537, Authentication.RSA),
    ecdsa_secp256r1_sha256(1027, Authentication.ECDSA),
    ecdsa_secp384r1_sha384(1283, Authentication.ECDSA),
    ecdsa_secp521r1_sha512(1539, Authentication.ECDSA),
    rsa_pss_rsae_sha256(2052, Authentication.RSA),
    rsa_pss_rsae_sha384(2053, Authentication.RSA),
    rsa_pss_rsae_sha512(2054, Authentication.RSA),
    ed25519(2055, Authentication.EdDSA),
    ed448(2056, Authentication.EdDSA),
    rsa_pss_pss_sha256(2057, Authentication.RSA),
    rsa_pss_pss_sha384(2058, Authentication.RSA),
    rsa_pss_pss_sha512(2059, Authentication.RSA),
    rsa_pkcs1_sha1(513, Authentication.RSA),
    ecdsa_sha1(515, Authentication.ECDSA),
    mldsa44(2308, Authentication.MLDSA),
    mldsa65(2309, Authentication.MLDSA),
    mldsa87(2310, Authentication.MLDSA);

    private final int id;
    private final Authentication auth;
    private static final Map<Integer, SignatureScheme> idMap;

    private SignatureScheme(int id, Authentication auth) {
        this.id = id;
        this.auth = auth;
    }

    public int getId() {
        return this.id;
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public static SignatureScheme valueOf(int schemeId) {
        return idMap.get(schemeId);
    }

    static {
        idMap = new HashMap<Integer, SignatureScheme>();
        for (SignatureScheme scheme : SignatureScheme.values()) {
            int id = scheme.getId();
            if (id <= 0 || id >= 65535) continue;
            idMap.put(id, scheme);
        }
    }
}

