/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.Response;
import org.apache.openejb.client.ThrowableArtifact;

public class LogoutResponse
implements Response {
    private static final long serialVersionUID = 7293643855614467349L;
    private transient int responseCode = -1;
    private transient Throwable deniedCause;
    private transient ProtocolMetaData metaData;

    public LogoutResponse() {
    }

    public LogoutResponse(int code) {
        this.responseCode = code;
    }

    @Override
    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    public Throwable getDeniedCause() {
        return this.deniedCause;
    }

    public void setDeniedCause(Throwable deniedCause) {
        this.deniedCause = deniedCause;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this.responseCode = in.readByte();
        switch (this.responseCode) {
            case 27: {
                this.deniedCause = null;
                break;
            }
            case 28: {
                ThrowableArtifact ta = new ThrowableArtifact();
                ta.setMetaData(this.metaData);
                ta.readExternal(in);
                this.deniedCause = ta.getThrowable();
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(1);
        out.writeByte((byte)this.responseCode);
        switch (this.responseCode) {
            case 28: {
                ThrowableArtifact ta = new ThrowableArtifact(this.deniedCause);
                ta.setMetaData(this.metaData);
                ta.writeExternal(out);
                break;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        switch (this.responseCode) {
            case 27: {
                sb.append("LOGOUT_SUCCESS");
                break;
            }
            case 28: {
                sb.append("LOGOUT_FAILED:");
                sb.append(null != this.deniedCause ? this.deniedCause.toString() : "Unknown denial");
            }
        }
        return sb.toString();
    }
}

