/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.yubico.webauthn.extension.uvm.UserVerificationMethod;
import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

@JsonDeserialize(builder=BiometricStatusReportBuilder.class)
public final class BiometricStatusReport {
    private final int certLevel;
    @NonNull
    private final UserVerificationMethod modality;
    private final LocalDate effectiveDate;
    private final String certificationDescriptor;
    private final String certificateNumber;
    private final String certificationPolicyVersion;
    private final String certificationRequirementsVersion;

    public Optional<LocalDate> getEffectiveDate() {
        return Optional.ofNullable(this.effectiveDate);
    }

    public Optional<String> getCertificationDescriptor() {
        return Optional.ofNullable(this.certificationDescriptor);
    }

    public Optional<String> getCertificateNumber() {
        return Optional.ofNullable(this.certificateNumber);
    }

    public Optional<String> getCertificationPolicyVersion() {
        return Optional.ofNullable(this.certificationPolicyVersion);
    }

    public Optional<String> getCertificationRequirementsVersion() {
        return Optional.ofNullable(this.certificationRequirementsVersion);
    }

    @Generated
    BiometricStatusReport(int certLevel, @NonNull UserVerificationMethod modality, LocalDate effectiveDate, String certificationDescriptor, String certificateNumber, String certificationPolicyVersion, String certificationRequirementsVersion) {
        if (modality == null) {
            throw new NullPointerException("modality is marked non-null but is null");
        }
        this.certLevel = certLevel;
        this.modality = modality;
        this.effectiveDate = effectiveDate;
        this.certificationDescriptor = certificationDescriptor;
        this.certificateNumber = certificateNumber;
        this.certificationPolicyVersion = certificationPolicyVersion;
        this.certificationRequirementsVersion = certificationRequirementsVersion;
    }

    @Generated
    public static BiometricStatusReportBuilder builder() {
        return new BiometricStatusReportBuilder();
    }

    @Generated
    public BiometricStatusReportBuilder toBuilder() {
        return new BiometricStatusReportBuilder().certLevel(this.certLevel).modality(this.modality).effectiveDate(this.effectiveDate).certificationDescriptor(this.certificationDescriptor).certificateNumber(this.certificateNumber).certificationPolicyVersion(this.certificationPolicyVersion).certificationRequirementsVersion(this.certificationRequirementsVersion);
    }

    @Generated
    public int getCertLevel() {
        return this.certLevel;
    }

    @NonNull
    @Generated
    public UserVerificationMethod getModality() {
        return this.modality;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiometricStatusReport)) {
            return false;
        }
        BiometricStatusReport other = (BiometricStatusReport)o;
        if (this.getCertLevel() != other.getCertLevel()) {
            return false;
        }
        UserVerificationMethod this$modality = this.getModality();
        UserVerificationMethod other$modality = other.getModality();
        if (this$modality == null ? other$modality != null : !this$modality.equals(other$modality)) {
            return false;
        }
        Optional<LocalDate> this$effectiveDate = this.getEffectiveDate();
        Optional<LocalDate> other$effectiveDate = other.getEffectiveDate();
        if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
            return false;
        }
        Optional<String> this$certificationDescriptor = this.getCertificationDescriptor();
        Optional<String> other$certificationDescriptor = other.getCertificationDescriptor();
        if (this$certificationDescriptor == null ? other$certificationDescriptor != null : !((Object)this$certificationDescriptor).equals(other$certificationDescriptor)) {
            return false;
        }
        Optional<String> this$certificateNumber = this.getCertificateNumber();
        Optional<String> other$certificateNumber = other.getCertificateNumber();
        if (this$certificateNumber == null ? other$certificateNumber != null : !((Object)this$certificateNumber).equals(other$certificateNumber)) {
            return false;
        }
        Optional<String> this$certificationPolicyVersion = this.getCertificationPolicyVersion();
        Optional<String> other$certificationPolicyVersion = other.getCertificationPolicyVersion();
        if (this$certificationPolicyVersion == null ? other$certificationPolicyVersion != null : !((Object)this$certificationPolicyVersion).equals(other$certificationPolicyVersion)) {
            return false;
        }
        Optional<String> this$certificationRequirementsVersion = this.getCertificationRequirementsVersion();
        Optional<String> other$certificationRequirementsVersion = other.getCertificationRequirementsVersion();
        return !(this$certificationRequirementsVersion == null ? other$certificationRequirementsVersion != null : !((Object)this$certificationRequirementsVersion).equals(other$certificationRequirementsVersion));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCertLevel();
        UserVerificationMethod $modality = this.getModality();
        result = result * 59 + ($modality == null ? 43 : $modality.hashCode());
        Optional<LocalDate> $effectiveDate = this.getEffectiveDate();
        result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
        Optional<String> $certificationDescriptor = this.getCertificationDescriptor();
        result = result * 59 + ($certificationDescriptor == null ? 43 : ((Object)$certificationDescriptor).hashCode());
        Optional<String> $certificateNumber = this.getCertificateNumber();
        result = result * 59 + ($certificateNumber == null ? 43 : ((Object)$certificateNumber).hashCode());
        Optional<String> $certificationPolicyVersion = this.getCertificationPolicyVersion();
        result = result * 59 + ($certificationPolicyVersion == null ? 43 : ((Object)$certificationPolicyVersion).hashCode());
        Optional<String> $certificationRequirementsVersion = this.getCertificationRequirementsVersion();
        result = result * 59 + ($certificationRequirementsVersion == null ? 43 : ((Object)$certificationRequirementsVersion).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BiometricStatusReport(certLevel=" + this.getCertLevel() + ", modality=" + this.getModality() + ", effectiveDate=" + this.getEffectiveDate() + ", certificationDescriptor=" + this.getCertificationDescriptor() + ", certificateNumber=" + this.getCertificateNumber() + ", certificationPolicyVersion=" + this.getCertificationPolicyVersion() + ", certificationRequirementsVersion=" + this.getCertificationRequirementsVersion() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class BiometricStatusReportBuilder {
        @Generated
        private int certLevel;
        @Generated
        private UserVerificationMethod modality;
        @Generated
        private LocalDate effectiveDate;
        @Generated
        private String certificationDescriptor;
        @Generated
        private String certificateNumber;
        @Generated
        private String certificationPolicyVersion;
        @Generated
        private String certificationRequirementsVersion;

        @Generated
        BiometricStatusReportBuilder() {
        }

        @Generated
        public BiometricStatusReportBuilder certLevel(int certLevel) {
            this.certLevel = certLevel;
            return this;
        }

        @Generated
        public BiometricStatusReportBuilder modality(@NonNull UserVerificationMethod modality) {
            if (modality == null) {
                throw new NullPointerException("modality is marked non-null but is null");
            }
            this.modality = modality;
            return this;
        }

        @Generated
        public BiometricStatusReportBuilder effectiveDate(LocalDate effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        @Generated
        public BiometricStatusReportBuilder certificationDescriptor(String certificationDescriptor) {
            this.certificationDescriptor = certificationDescriptor;
            return this;
        }

        @Generated
        public BiometricStatusReportBuilder certificateNumber(String certificateNumber) {
            this.certificateNumber = certificateNumber;
            return this;
        }

        @Generated
        public BiometricStatusReportBuilder certificationPolicyVersion(String certificationPolicyVersion) {
            this.certificationPolicyVersion = certificationPolicyVersion;
            return this;
        }

        @Generated
        public BiometricStatusReportBuilder certificationRequirementsVersion(String certificationRequirementsVersion) {
            this.certificationRequirementsVersion = certificationRequirementsVersion;
            return this;
        }

        @Generated
        public BiometricStatusReport build() {
            return new BiometricStatusReport(this.certLevel, this.modality, this.effectiveDate, this.certificationDescriptor, this.certificateNumber, this.certificationPolicyVersion, this.certificationRequirementsVersion);
        }

        @Generated
        public String toString() {
            return "BiometricStatusReport.BiometricStatusReportBuilder(certLevel=" + this.certLevel + ", modality=" + this.modality + ", effectiveDate=" + this.effectiveDate + ", certificationDescriptor=" + this.certificationDescriptor + ", certificateNumber=" + this.certificateNumber + ", certificationPolicyVersion=" + this.certificationPolicyVersion + ", certificationRequirementsVersion=" + this.certificationRequirementsVersion + ")";
        }
    }
}

