/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.SourceInfo;

@JsonPropertyOrder(value={"module", "source_info"})
public class ConditionMetadata {
    public static final String JSON_PROPERTY_MODULE = "module";
    @Nullable
    private String module;
    public static final String JSON_PROPERTY_SOURCE_INFO = "source_info";
    @Nullable
    private SourceInfo sourceInfo;

    public ConditionMetadata module(@Nullable String module) {
        this.module = module;
        return this;
    }

    @Nullable
    @JsonProperty(value="module", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getModule() {
        return this.module;
    }

    @JsonProperty(value="module", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModule(@Nullable String module) {
        this.module = module;
    }

    public ConditionMetadata sourceInfo(@Nullable SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        return this;
    }

    @Nullable
    @JsonProperty(value="source_info", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @JsonProperty(value="source_info", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceInfo(@Nullable SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionMetadata conditionMetadata = (ConditionMetadata)o;
        return Objects.equals(this.module, conditionMetadata.module) && Objects.equals(this.sourceInfo, conditionMetadata.sourceInfo);
    }

    public int hashCode() {
        return Objects.hash(this.module, this.sourceInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConditionMetadata {\n");
        sb.append("    module: ").append(this.toIndentedString(this.module)).append("\n");
        sb.append("    sourceInfo: ").append(this.toIndentedString(this.sourceInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getModule() != null) {
            joiner.add(String.format(Locale.ROOT, "%smodule%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getModule()))));
        }
        if (this.getSourceInfo() != null) {
            joiner.add(this.getSourceInfo().toUrlQueryString((String)prefix + JSON_PROPERTY_SOURCE_INFO + suffix));
        }
        return joiner.toString();
    }
}

