/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.HashSet;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.ObjectNormalizerFacade;
import org.identityconnectors.framework.impl.api.local.operations.SpiOperationLoggingUtil;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.CreateOp;

public class CreateImpl
extends ConnectorAPIOperationRunner
implements CreateApiOp {
    private static final Log OP_LOG = Log.getLog(CreateOp.class);

    public CreateImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        Uid connectorUid;
        Assertions.nullCheck((Object)objectClass, (String)"objectClass");
        if (ObjectClass.ALL.equals((Object)objectClass)) {
            throw new UnsupportedOperationException("Operation is not allowed on __ALL__ object class");
        }
        Assertions.nullCheck(createAttributes, (String)"createAttributes");
        if (AttributeUtil.getUidAttribute(createAttributes) != null) {
            throw new InvalidAttributeValueException("Parameter 'createAttributes' contains a uid.");
        }
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        HashSet dups = new HashSet();
        createAttributes.forEach(attr -> {
            if (dups.contains(attr.getName())) {
                throw new InvalidAttributeValueException("Duplicate attribute name exists: " + attr.getName());
            }
            dups.add(attr.getName());
        });
        Connector connector = this.getConnector();
        ObjectNormalizerFacade normalizer = this.getNormalizer(objectClass);
        Set<Attribute> normalizedAttributes = normalizer.normalizeAttributes(createAttributes);
        SpiOperationLoggingUtil.logOpEntry(OP_LOG, this.getOperationalContext(), CreateOp.class, "create", objectClass, normalizedAttributes, options);
        try {
            connectorUid = ((CreateOp)connector).create(objectClass, normalizedAttributes, options);
        }
        catch (RuntimeException e) {
            SpiOperationLoggingUtil.logOpException(OP_LOG, this.getOperationalContext(), CreateOp.class, "create", e);
            throw e;
        }
        SpiOperationLoggingUtil.logOpExit(OP_LOG, this.getOperationalContext(), CreateOp.class, "create", connectorUid);
        Uid uid = (Uid)normalizer.normalizeAttribute((Attribute)connectorUid);
        return uid;
    }
}

