/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.syncope.common.lib.RealmMember;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyObjectCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.GroupCR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractResourceAssociator;
import org.apache.syncope.core.logic.api.LogicActions;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.jexl.TemplateUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public abstract class AbstractAnyLogic<TO extends AnyTO, C extends AnyCR, U extends AnyUR>
extends AbstractResourceAssociator<TO> {
    protected static final String REST_CONTEXT = "REST";
    protected final RealmSearchDAO realmSearchDAO;
    protected final AnyTypeDAO anyTypeDAO;
    protected final TemplateUtils templateUtils;
    protected final Map<String, LogicActions> perContextActions = new ConcurrentHashMap<String, LogicActions>();

    public AbstractAnyLogic(RealmSearchDAO realmSearchDAO, AnyTypeDAO anyTypeDAO, TemplateUtils templateUtils) {
        this.realmSearchDAO = realmSearchDAO;
        this.anyTypeDAO = anyTypeDAO;
        this.templateUtils = templateUtils;
    }

    protected List<LogicActions> getActions(Realm realm) {
        ArrayList<LogicActions> result = new ArrayList<LogicActions>();
        realm.getActions().forEach(impl -> {
            try {
                result.add((LogicActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (LogicActions)instance)));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    protected BeforeResult<C> beforeCreate(C input) {
        Realm realm = (Realm)this.realmSearchDAO.findByFullPath(input.getRealm()).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            sce.getElements().add(input.getRealm());
            return sce;
        });
        AnyType anyType = null;
        if (input instanceof UserCR) {
            anyType = this.anyTypeDAO.getUser();
        } else if (input instanceof GroupCR) {
            anyType = this.anyTypeDAO.getGroup();
        } else if (input instanceof AnyObjectCR) {
            AnyObjectCR anyObjectCR = (AnyObjectCR)input;
            anyType = this.anyTypeDAO.findById(anyObjectCR.getType()).orElse(null);
        }
        if (anyType == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            throw sce;
        }
        Object templatedCR = input;
        realm.getTemplate(anyType).ifPresent(template -> this.templateUtils.apply((RealmMember)templatedCR, template.get()));
        Object actionedCR = input;
        List<LogicActions> actions = this.getActions(realm);
        for (LogicActions action : actions) {
            actionedCR = action.beforeCreate(actionedCR);
        }
        LOG.debug("Input: {}\nOutput: {}\n", input, actionedCR);
        return new BeforeResult<C>(actionedCR, actions);
    }

    protected BeforeResult<U> beforeUpdate(U input, String realmPath) {
        Realm realm = (Realm)this.realmSearchDAO.findByFullPath(realmPath).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            sce.getElements().add(realmPath);
            return sce;
        });
        U update = input;
        List<LogicActions> actions = this.getActions(realm);
        for (LogicActions action : actions) {
            update = action.beforeUpdate(update);
        }
        LOG.debug("Input: {}\nOutput: {}\n", input, update);
        return new BeforeResult<U>(update, actions);
    }

    protected BeforeResult<TO> beforeDelete(TO input) {
        Realm realm = (Realm)this.realmSearchDAO.findByFullPath(input.getRealm()).orElseThrow(() -> {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            sce.getElements().add(input.getRealm());
            return sce;
        });
        Object any = input;
        List<LogicActions> actions = this.getActions(realm);
        for (LogicActions action : actions) {
            any = action.beforeDelete(any);
        }
        LOG.debug("Input: {}\nOutput: {}\n", input, any);
        return new BeforeResult<TO>(any, actions);
    }

    protected ProvisioningResult<TO> afterCreate(TO input, List<PropagationStatus> statuses, List<LogicActions> actions) {
        TO any = input;
        for (LogicActions action : actions) {
            any = action.afterCreate(any, statuses);
        }
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity(any);
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    protected ProvisioningResult<TO> afterUpdate(TO input, List<PropagationStatus> statuses, List<LogicActions> actions) {
        TO any = input;
        for (LogicActions action : actions) {
            any = action.afterUpdate(any, statuses);
        }
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity(any);
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    protected ProvisioningResult<TO> afterDelete(TO input, List<PropagationStatus> statuses, List<LogicActions> actions) {
        TO any = input;
        for (LogicActions action : actions) {
            any = action.afterDelete(any, statuses);
        }
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity(any);
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    public abstract TO read(String var1);

    public abstract Page<TO> search(SearchCond var1, Pageable var2, String var3, boolean var4, boolean var5);

    public abstract ProvisioningResult<TO> update(U var1, boolean var2);

    public abstract ProvisioningResult<TO> delete(String var1, boolean var2);

    protected record BeforeResult<T>(T key, List<LogicActions> actions) {
    }
}

