/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.helper.DynamicPropertyUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.util.CommandContextUtil;

public class SkipExpressionUtil {
    public static boolean isSkipExpressionEnabled(String skipExpression, String activityId, DelegateExecution execution, CommandContext commandContext) {
        if (skipExpression == null) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            if (processEngineConfiguration.isEnableProcessDefinitionInfoCache()) {
                ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(activityId, execution.getProcessDefinitionId());
                String overrideSkipExpression = DynamicPropertyUtil.getActiveValue(null, "taskSkipExpression", taskElementProperties);
                if (overrideSkipExpression == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return SkipExpressionUtil.checkSkipExpressionVariable(activityId, execution, commandContext);
    }

    protected static boolean checkSkipExpressionVariable(String activityId, DelegateExecution execution, CommandContext commandContext) {
        ObjectNode globalProperties;
        if (CommandContextUtil.getProcessEngineConfiguration(commandContext).isEnableProcessDefinitionInfoCache() && SkipExpressionUtil.isEnableSkipExpression(globalProperties = BpmnOverrideContext.getBpmnOverrideElementProperties("_flowableGlobalProcessDefinitionProperties", execution.getProcessDefinitionId()))) {
            return true;
        }
        String skipExpressionEnabledVariable = "_ACTIVITI_SKIP_EXPRESSION_ENABLED";
        Object isSkipExpressionEnabled = execution.getVariable(skipExpressionEnabledVariable);
        if (isSkipExpressionEnabled instanceof Boolean) {
            return (Boolean)isSkipExpressionEnabled;
        }
        skipExpressionEnabledVariable = "_FLOWABLE_SKIP_EXPRESSION_ENABLED";
        isSkipExpressionEnabled = execution.getVariable(skipExpressionEnabledVariable);
        if (isSkipExpressionEnabled == null) {
            return false;
        }
        if (isSkipExpressionEnabled instanceof Boolean) {
            return (Boolean)isSkipExpressionEnabled;
        }
        throw new FlowableIllegalArgumentException("Skip expression variable does not resolve to a boolean. " + String.valueOf(isSkipExpressionEnabled));
    }

    public static boolean shouldSkipFlowElement(String skipExpressionString, String activityId, DelegateExecution execution, CommandContext commandContext) {
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager();
        Expression skipExpression = expressionManager.createExpression(SkipExpressionUtil.resolveActiveSkipExpression(skipExpressionString, activityId, execution.getProcessDefinitionId(), commandContext));
        Object value = skipExpression.getValue((VariableContainer)execution);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new FlowableIllegalArgumentException("Skip expression does not resolve to a boolean: " + skipExpression.getExpressionText());
    }

    protected static boolean isEnableSkipExpression(ObjectNode globalProperties) {
        JsonNode overrideValueNode;
        return globalProperties != null && (overrideValueNode = globalProperties.get("enableSkipExpression")) != null && !overrideValueNode.isNull() && "true".equalsIgnoreCase(overrideValueNode.asText());
    }

    protected static String resolveActiveSkipExpression(String skipExpression, String activityId, String processDefinitionId, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        String activeTaskSkipExpression = null;
        if (processEngineConfiguration.isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = BpmnOverrideContext.getBpmnOverrideElementProperties(activityId, processDefinitionId);
            activeTaskSkipExpression = DynamicPropertyUtil.getActiveValue(skipExpression, "taskSkipExpression", taskElementProperties);
        } else {
            activeTaskSkipExpression = skipExpression;
        }
        return activeTaskSkipExpression;
    }
}

