/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.metrics.KafkaConsumerMetrics;
import org.apache.kafka.common.metrics.Metrics;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KafkaConsumerMetricsTest {
    private static final long METRIC_VALUE = 123L;
    private static final String CONSUMER_GROUP_PREFIX = "consumer";
    private static final String CONSUMER_METRIC_GROUP = "consumer-metrics";
    private static final String COMMIT_SYNC_TIME_TOTAL = "commit-sync-time-ns-total";
    private static final String COMMITTED_TIME_TOTAL = "committed-time-ns-total";
    private final Metrics metrics = new Metrics();
    private final KafkaConsumerMetrics consumerMetrics = new KafkaConsumerMetrics(this.metrics, "consumer");

    KafkaConsumerMetricsTest() {
    }

    @Test
    public void shouldRecordCommitSyncTime() {
        this.consumerMetrics.recordCommitSync(123L);
        this.assertMetricValue(COMMIT_SYNC_TIME_TOTAL);
    }

    @Test
    public void shouldRecordCommittedTime() {
        this.consumerMetrics.recordCommitted(123L);
        this.assertMetricValue(COMMITTED_TIME_TOTAL);
    }

    @Test
    public void shouldRemoveMetricsOnClose() {
        this.consumerMetrics.close();
        this.assertMetricRemoved(COMMIT_SYNC_TIME_TOTAL);
        this.assertMetricRemoved(COMMITTED_TIME_TOTAL);
    }

    private void assertMetricRemoved(String name) {
        Assertions.assertNull((Object)this.metrics.metric(this.metrics.metricName(name, CONSUMER_METRIC_GROUP)));
    }

    private void assertMetricValue(String name) {
        Assertions.assertEquals((Object)this.metrics.metric(this.metrics.metricName(name, CONSUMER_METRIC_GROUP)).metricValue(), (Object)123.0);
    }
}

