/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.redirect;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.oauth.AuthorizationUrlBuilder;
import com.github.scribejava.core.oauth.OAuth20Service;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20RedirectionActionBuilder
implements RedirectionActionBuilder {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20RedirectionActionBuilder.class);
    protected OAuth20Configuration configuration;
    protected IndirectClient client;

    public OAuth20RedirectionActionBuilder(OAuth20Configuration configuration, IndirectClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)client);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<RedirectionAction> getRedirectionAction(CallContext ctx) {
        WebContext webContext = ctx.webContext();
        try {
            String state;
            if (this.configuration.isWithState()) {
                state = this.configuration.getStateGenerator().generateValue(ctx);
                LOGGER.debug("save sessionState: {}", (Object)state);
                ctx.sessionStore().set(webContext, this.client.getStateSessionAttributeName(), (Object)state);
            } else {
                state = null;
            }
            OAuth20Service service = (OAuth20Service)this.configuration.buildService(webContext, this.client);
            String authorizationUrl = new AuthorizationUrlBuilder(service).state(state).additionalParams(this.configuration.getCustomParams()).build();
            LOGGER.debug("authorizationUrl: {}", (Object)authorizationUrl);
            return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)authorizationUrl));
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }
}

