/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.authentication.principal.DefaultWebApplicationResponseBuilderLocator;
import org.apereo.cas.authentication.principal.PersistentIdGenerator;
import org.apereo.cas.authentication.principal.ResponseBuilder;
import org.apereo.cas.authentication.principal.ResponseBuilderLocator;
import org.apereo.cas.authentication.principal.ShibbolethCompatiblePersistentIdGenerator;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.authentication.principal.WebApplicationServiceResponseBuilder;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.cache.SimpleCacheProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.services.ChainingServiceRegistry;
import org.apereo.cas.services.ChainingServicesManager;
import org.apereo.cas.services.DefaultChainingServiceRegistry;
import org.apereo.cas.services.DefaultRegisteredServicePrincipalAccessStrategyEnforcer;
import org.apereo.cas.services.DefaultRegisteredServicesEventListener;
import org.apereo.cas.services.DefaultRegisteredServicesTemplatesManager;
import org.apereo.cas.services.DefaultServiceRegistryExecutionPlan;
import org.apereo.cas.services.DefaultServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.GroovyRegisteredServiceAccessStrategyEnforcer;
import org.apereo.cas.services.ImmutableServiceRegistry;
import org.apereo.cas.services.InMemoryServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyAuditableEnforcer;
import org.apereo.cas.services.RegisteredServiceAccessStrategyEnforcer;
import org.apereo.cas.services.RegisteredServiceCipherExecutor;
import org.apereo.cas.services.RegisteredServicePrincipalAccessStrategyEnforcer;
import org.apereo.cas.services.RegisteredServicePublicKeyCipherExecutor;
import org.apereo.cas.services.RegisteredServicesEventListener;
import org.apereo.cas.services.RegisteredServicesTemplatesManager;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlan;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.ServicesManagerConfigurationContext;
import org.apereo.cas.services.ServicesManagerExecutionPlanConfigurer;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.ServicesManagerScheduledLoader;
import org.apereo.cas.services.mgmt.DefaultChainingServicesManager;
import org.apereo.cas.services.mgmt.DefaultServicesManager;
import org.apereo.cas.services.replication.NoOpRegisteredServiceReplicationStrategy;
import org.apereo.cas.services.replication.RegisteredServiceReplicationStrategy;
import org.apereo.cas.services.resource.DefaultRegisteredServiceResourceNamingStrategy;
import org.apereo.cas.services.resource.RegisteredServiceResourceNamingStrategy;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import org.apereo.cas.util.serialization.StringSerializer;
import org.apereo.cas.util.spring.CasApplicationReadyListener;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.util.spring.boot.ConditionalOnMissingGraalVMNativeImage;
import org.apereo.cas.web.UrlValidator;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableAsync(proxyTargetClass=false)
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.ServiceRegistry})
@Configuration(value="CasCoreServicesConfiguration", proxyBeanMethods=false)
class CasCoreServicesConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreServicesConfiguration.class);

    CasCoreServicesConfiguration() {
    }

    @Configuration(value="CasCoreServicesSchedulingConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    @AutoConfigureAfter(value={CasCoreServicesManagerConfiguration.class, CasCoreServiceRegistryConfiguration.class})
    static class CasCoreServicesSchedulingConfiguration {
        CasCoreServicesSchedulingConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public Runnable servicesManagerScheduledLoader(ConfigurableApplicationContext applicationContext, @Qualifier(value="serviceRegistryExecutionPlan") ServiceRegistryExecutionPlan serviceRegistryExecutionPlan, CasConfigurationProperties casProperties, @Qualifier(value="servicesManager") ServicesManager servicesManager) {
            return (Runnable)BeanSupplier.of(Runnable.class).when(BeanCondition.on((String)"cas.service-registry.schedule.enabled").isTrue().evenIfMissing().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                com.google.common.base.Predicate filter = Predicates.not((com.google.common.base.Predicate)Predicates.instanceOf(ImmutableServiceRegistry.class));
                if (!serviceRegistryExecutionPlan.find((Predicate)filter).isEmpty()) {
                    LOGGER.trace("Background task to load services is enabled to run every [{}]", (Object)casProperties.getServiceRegistry().getSchedule().getRepeatInterval());
                    return new ServicesManagerScheduledLoader(servicesManager);
                }
                LOGGER.trace("Background task to load services is disabled");
                return ServicesManagerScheduledLoader.noOp();
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreServicesManagerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureAfter(value={CasCoreServiceRegistryConfiguration.class})
    static class CasCoreServicesManagerConfiguration {
        CasCoreServicesManagerConfiguration() {
        }

        @ConditionalOnMissingBean(name={"registeredServicesTemplatesManager"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RegisteredServicesTemplatesManager registeredServicesTemplatesManager(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (RegisteredServicesTemplatesManager)BeanSupplier.of(RegisteredServicesTemplatesManager.class).when(BeanCondition.on((String)"cas.service-registry.templates.directory.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                RegisteredServiceJsonSerializer registeredServiceSerializer = new RegisteredServiceJsonSerializer(applicationContext);
                return new DefaultRegisteredServicesTemplatesManager(casProperties.getServiceRegistry(), (StringSerializer)registeredServiceSerializer);
            }).otherwise(RegisteredServicesTemplatesManager::noOp).get();
        }

        @ConditionalOnMissingBean(name={"servicesManager"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ChainingServicesManager servicesManager(List<ServicesManagerExecutionPlanConfigurer> configurers) {
            DefaultChainingServicesManager chain = new DefaultChainingServicesManager();
            AnnotationAwareOrderComparator.sortIfNecessary(configurers);
            configurers.forEach(cfg -> chain.registerServiceManager(cfg.configureServicesManager()));
            return chain;
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"servicesManagerCache"})
        public Cache<Long, RegisteredService> servicesManagerCache(CasConfigurationProperties casProperties) {
            return Beans.newCacheBuilder((SimpleCacheProperties)casProperties.getServiceRegistry().getCache()).build();
        }

        @Bean
        @Lazy(value=false)
        public CasApplicationReadyListener servicesManagerApplicationReady(@Qualifier(value="servicesManager") ChainingServicesManager servicesManager, CasConfigurationProperties casProperties) {
            return event -> servicesManager.load();
        }
    }

    @Configuration(value="CasCoreServicesManagerExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreServicesManagerExecutionPlanConfiguration {
        CasCoreServicesManagerExecutionPlanConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServicesManagerConfigurationContext servicesManagerConfigurationContext(@Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, CasConfigurationProperties casProperties, @Qualifier(value="registeredServicesTemplatesManager") RegisteredServicesTemplatesManager registeredServicesTemplatesManager, @Qualifier(value="serviceRegistry") ChainingServiceRegistry serviceRegistry, @Qualifier(value="servicesManagerCache") Cache<Long, RegisteredService> servicesManagerCache, List<ServicesManagerRegisteredServiceLocator> servicesManagerRegisteredServiceLocators, Environment environment, ConfigurableApplicationContext applicationContext) {
            AnnotationAwareOrderComparator.sortIfNecessary(servicesManagerRegisteredServiceLocators);
            Set activeProfiles = Arrays.stream(environment.getActiveProfiles()).collect(Collectors.toSet());
            return ServicesManagerConfigurationContext.builder().serviceRegistry((ServiceRegistry)serviceRegistry).applicationContext(applicationContext).environments(activeProfiles).servicesCache(servicesManagerCache).registeredServicesTemplatesManager(registeredServicesTemplatesManager).registeredServiceLocators(servicesManagerRegisteredServiceLocators).casProperties(casProperties).tenantExtractor(tenantExtractor).build();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultServicesManagerExecutionPlanConfigurer"})
        public ServicesManagerExecutionPlanConfigurer defaultServicesManagerExecutionPlanConfigurer(CasConfigurationProperties casProperties, @Qualifier(value="servicesManagerConfigurationContext") ServicesManagerConfigurationContext configurationContext) {
            return () -> new DefaultServicesManager(configurationContext);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultServicesManagerRegisteredServiceLocator"})
        public ServicesManagerRegisteredServiceLocator defaultServicesManagerRegisteredServiceLocator() {
            return new DefaultServicesManagerRegisteredServiceLocator();
        }
    }

    @Configuration(value="CasCoreServiceRegistryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreServiceRegistryConfiguration {
        CasCoreServiceRegistryConfiguration() {
        }

        private static Optional<List<RegisteredService>> getInMemoryRegisteredServices(ApplicationContext applicationContext) {
            if (applicationContext.containsBean("inMemoryRegisteredServices")) {
                return Optional.of((List)applicationContext.getBean("inMemoryRegisteredServices", List.class));
            }
            return Optional.empty();
        }

        @ConditionalOnMissingBean(name={"serviceRegistry"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ChainingServiceRegistry serviceRegistry(ConfigurableApplicationContext applicationContext, ObjectProvider<List<ServiceRegistryListener>> serviceRegistryListeners, @Qualifier(value="serviceRegistryExecutionPlan") ServiceRegistryExecutionPlan serviceRegistryExecutionPlan) {
            com.google.common.base.Predicate filter = Predicates.not((com.google.common.base.Predicate)Predicates.instanceOf(ImmutableServiceRegistry.class));
            DefaultChainingServiceRegistry chainingRegistry = new DefaultChainingServiceRegistry(applicationContext);
            if (serviceRegistryExecutionPlan.find((Predicate)filter).isEmpty()) {
                LOGGER.info("Runtime memory is used as the persistence storage for retrieving and persisting service definitions. Changes that are made to service definitions during runtime WILL be LOST when the CAS server is restarted. Ideally for production, you should choose a storage option (JSON, JDBC, MongoDb, etc) to track service definitions.");
                List services = CasCoreServiceRegistryConfiguration.getInMemoryRegisteredServices((ApplicationContext)applicationContext).orElseGet(ArrayList::new);
                InMemoryServiceRegistry inMemoryServiceRegistry = new InMemoryServiceRegistry(applicationContext, services, (Collection)Optional.ofNullable((List)serviceRegistryListeners.getIfAvailable()).orElseGet(ArrayList::new));
                chainingRegistry.addServiceRegistry((ServiceRegistry)inMemoryServiceRegistry);
            }
            chainingRegistry.addServiceRegistries(serviceRegistryExecutionPlan.getServiceRegistries());
            return chainingRegistry;
        }
    }

    @Configuration(value="CasCoreServicesListenerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreServicesListenerConfiguration {
        CasCoreServicesListenerConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"defaultServiceRegistryListener"})
        public ServiceRegistryListener defaultServiceRegistryListener() {
            return ServiceRegistryListener.noOp();
        }
    }

    @Configuration(value="CasCoreServiceRegistryPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreServiceRegistryPlanConfiguration {
        CasCoreServiceRegistryPlanConfiguration() {
        }

        @ConditionalOnMissingBean(name={"serviceRegistryExecutionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceRegistryExecutionPlan serviceRegistryExecutionPlan(ObjectProvider<List<ServiceRegistryExecutionPlanConfigurer>> provider) {
            DefaultServiceRegistryExecutionPlan plan = new DefaultServiceRegistryExecutionPlan();
            provider.ifAvailable(configurers -> configurers.stream().filter(BeanSupplier::isNotProxy).forEach(Unchecked.consumer(c -> {
                LOGGER.trace("Configuring service registry [{}]", (Object)c.getName());
                c.configureServiceRegistry((ServiceRegistryExecutionPlan)plan);
            })));
            return plan;
        }
    }

    @Configuration(value="CasCoreServicesStrategyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreServicesStrategyConfiguration {
        CasCoreServicesStrategyConfiguration() {
        }

        @ConditionalOnMissingBean(name={"registeredServiceReplicationStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RegisteredServiceReplicationStrategy registeredServiceReplicationStrategy() {
            return new NoOpRegisteredServiceReplicationStrategy();
        }

        @ConditionalOnMissingBean(name={"registeredServiceResourceNamingStrategy"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RegisteredServiceResourceNamingStrategy registeredServiceResourceNamingStrategy() {
            return new DefaultRegisteredServiceResourceNamingStrategy();
        }
    }

    @Configuration(value="CasCoreServicesBaseConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreServicesBaseConfiguration {
        CasCoreServicesBaseConfiguration() {
        }

        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"shibbolethCompatiblePersistentIdGenerator"})
        public PersistentIdGenerator shibbolethCompatiblePersistentIdGenerator() {
            return new ShibbolethCompatiblePersistentIdGenerator();
        }

        @ConditionalOnMissingBean(name={"registeredServiceCipherExecutor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RegisteredServiceCipherExecutor registeredServiceCipherExecutor() {
            return new RegisteredServicePublicKeyCipherExecutor();
        }

        @ConditionalOnMissingBean(name={"registeredServiceAccessStrategyEnforcer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditableExecution registeredServiceAccessStrategyEnforcer(@Qualifier(value="principalAccessStrategyEnforcer") RegisteredServicePrincipalAccessStrategyEnforcer principalAccessStrategyEnforcer, ConfigurableApplicationContext applicationContext) {
            return new RegisteredServiceAccessStrategyAuditableEnforcer(applicationContext, principalAccessStrategyEnforcer);
        }

        @ConditionalOnMissingBean(name={"principalAccessStrategyEnforcer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public RegisteredServicePrincipalAccessStrategyEnforcer principalAccessStrategyEnforcer(ConfigurableApplicationContext applicationContext) {
            return new DefaultRegisteredServicePrincipalAccessStrategyEnforcer((ApplicationContext)applicationContext);
        }

        @ConditionalOnMissingBean(name={"groovyRegisteredServiceAccessStrategyEnforcer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingGraalVMNativeImage
        public RegisteredServiceAccessStrategyEnforcer groovyRegisteredServiceAccessStrategyEnforcer(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return (RegisteredServiceAccessStrategyEnforcer)BeanSupplier.of(RegisteredServiceAccessStrategyEnforcer.class).when(BeanCondition.on((String)"cas.access-strategy.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                Resource location = casProperties.getAccessStrategy().getGroovy().getLocation();
                ExecutableCompiledScriptFactory scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
                return new GroovyRegisteredServiceAccessStrategyEnforcer(scriptFactory.fromResource(location));
            }).otherwiseProxy().get();
        }
    }

    @Configuration(value="CasCoreServicesResponseBuilderConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreServicesResponseBuilderConfiguration {
        CasCoreServicesResponseBuilderConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"webApplicationServiceResponseBuilder"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ResponseBuilder<WebApplicationService> webApplicationServiceResponseBuilder(@Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="urlValidator") UrlValidator urlValidator) {
            return new WebApplicationServiceResponseBuilder(servicesManager, urlValidator);
        }
    }

    @Configuration(value="CasCoreServicesEventsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    static class CasCoreServicesEventsConfiguration {
        CasCoreServicesEventsConfiguration() {
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Lazy(value=false)
        public RegisteredServicesEventListener registeredServicesEventListener(CasConfigurationProperties casProperties, @Qualifier(value="tenantExtractor") TenantExtractor tenantExtractor, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="communicationsManager") CommunicationsManager communicationsManager) {
            return new DefaultRegisteredServicesEventListener(servicesManager, casProperties, communicationsManager, tenantExtractor);
        }
    }

    @Configuration(value="CasCoreServicesResponseLocatorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    static class CasCoreServicesResponseLocatorConfiguration {
        CasCoreServicesResponseLocatorConfiguration() {
        }

        @ConditionalOnMissingBean(name={"webApplicationResponseBuilderLocator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ResponseBuilderLocator webApplicationResponseBuilderLocator(List<ResponseBuilder> responseBuilders) {
            AnnotationAwareOrderComparator.sortIfNecessary(responseBuilders);
            return new DefaultWebApplicationResponseBuilderLocator(responseBuilders);
        }
    }
}

