/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.otp.repository.credentials;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;

public abstract class BaseOneTimeTokenCredentialRepository
implements OneTimeTokenCredentialRepository {
    private final CipherExecutor<String, String> tokenCredentialCipher;
    private final CipherExecutor<Number, Number> scratchCodesCipher;

    protected OneTimeTokenAccount encode(OneTimeTokenAccount account) {
        account.setSecretKey((String)this.tokenCredentialCipher.encode((Object)account.getSecretKey()));
        account.setScratchCodes(account.getScratchCodes().stream().map(arg_0 -> this.scratchCodesCipher.encode(arg_0)).collect(Collectors.toList()));
        account.setUsername(account.getUsername().trim().toLowerCase(Locale.ENGLISH));
        return account;
    }

    protected Collection<? extends OneTimeTokenAccount> decode(Collection<? extends OneTimeTokenAccount> account) {
        return account.stream().map(this::decode).collect(Collectors.toList());
    }

    protected OneTimeTokenAccount decode(OneTimeTokenAccount account) {
        String decodedSecret = (String)this.tokenCredentialCipher.decode((Object)account.getSecretKey());
        List decodedScratchCodes = account.getScratchCodes().stream().map(code -> (Number)FunctionUtils.doAndHandle(() -> (Number)this.scratchCodesCipher.decode(code), t -> code).get()).collect(Collectors.toList());
        OneTimeTokenAccount newAccount = account.clone();
        newAccount.setSecretKey(decodedSecret);
        newAccount.setScratchCodes(decodedScratchCodes);
        return newAccount;
    }

    @Generated
    protected BaseOneTimeTokenCredentialRepository(CipherExecutor<String, String> tokenCredentialCipher, CipherExecutor<Number, Number> scratchCodesCipher) {
        this.tokenCredentialCipher = tokenCredentialCipher;
        this.scratchCodesCipher = scratchCodesCipher;
    }
}

