/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.core.persistence.api.EncryptorManager;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.JWTAuthentication;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.security.authentication.AuthenticationCredentialsNotFoundException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.Authentication;

public class InstrumentedAuthDataAccessor
extends AuthDataAccessor {
    protected static final String SUCCESS_TYPE = ".success";
    protected static final String FAILURE_TYPE = ".failure";
    protected static final String MUST_CHANGE_PASSWORD_TYPE = ".failure";
    protected static final String NOT_FOUND_TYPE = ".notfound";
    protected static final String DISABLED_TYPE = ".disabled";
    protected static final Function<String, String> USERNAME = suffix -> "syncope.auth.username" + suffix + ".count";
    protected static final Function<String, String> JWT = suffix -> "syncope.auth.jwt" + suffix + ".count";
    protected static final Function<String, String> SUCCESS_DESC = type -> "The total number of succeeded " + type + " logins";
    protected static final Function<String, String> FAILURE_DESC = type -> "The total number of failed " + type + " logins";
    protected static final Function<String, String> MUST_CHANGE_PASSWORD_DESC = type -> "The total number of mustChangePassword users attempting to perform " + type + " login";
    protected static final Function<String, String> NOT_FOUND_DESC = type -> "The total number of not found users attempting to perform " + type + " login";
    protected static final Function<String, String> DISABLED_DESC = type -> "The total number of disabled users attempting to perform " + type + " login";
    protected final MeterRegistry meterRegistry;

    public InstrumentedAuthDataAccessor(SecurityProperties securityProperties, EncryptorManager encryptorManager, RealmSearchDAO realmSearchDAO, UserDAO userDAO, GroupDAO groupDAO, AnySearchDAO anySearchDAO, AccessTokenDAO accessTokenDAO, ConfParamOps confParamOps, RoleDAO roleDAO, DelegationDAO delegationDAO, ExternalResourceDAO resourceDAO, ConnectorManager connectorManager, AuditManager auditManager, MappingManager mappingManager, List<JWTSSOProvider> jwtSSOProviders, MeterRegistry meterRegistry) {
        super(securityProperties, encryptorManager, realmSearchDAO, userDAO, groupDAO, anySearchDAO, accessTokenDAO, confParamOps, roleDAO, delegationDAO, resourceDAO, connectorManager, auditManager, mappingManager, jwtSSOProviders);
        this.meterRegistry = meterRegistry;
    }

    public AuthDataAccessor.UsernamePasswordAuthResult authenticate(String domain, Authentication authentication) {
        try {
            AuthDataAccessor.UsernamePasswordAuthResult result = super.authenticate(domain, authentication);
            Optional.ofNullable(result.user()).ifPresentOrElse(user -> {
                Counter.builder((String)(result.authenticated() != false ? USERNAME.apply(SUCCESS_TYPE) : USERNAME.apply(".failure"))).description(result.authenticated() != false ? SUCCESS_DESC.apply("username") : FAILURE_DESC.apply("username")).tag("realm", user.getRealm().getFullPath()).register(this.meterRegistry).increment();
                if (user.isMustChangePassword()) {
                    Counter.builder((String)USERNAME.apply(".failure")).description(MUST_CHANGE_PASSWORD_DESC.apply("username")).register(this.meterRegistry).increment();
                }
            }, () -> Counter.builder((String)USERNAME.apply(NOT_FOUND_TYPE)).description(NOT_FOUND_DESC.apply("username")).register(this.meterRegistry).increment());
            return result;
        }
        catch (DisabledException e) {
            Counter.builder((String)USERNAME.apply(DISABLED_TYPE)).description(DISABLED_DESC.apply("JWT")).register(this.meterRegistry).increment();
            throw e;
        }
    }

    public AuthDataAccessor.JWTAuthResult authenticate(JWTAuthentication authentication) {
        try {
            AuthDataAccessor.JWTAuthResult result = super.authenticate(authentication);
            if (MUST_CHANGE_PASSWORD_AUTHORITIES.equals(result.authorities())) {
                Counter.builder((String)JWT.apply(".failure")).description(MUST_CHANGE_PASSWORD_DESC.apply("JWT")).register(this.meterRegistry).increment();
            } else {
                Counter.builder((String)JWT.apply(SUCCESS_TYPE)).description(SUCCESS_DESC.apply("JWT")).register(this.meterRegistry).increment();
            }
            return result;
        }
        catch (AuthenticationCredentialsNotFoundException e) {
            Counter.builder((String)JWT.apply(NOT_FOUND_TYPE)).description(NOT_FOUND_DESC.apply("JWT")).register(this.meterRegistry).increment();
            throw e;
        }
        catch (DisabledException e) {
            Counter.builder((String)JWT.apply(DISABLED_TYPE)).description(DISABLED_DESC.apply("JWT")).register(this.meterRegistry).increment();
            throw e;
        }
    }
}

