/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.contentstream.operator.markedcontent;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.MissingOperandException;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import org.apache.pdfbox.text.PDFMarkedContentExtractor;

public class DrawObject
extends OperatorProcessor {
    private static final Log LOG = LogFactory.getLog(DrawObject.class);

    public DrawObject(PDFStreamEngine context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Operator operator, List<COSBase> arguments) throws IOException {
        if (arguments.isEmpty()) {
            throw new MissingOperandException(operator, arguments);
        }
        COSBase base0 = arguments.get(0);
        if (!(base0 instanceof COSName)) {
            return;
        }
        COSName name = (COSName)base0;
        PDFStreamEngine context = this.getContext();
        PDXObject xobject = context.getResources().getXObject(name);
        ((PDFMarkedContentExtractor)context).xobject(xobject);
        if (xobject instanceof PDFormXObject) {
            try {
                context.increaseLevel();
                if (context.getLevel() > 50) {
                    LOG.error((Object)"recursion is too deep, skipping form XObject");
                    return;
                }
                if (xobject instanceof PDTransparencyGroup) {
                    context.showTransparencyGroup((PDTransparencyGroup)xobject);
                } else {
                    context.showForm((PDFormXObject)xobject);
                }
            }
            finally {
                context.decreaseLevel();
            }
        }
    }

    @Override
    public String getName() {
        return "Do";
    }
}

