/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup.modify;

import java.util.Optional;
import java.util.Set;
import net.tirasa.connid.bundles.ldup.LdUpUtils;
import net.tirasa.connid.bundles.ldup.modify.AbstractLdUpModifyOp;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.ldaptive.AddOperation;
import org.ldaptive.AddRequest;
import org.ldaptive.AttributeModification;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.handler.ResultPredicate;

public class LdUpCreateOp
extends AbstractLdUpModifyOp
implements CreateOp {
    protected static final Log LOG = Log.getLog(LdUpCreateOp.class);

    public LdUpCreateOp(LdUpUtils ldUpUtils) {
        super(ldUpUtils);
    }

    public Uid create(ObjectClass objectClass, Set<Attribute> createAttributes, OperationOptions options) {
        Uid uid;
        Name name = Optional.ofNullable(AttributeUtil.getNameFromAttributes(createAttributes)).orElseThrow(() -> new IllegalArgumentException("No Name attribute provided in the attributes"));
        AbstractLdUpModifyOp.ProcessResult result = this.process(objectClass, createAttributes);
        result.ldapAttrs.add(new LdapAttribute("objectClass", new String[]{this.ldUpUtils.ldapObjectClass(objectClass)}));
        try {
            ((AddOperation)((AddOperation.Builder)((AddOperation.Builder)AddOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute((AddRequest)AddRequest.builder().dn(name.getNameValue()).attributes(result.ldapAttrs).build());
            SearchResponse response = ((SearchOperation)((SearchOperation.Builder)((SearchOperation.Builder)SearchOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute(SearchRequest.objectScopeSearchRequest((String)name.getNameValue(), (String[])new String[]{this.ldUpUtils.getIdAttribute(objectClass)}));
            uid = new Uid(response.getEntry().getAttribute(this.ldUpUtils.getIdAttribute(objectClass)).getStringValue());
        }
        catch (LdapException e) {
            throw new ConnectorException("Create error", (Throwable)e);
        }
        if (this.ldUpUtils.isAccount(objectClass)) {
            this.setPassword(name.getNameValue(), result.passwordValue);
            this.groupMod(name.getNameValue(), result.groups, AttributeModification.Type.ADD);
        }
        return uid;
    }
}

