/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.issuer;

import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredServiceDefinition;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcDefaultIssuerService
implements OidcIssuerService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcDefaultIssuerService.class);
    protected final OidcProperties properties;
    protected final TenantExtractor tenantExtractor;

    @Override
    public String determineIssuer(Optional<OidcRegisteredService> registeredService) {
        String issuer = registeredService.filter(svc -> StringUtils.isNotBlank((CharSequence)svc.getIdTokenIssuer())).map(OidcRegisteredService::getIdTokenIssuer).orElseGet(() -> this.properties.getCore().getIssuer());
        LOGGER.trace("Determined issuer as [{}] for [{}]", (Object)issuer, (Object)registeredService.map(RegisteredServiceDefinition::getName).orElse("CAS"));
        return StringUtils.removeEnd((String)issuer, (String)"/");
    }

    @Override
    public boolean validateIssuer(WebContext webContext, String endpoint) {
        String requestUrl = webContext.getRequestURL();
        String issuerFromRequestUrl = StringUtils.removeEnd((String)StringUtils.remove((String)requestUrl, (String)("/" + endpoint)), (String)"/");
        String definedIssuer = this.determineIssuer(Optional.empty());
        String definedIssuerWithSlash = StringUtils.appendIfMissing((String)definedIssuer, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        boolean result = definedIssuer.equalsIgnoreCase(issuerFromRequestUrl) || issuerFromRequestUrl.startsWith(definedIssuerWithSlash) || RegexUtils.find((String)this.properties.getCore().getAcceptedIssuersPattern(), (String)issuerFromRequestUrl);
        FunctionUtils.doIf((!result ? 1 : 0) != 0, o -> LOGGER.trace("Configured issuer [{}] defined does not match the request issuer [{}]", o, (Object)issuerFromRequestUrl)).accept(definedIssuer);
        return result;
    }

    @Generated
    public OidcDefaultIssuerService(OidcProperties properties, TenantExtractor tenantExtractor) {
        this.properties = properties;
        this.tenantExtractor = tenantExtractor;
    }
}

