/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.okta;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserProfile;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.BasePersonAttributeDao;
import org.apereo.cas.authentication.attribute.SimplePersonAttributes;
import org.apereo.cas.authentication.attribute.SimpleUsernameAttributeProvider;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDao;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.apereo.cas.util.function.FunctionUtils;

public class OktaPersonAttributeDao
extends BasePersonAttributeDao {
    private UsernameAttributeProvider usernameAttributeProvider = new SimpleUsernameAttributeProvider();
    private final Client oktaClient;

    public PersonAttributes getPerson(String uid, Set<PersonAttributes> resolvedPeople, PersonAttributeDaoFilter filter) {
        HashMap attributes = new HashMap();
        User user = this.oktaClient.getUser(uid);
        FunctionUtils.doIfNotNull((Object)user.getActivated(), attribute -> attributes.put("oktaUserActivatedDate", user.getActivated().getTime()));
        FunctionUtils.doIfNotNull((Object)user.getCreated(), attribute -> attributes.put("oktaUserCreatedDate", user.getCreated().getTime()));
        FunctionUtils.doIfNotNull((Object)user.getLastLogin(), attribute -> attributes.put("oktaUserLastLoginDate", user.getLastLogin().getTime()));
        FunctionUtils.doIfNotNull((Object)user.getLastUpdated(), attribute -> attributes.put("oktaUserLastUpdatedDate", user.getLastUpdated().getTime()));
        FunctionUtils.doIfNotNull((Object)user.getPasswordChanged(), attribute -> attributes.put("oktaUserPasswordChangedDate", user.getPasswordChanged().getTime()));
        FunctionUtils.doIfNotNull((Object)user.getId(), attribute -> attributes.put("oktaUserId", attribute));
        FunctionUtils.doIfNotNull((Object)user.getStatus(), attribute -> attributes.put("oktaUserStatus", attribute.toString()));
        FunctionUtils.doIfNotNull((Object)user.getType(), attribute -> attributes.put("oktaUserType", attribute));
        UserProfile profile = user.getProfile();
        FunctionUtils.doIfNotNull((Object)profile.getCity(), attribute -> attributes.put("oktaCity", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getCostCenter(), attribute -> attributes.put("oktaCostCenter", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getCountryCode(), attribute -> attributes.put("oktaCountryCode", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getDepartment(), attribute -> attributes.put("oktaDepartment", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getDisplayName(), attribute -> attributes.put("oktaDisplayName", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getDivision(), attribute -> attributes.put("oktaDivision", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getEmail(), attribute -> attributes.put("oktaEmail", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getEmployeeNumber(), attribute -> attributes.put("oktaEmployeeNumber", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getFirstName(), attribute -> attributes.put("oktaFirstName", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getHonorificPrefix(), attribute -> attributes.put("oktaPrefix", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getHonorificSuffix(), attribute -> attributes.put("oktaSuffix", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getLastName(), attribute -> attributes.put("oktaLastName", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getLocale(), attribute -> attributes.put("oktaLocale", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getManager(), attribute -> attributes.put("oktaManager", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getManagerId(), attribute -> attributes.put("oktaManagerId", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getMiddleName(), attribute -> attributes.put("oktaMiddleName", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getMobilePhone(), attribute -> attributes.put("oktaMobilePhone", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getNickName(), attribute -> attributes.put("oktaNickName", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getOrganization(), attribute -> attributes.put("oktaOrganization", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getPostalAddress(), attribute -> attributes.put("oktaPostalAddress", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getPreferredLanguage(), attribute -> attributes.put("oktaPreferredLanguage", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getPrimaryPhone(), attribute -> attributes.put("oktaPrimaryPhone", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getSecondEmail(), attribute -> attributes.put("oktaSecondEmail", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getState(), attribute -> attributes.put("oktaState", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getStreetAddress(), attribute -> attributes.put("oktaStreetAddress", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getTimezone(), attribute -> attributes.put("oktaTimezone", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getTitle(), attribute -> attributes.put("oktaTitle", attribute));
        FunctionUtils.doIfNotNull((Object)profile.getLogin(), attribute -> attributes.put("oktaLogin", attribute));
        return new SimplePersonAttributes(uid, PersonAttributeDao.stuffAttributesIntoList(attributes));
    }

    public Set<PersonAttributes> getPeople(Map<String, Object> map, PersonAttributeDaoFilter filter, Set<PersonAttributes> resolvedPeople) {
        return this.getPeopleWithMultivaluedAttributes(PersonAttributeDao.stuffAttributesIntoList(map), filter);
    }

    public Set<PersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> map, PersonAttributeDaoFilter filter, Set<PersonAttributes> resolvedPeople) {
        LinkedHashSet<PersonAttributes> people = new LinkedHashSet<PersonAttributes>();
        String username = this.usernameAttributeProvider.getUsernameFromQuery(map);
        PersonAttributes person = this.getPerson(username, resolvedPeople, filter);
        if (person != null) {
            people.add(person);
        }
        return people;
    }

    @Generated
    public OktaPersonAttributeDao(Client oktaClient) {
        this.oktaClient = oktaClient;
    }

    @Generated
    public UsernameAttributeProvider getUsernameAttributeProvider() {
        return this.usernameAttributeProvider;
    }

    @Generated
    public Client getOktaClient() {
        return this.oktaClient;
    }

    @Generated
    public void setUsernameAttributeProvider(UsernameAttributeProvider usernameAttributeProvider) {
        this.usernameAttributeProvider = usernameAttributeProvider;
    }
}

