/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.transforms;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.util.RegexUtils;

public class BlockingPrincipalNameTransformer
implements PrincipalNameTransformer {
    private Pattern pattern;

    public BlockingPrincipalNameTransformer(String pattern) {
        this.setPattern(RegexUtils.createPattern(pattern));
    }

    public String transform(String username) {
        Matcher matcher = this.pattern.matcher(username);
        if (matcher.find()) {
            throw new PreventedException("Unable to accept username " + username);
        }
        return username.trim();
    }

    @Generated
    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }
}

